// third_party/blink/public/mojom/cookie_store/cookie_store.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom-params-data.h"
#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/cookie_store/cookie_store.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_COOKIE_STORE_COOKIE_STORE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_COOKIE_STORE_COOKIE_STORE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
CookieChangeSubscription::CookieChangeSubscription()
    : url(),
      match_type(),
      name() {}

CookieChangeSubscription::CookieChangeSubscription(
    const ::GURL& url_in,
    ::network::mojom::CookieMatchType match_type_in,
    const std::string& name_in)
    : url(std::move(url_in)),
      match_type(std::move(match_type_in)),
      name(std::move(name_in)) {}

CookieChangeSubscription::~CookieChangeSubscription() = default;

void CookieChangeSubscription::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_type"), this->match_type, 
      "<value of type ::network::mojom::CookieMatchType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const std::string&>");
}

bool CookieChangeSubscription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CookieStore::Name_[] = "blink.mojom.CookieStore";

class CookieStore_AddSubscriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieStore_AddSubscriptions_ForwardToCallback(
      CookieStore::AddSubscriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieStore::AddSubscriptionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieStore_AddSubscriptions_ForwardToCallback);
};

class CookieStore_RemoveSubscriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieStore_RemoveSubscriptions_ForwardToCallback(
      CookieStore::RemoveSubscriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieStore::RemoveSubscriptionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieStore_RemoveSubscriptions_ForwardToCallback);
};

class CookieStore_GetSubscriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieStore_GetSubscriptions_ForwardToCallback(
      CookieStore::GetSubscriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieStore::GetSubscriptionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieStore_GetSubscriptions_ForwardToCallback);
};

CookieStoreProxy::CookieStoreProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieStoreProxy::AddSubscriptions(
    int64_t in_service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> in_subscription, AddSubscriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CookieStore::AddSubscriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription"), in_subscription, 
                        "<value of type std::vector<CookieChangeSubscriptionPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieStore_AddSubscriptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_AddSubscriptions_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->subscription)::BaseType>
      subscription_fragment(params.message());
  const mojo::internal::ContainerValidateParams subscription_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieChangeSubscriptionDataView>>(
      in_subscription, subscription_fragment, &subscription_validate_params);
  params->subscription.Set(
      subscription_fragment.is_null() ? nullptr : subscription_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subscription.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subscription in CookieStore.AddSubscriptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("AddSubscriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieStore_AddSubscriptions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieStoreProxy::RemoveSubscriptions(
    int64_t in_service_worker_registration_id, std::vector<CookieChangeSubscriptionPtr> in_subscription, RemoveSubscriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CookieStore::RemoveSubscriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription"), in_subscription, 
                        "<value of type std::vector<CookieChangeSubscriptionPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieStore_RemoveSubscriptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_RemoveSubscriptions_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->subscription)::BaseType>
      subscription_fragment(params.message());
  const mojo::internal::ContainerValidateParams subscription_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieChangeSubscriptionDataView>>(
      in_subscription, subscription_fragment, &subscription_validate_params);
  params->subscription.Set(
      subscription_fragment.is_null() ? nullptr : subscription_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subscription.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subscription in CookieStore.RemoveSubscriptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("RemoveSubscriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieStore_RemoveSubscriptions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieStoreProxy::GetSubscriptions(
    int64_t in_service_worker_registration_id, GetSubscriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CookieStore::GetSubscriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieStore_GetSubscriptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_GetSubscriptions_Params_Data> params(
          message);
  params.Allocate();
  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("GetSubscriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieStore_GetSubscriptions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CookieStore_AddSubscriptions_ProxyToResponder {
 public:
  static CookieStore::AddSubscriptionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieStore_AddSubscriptions_ProxyToResponder> proxy(
        new CookieStore_AddSubscriptions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieStore_AddSubscriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieStore_AddSubscriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieStore_AddSubscriptions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieStore::AddSubscriptionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieStore_AddSubscriptions_ProxyToResponder);
};

bool CookieStore_AddSubscriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CookieStore::AddSubscriptionsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieStore_AddSubscriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieStore_AddSubscriptions_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  CookieStore_AddSubscriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieStore::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void CookieStore_AddSubscriptions_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CookieStore::AddSubscriptionsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieStore_AddSubscriptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_AddSubscriptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CookieStore::AddSubscriptionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("AddSubscriptions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieStore_RemoveSubscriptions_ProxyToResponder {
 public:
  static CookieStore::RemoveSubscriptionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieStore_RemoveSubscriptions_ProxyToResponder> proxy(
        new CookieStore_RemoveSubscriptions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieStore_RemoveSubscriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieStore_RemoveSubscriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieStore_RemoveSubscriptions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieStore::RemoveSubscriptionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieStore_RemoveSubscriptions_ProxyToResponder);
};

bool CookieStore_RemoveSubscriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CookieStore::RemoveSubscriptionsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieStore_RemoveSubscriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieStore_RemoveSubscriptions_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  CookieStore_RemoveSubscriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieStore::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void CookieStore_RemoveSubscriptions_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CookieStore::RemoveSubscriptionsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieStore_RemoveSubscriptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_RemoveSubscriptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CookieStore::RemoveSubscriptionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("RemoveSubscriptions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieStore_GetSubscriptions_ProxyToResponder {
 public:
  static CookieStore::GetSubscriptionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieStore_GetSubscriptions_ProxyToResponder> proxy(
        new CookieStore_GetSubscriptions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieStore_GetSubscriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieStore_GetSubscriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieStore_GetSubscriptions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieStore::GetSubscriptionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<CookieChangeSubscriptionPtr> in_subscriptions, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieStore_GetSubscriptions_ProxyToResponder);
};

bool CookieStore_GetSubscriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CookieStore::GetSubscriptionsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieStore_GetSubscriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieStore_GetSubscriptions_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<CookieChangeSubscriptionPtr> p_subscriptions{};
  bool p_success{};
  CookieStore_GetSubscriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSubscriptions(&p_subscriptions))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieStore::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_subscriptions), 
std::move(p_success));
  return true;
}

void CookieStore_GetSubscriptions_ProxyToResponder::Run(
    std::vector<CookieChangeSubscriptionPtr> in_subscriptions, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CookieStore::GetSubscriptionsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscriptions"), in_subscriptions, 
                        "<value of type std::vector<CookieChangeSubscriptionPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieStore_GetSubscriptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CookieStore_GetSubscriptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subscriptions)::BaseType>
      subscriptions_fragment(params.message());
  const mojo::internal::ContainerValidateParams subscriptions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieChangeSubscriptionDataView>>(
      in_subscriptions, subscriptions_fragment, &subscriptions_validate_params);
  params->subscriptions.Set(
      subscriptions_fragment.is_null() ? nullptr : subscriptions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->subscriptions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subscriptions in ");
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CookieStore::GetSubscriptionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieStore::Name_);
  message.set_method_name("GetSubscriptions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieStoreStubDispatch::Accept(
    CookieStore* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCookieStore_AddSubscriptions_Name: {
      break;
    }
    case internal::kCookieStore_RemoveSubscriptions_Name: {
      break;
    }
    case internal::kCookieStore_GetSubscriptions_Name: {
      break;
    }
  }
  return false;
}

// static
bool CookieStoreStubDispatch::AcceptWithResponder(
    CookieStore* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieStore_AddSubscriptions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CookieStore::AddSubscriptions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CookieStore::AddSubscriptions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieStore_AddSubscriptions_Params_Data* params =
          reinterpret_cast<
              internal::CookieStore_AddSubscriptions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      std::vector<CookieChangeSubscriptionPtr> p_subscription{};
      CookieStore_AddSubscriptions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadSubscription(&p_subscription))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieStore::Name_, 0, false);
        return false;
      }
      CookieStore::AddSubscriptionsCallback callback =
          CookieStore_AddSubscriptions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSubscriptions(
std::move(p_service_worker_registration_id), 
std::move(p_subscription), std::move(callback));
      return true;
    }
    case internal::kCookieStore_RemoveSubscriptions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CookieStore::RemoveSubscriptions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CookieStore::RemoveSubscriptions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieStore_RemoveSubscriptions_Params_Data* params =
          reinterpret_cast<
              internal::CookieStore_RemoveSubscriptions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      std::vector<CookieChangeSubscriptionPtr> p_subscription{};
      CookieStore_RemoveSubscriptions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadSubscription(&p_subscription))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieStore::Name_, 1, false);
        return false;
      }
      CookieStore::RemoveSubscriptionsCallback callback =
          CookieStore_RemoveSubscriptions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveSubscriptions(
std::move(p_service_worker_registration_id), 
std::move(p_subscription), std::move(callback));
      return true;
    }
    case internal::kCookieStore_GetSubscriptions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CookieStore::GetSubscriptions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CookieStore::GetSubscriptions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieStore_GetSubscriptions_Params_Data* params =
          reinterpret_cast<
              internal::CookieStore_GetSubscriptions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      CookieStore_GetSubscriptions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieStore::Name_, 2, false);
        return false;
      }
      CookieStore::GetSubscriptionsCallback callback =
          CookieStore_GetSubscriptions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSubscriptions(
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kCookieStoreValidationInfo[] = {
    {&internal::CookieStore_AddSubscriptions_Params_Data::Validate,
     &internal::CookieStore_AddSubscriptions_ResponseParams_Data::Validate},
    {&internal::CookieStore_RemoveSubscriptions_Params_Data::Validate,
     &internal::CookieStore_RemoveSubscriptions_ResponseParams_Data::Validate},
    {&internal::CookieStore_GetSubscriptions_Params_Data::Validate,
     &internal::CookieStore_GetSubscriptions_ResponseParams_Data::Validate},
};

bool CookieStoreRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::CookieStore::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kCookieStoreValidationInfo);
}

bool CookieStoreResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::CookieStore::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kCookieStoreValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::CookieChangeSubscription::DataView, ::blink::mojom::CookieChangeSubscriptionPtr>::Read(
    ::blink::mojom::CookieChangeSubscription::DataView input,
    ::blink::mojom::CookieChangeSubscriptionPtr* output) {
  bool success = true;
  ::blink::mojom::CookieChangeSubscriptionPtr result(::blink::mojom::CookieChangeSubscription::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMatchType(&result->match_type))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif