// third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string CredentialTypeToString(CredentialType value) {
  switch(value) {
    case CredentialType::EMPTY:
      return "CredentialType::EMPTY";
    case CredentialType::PASSWORD:
      return "CredentialType::PASSWORD";
    case CredentialType::FEDERATED:
      return "CredentialType::FEDERATED";
    default:
      return base::StringPrintf("Unknown CredentialType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CredentialType value) {
  return os << CredentialTypeToString(value);
}

std::string CredentialMediationRequirementToString(CredentialMediationRequirement value) {
  switch(value) {
    case CredentialMediationRequirement::kSilent:
      return "CredentialMediationRequirement::kSilent";
    case CredentialMediationRequirement::kOptional:
      return "CredentialMediationRequirement::kOptional";
    case CredentialMediationRequirement::kRequired:
      return "CredentialMediationRequirement::kRequired";
    default:
      return base::StringPrintf("Unknown CredentialMediationRequirement value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CredentialMediationRequirement value) {
  return os << CredentialMediationRequirementToString(value);
}

std::string CredentialManagerErrorToString(CredentialManagerError value) {
  switch(value) {
    case CredentialManagerError::SUCCESS:
      return "CredentialManagerError::SUCCESS";
    case CredentialManagerError::PENDING_REQUEST:
      return "CredentialManagerError::PENDING_REQUEST";
    case CredentialManagerError::PASSWORD_STORE_UNAVAILABLE:
      return "CredentialManagerError::PASSWORD_STORE_UNAVAILABLE";
    case CredentialManagerError::NOT_ALLOWED:
      return "CredentialManagerError::NOT_ALLOWED";
    case CredentialManagerError::INVALID_DOMAIN:
      return "CredentialManagerError::INVALID_DOMAIN";
    case CredentialManagerError::INVALID_ICON_URL:
      return "CredentialManagerError::INVALID_ICON_URL";
    case CredentialManagerError::CREDENTIAL_EXCLUDED:
      return "CredentialManagerError::CREDENTIAL_EXCLUDED";
    case CredentialManagerError::CREDENTIAL_NOT_RECOGNIZED:
      return "CredentialManagerError::CREDENTIAL_NOT_RECOGNIZED";
    case CredentialManagerError::NOT_IMPLEMENTED:
      return "CredentialManagerError::NOT_IMPLEMENTED";
    case CredentialManagerError::NOT_FOCUSED:
      return "CredentialManagerError::NOT_FOCUSED";
    case CredentialManagerError::RESIDENT_CREDENTIALS_UNSUPPORTED:
      return "CredentialManagerError::RESIDENT_CREDENTIALS_UNSUPPORTED";
    case CredentialManagerError::PROTECTION_POLICY_INCONSISTENT:
      return "CredentialManagerError::PROTECTION_POLICY_INCONSISTENT";
    case CredentialManagerError::ANDROID_ALGORITHM_UNSUPPORTED:
      return "CredentialManagerError::ANDROID_ALGORITHM_UNSUPPORTED";
    case CredentialManagerError::ANDROID_EMPTY_ALLOW_CREDENTIALS:
      return "CredentialManagerError::ANDROID_EMPTY_ALLOW_CREDENTIALS";
    case CredentialManagerError::ANDROID_NOT_SUPPORTED_ERROR:
      return "CredentialManagerError::ANDROID_NOT_SUPPORTED_ERROR";
    case CredentialManagerError::ANDROID_USER_VERIFICATION_UNSUPPORTED:
      return "CredentialManagerError::ANDROID_USER_VERIFICATION_UNSUPPORTED";
    case CredentialManagerError::ABORT:
      return "CredentialManagerError::ABORT";
    case CredentialManagerError::OPAQUE_DOMAIN:
      return "CredentialManagerError::OPAQUE_DOMAIN";
    case CredentialManagerError::INVALID_PROTOCOL:
      return "CredentialManagerError::INVALID_PROTOCOL";
    case CredentialManagerError::BAD_RELYING_PARTY_ID:
      return "CredentialManagerError::BAD_RELYING_PARTY_ID";
    case CredentialManagerError::CANNOT_READ_AND_WRITE_LARGE_BLOB:
      return "CredentialManagerError::CANNOT_READ_AND_WRITE_LARGE_BLOB";
    case CredentialManagerError::INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB:
      return "CredentialManagerError::INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB";
    case CredentialManagerError::UNKNOWN:
      return "CredentialManagerError::UNKNOWN";
    default:
      return base::StringPrintf("Unknown CredentialManagerError value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CredentialManagerError value) {
  return os << CredentialManagerErrorToString(value);
}

namespace internal {


// static
bool CredentialInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialInfo_Data* object = static_cast<const CredentialInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CredentialType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->password, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->federation, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->federation, validation_context))
    return false;

  return true;
}

CredentialInfo_Data::CredentialInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Store_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Store_Params_Data* object = static_cast<const CredentialManager_Store_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

CredentialManager_Store_Params_Data::CredentialManager_Store_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Store_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Store_ResponseParams_Data* object = static_cast<const CredentialManager_Store_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CredentialManager_Store_ResponseParams_Data::CredentialManager_Store_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_PreventSilentAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_PreventSilentAccess_Params_Data* object = static_cast<const CredentialManager_PreventSilentAccess_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CredentialManager_PreventSilentAccess_Params_Data::CredentialManager_PreventSilentAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_PreventSilentAccess_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_PreventSilentAccess_ResponseParams_Data* object = static_cast<const CredentialManager_PreventSilentAccess_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CredentialManager_PreventSilentAccess_ResponseParams_Data::CredentialManager_PreventSilentAccess_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Get_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Get_Params_Data* object = static_cast<const CredentialManager_Get_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CredentialMediationRequirement_Data
        ::Validate(object->mediation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->federations, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams federations_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->federations, validation_context,
                                         &federations_validate_params)) {
    return false;
  }

  return true;
}

CredentialManager_Get_Params_Data::CredentialManager_Get_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Get_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Get_ResponseParams_Data* object = static_cast<const CredentialManager_Get_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CredentialManagerError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

CredentialManager_Get_ResponseParams_Data::CredentialManager_Get_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::CredentialType value) {
  return std::move(context).WriteString(::blink::mojom::CredentialTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialMediationRequirement>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::CredentialMediationRequirement value) {
  return std::move(context).WriteString(::blink::mojom::CredentialMediationRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialManagerError>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::CredentialManagerError value) {
  return std::move(context).WriteString(::blink::mojom::CredentialManagerErrorToString(value));
}

} // namespace perfetto
