// third_party/blink/public/mojom/devtools/console_message.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/console_message.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string ConsoleMessageLevelToString(ConsoleMessageLevel value) {
  switch(value) {
    case ConsoleMessageLevel::kVerbose:
      return "ConsoleMessageLevel::kVerbose";
    case ConsoleMessageLevel::kInfo:
      return "ConsoleMessageLevel::kInfo";
    case ConsoleMessageLevel::kWarning:
      return "ConsoleMessageLevel::kWarning";
    case ConsoleMessageLevel::kError:
      return "ConsoleMessageLevel::kError";
    default:
      return base::StringPrintf("Unknown ConsoleMessageLevel value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ConsoleMessageLevel value) {
  return os << ConsoleMessageLevelToString(value);
}

std::string ConsoleMessageSourceToString(ConsoleMessageSource value) {
  switch(value) {
    case ConsoleMessageSource::kXml:
      return "ConsoleMessageSource::kXml";
    case ConsoleMessageSource::kJavaScript:
      return "ConsoleMessageSource::kJavaScript";
    case ConsoleMessageSource::kNetwork:
      return "ConsoleMessageSource::kNetwork";
    case ConsoleMessageSource::kConsoleApi:
      return "ConsoleMessageSource::kConsoleApi";
    case ConsoleMessageSource::kStorage:
      return "ConsoleMessageSource::kStorage";
    case ConsoleMessageSource::kAppCache:
      return "ConsoleMessageSource::kAppCache";
    case ConsoleMessageSource::kRendering:
      return "ConsoleMessageSource::kRendering";
    case ConsoleMessageSource::kSecurity:
      return "ConsoleMessageSource::kSecurity";
    case ConsoleMessageSource::kOther:
      return "ConsoleMessageSource::kOther";
    case ConsoleMessageSource::kDeprecation:
      return "ConsoleMessageSource::kDeprecation";
    case ConsoleMessageSource::kWorker:
      return "ConsoleMessageSource::kWorker";
    case ConsoleMessageSource::kViolation:
      return "ConsoleMessageSource::kViolation";
    case ConsoleMessageSource::kIntervention:
      return "ConsoleMessageSource::kIntervention";
    case ConsoleMessageSource::kRecommendation:
      return "ConsoleMessageSource::kRecommendation";
    default:
      return base::StringPrintf("Unknown ConsoleMessageSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ConsoleMessageSource value) {
  return os << ConsoleMessageSourceToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ConsoleMessageLevel>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ConsoleMessageLevel value) {
  return std::move(context).WriteString(::blink::mojom::ConsoleMessageLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ConsoleMessageSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ConsoleMessageSource value) {
  return std::move(context).WriteString(::blink::mojom::ConsoleMessageSourceToString(value));
}

} // namespace perfetto
