// third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string InspectorIssueCodeToString(InspectorIssueCode value) {
  switch(value) {
    case InspectorIssueCode::kSameSiteCookieIssue:
      return "InspectorIssueCode::kSameSiteCookieIssue";
    case InspectorIssueCode::kMixedContentIssue:
      return "InspectorIssueCode::kMixedContentIssue";
    case InspectorIssueCode::kBlockedByResponseIssue:
      return "InspectorIssueCode::kBlockedByResponseIssue";
    case InspectorIssueCode::kContentSecurityPolicyIssue:
      return "InspectorIssueCode::kContentSecurityPolicyIssue";
    case InspectorIssueCode::kSharedArrayBufferIssue:
      return "InspectorIssueCode::kSharedArrayBufferIssue";
    case InspectorIssueCode::kTrustedWebActivityIssue:
      return "InspectorIssueCode::kTrustedWebActivityIssue";
    case InspectorIssueCode::kHeavyAdIssue:
      return "InspectorIssueCode::kHeavyAdIssue";
    case InspectorIssueCode::kLowTextContrastIssue:
      return "InspectorIssueCode::kLowTextContrastIssue";
    default:
      return base::StringPrintf("Unknown InspectorIssueCode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InspectorIssueCode value) {
  return os << InspectorIssueCodeToString(value);
}

std::string HeavyAdResolutionStatusToString(HeavyAdResolutionStatus value) {
  switch(value) {
    case HeavyAdResolutionStatus::kHeavyAdBlocked:
      return "HeavyAdResolutionStatus::kHeavyAdBlocked";
    case HeavyAdResolutionStatus::kHeavyAdWarning:
      return "HeavyAdResolutionStatus::kHeavyAdWarning";
    default:
      return base::StringPrintf("Unknown HeavyAdResolutionStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, HeavyAdResolutionStatus value) {
  return os << HeavyAdResolutionStatusToString(value);
}

std::string HeavyAdReasonToString(HeavyAdReason value) {
  switch(value) {
    case HeavyAdReason::kNetworkTotalLimit:
      return "HeavyAdReason::kNetworkTotalLimit";
    case HeavyAdReason::kCpuTotalLimit:
      return "HeavyAdReason::kCpuTotalLimit";
    case HeavyAdReason::kCpuPeakLimit:
      return "HeavyAdReason::kCpuPeakLimit";
    default:
      return base::StringPrintf("Unknown HeavyAdReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, HeavyAdReason value) {
  return os << HeavyAdReasonToString(value);
}

std::string MixedContentResolutionStatusToString(MixedContentResolutionStatus value) {
  switch(value) {
    case MixedContentResolutionStatus::kMixedContentBlocked:
      return "MixedContentResolutionStatus::kMixedContentBlocked";
    case MixedContentResolutionStatus::kMixedContentAutomaticallyUpgraded:
      return "MixedContentResolutionStatus::kMixedContentAutomaticallyUpgraded";
    case MixedContentResolutionStatus::kMixedContentWarning:
      return "MixedContentResolutionStatus::kMixedContentWarning";
    default:
      return base::StringPrintf("Unknown MixedContentResolutionStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MixedContentResolutionStatus value) {
  return os << MixedContentResolutionStatusToString(value);
}

std::string ContentSecurityPolicyViolationTypeToString(ContentSecurityPolicyViolationType value) {
  switch(value) {
    case ContentSecurityPolicyViolationType::kInlineViolation:
      return "ContentSecurityPolicyViolationType::kInlineViolation";
    case ContentSecurityPolicyViolationType::kEvalViolation:
      return "ContentSecurityPolicyViolationType::kEvalViolation";
    case ContentSecurityPolicyViolationType::kURLViolation:
      return "ContentSecurityPolicyViolationType::kURLViolation";
    case ContentSecurityPolicyViolationType::kTrustedTypesSinkViolation:
      return "ContentSecurityPolicyViolationType::kTrustedTypesSinkViolation";
    case ContentSecurityPolicyViolationType::kTrustedTypesPolicyViolation:
      return "ContentSecurityPolicyViolationType::kTrustedTypesPolicyViolation";
    default:
      return base::StringPrintf("Unknown ContentSecurityPolicyViolationType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyViolationType value) {
  return os << ContentSecurityPolicyViolationTypeToString(value);
}

std::string SameSiteCookieOperationToString(SameSiteCookieOperation value) {
  switch(value) {
    case SameSiteCookieOperation::kSetCookie:
      return "SameSiteCookieOperation::kSetCookie";
    case SameSiteCookieOperation::kReadCookie:
      return "SameSiteCookieOperation::kReadCookie";
    default:
      return base::StringPrintf("Unknown SameSiteCookieOperation value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SameSiteCookieOperation value) {
  return os << SameSiteCookieOperationToString(value);
}

std::string SameSiteCookieExclusionReasonToString(SameSiteCookieExclusionReason value) {
  switch(value) {
    case SameSiteCookieExclusionReason::kExcludeSameSiteUnspecifiedTreatedAsLax:
      return "SameSiteCookieExclusionReason::kExcludeSameSiteUnspecifiedTreatedAsLax";
    case SameSiteCookieExclusionReason::kExcludeSameSiteNoneInsecure:
      return "SameSiteCookieExclusionReason::kExcludeSameSiteNoneInsecure";
    case SameSiteCookieExclusionReason::kExcludeSameSiteLax:
      return "SameSiteCookieExclusionReason::kExcludeSameSiteLax";
    case SameSiteCookieExclusionReason::kExcludeSameSiteStrict:
      return "SameSiteCookieExclusionReason::kExcludeSameSiteStrict";
    default:
      return base::StringPrintf("Unknown SameSiteCookieExclusionReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SameSiteCookieExclusionReason value) {
  return os << SameSiteCookieExclusionReasonToString(value);
}

std::string SameSiteCookieWarningReasonToString(SameSiteCookieWarningReason value) {
  switch(value) {
    case SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedCrossSiteContext:
      return "SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedCrossSiteContext";
    case SameSiteCookieWarningReason::kWarnSameSiteNoneInsecure:
      return "SameSiteCookieWarningReason::kWarnSameSiteNoneInsecure";
    case SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedLaxAllowUnsafe:
      return "SameSiteCookieWarningReason::kWarnSameSiteUnspecifiedLaxAllowUnsafe";
    case SameSiteCookieWarningReason::kWarnSameSiteStrictLaxDowngradeStrict:
      return "SameSiteCookieWarningReason::kWarnSameSiteStrictLaxDowngradeStrict";
    case SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeStrict:
      return "SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeStrict";
    case SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeLax:
      return "SameSiteCookieWarningReason::kWarnSameSiteStrictCrossDowngradeLax";
    case SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeStrict:
      return "SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeStrict";
    case SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeLax:
      return "SameSiteCookieWarningReason::kWarnSameSiteLaxCrossDowngradeLax";
    default:
      return base::StringPrintf("Unknown SameSiteCookieWarningReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SameSiteCookieWarningReason value) {
  return os << SameSiteCookieWarningReasonToString(value);
}

std::string SharedArrayBufferIssueTypeToString(SharedArrayBufferIssueType value) {
  switch(value) {
    case SharedArrayBufferIssueType::kTransferIssue:
      return "SharedArrayBufferIssueType::kTransferIssue";
    case SharedArrayBufferIssueType::kCreationIssue:
      return "SharedArrayBufferIssueType::kCreationIssue";
    default:
      return base::StringPrintf("Unknown SharedArrayBufferIssueType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SharedArrayBufferIssueType value) {
  return os << SharedArrayBufferIssueTypeToString(value);
}

std::string TwaQualityEnforcementViolationTypeToString(TwaQualityEnforcementViolationType value) {
  switch(value) {
    case TwaQualityEnforcementViolationType::kHttpError:
      return "TwaQualityEnforcementViolationType::kHttpError";
    case TwaQualityEnforcementViolationType::kUnavailableOffline:
      return "TwaQualityEnforcementViolationType::kUnavailableOffline";
    case TwaQualityEnforcementViolationType::kDigitalAssetLinks:
      return "TwaQualityEnforcementViolationType::kDigitalAssetLinks";
    default:
      return base::StringPrintf("Unknown TwaQualityEnforcementViolationType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TwaQualityEnforcementViolationType value) {
  return os << TwaQualityEnforcementViolationTypeToString(value);
}

namespace internal {


// static
bool AffectedCookie_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AffectedCookie_Data* object = static_cast<const AffectedCookie_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams domain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  return true;
}

AffectedCookie_Data::AffectedCookie_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AffectedRequest_Data* object = static_cast<const AffectedRequest_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->request_id, validation_context,
                                         &request_id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

AffectedRequest_Data::AffectedRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AffectedFrame_Data* object = static_cast<const AffectedFrame_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams frame_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->frame_id, validation_context,
                                         &frame_id_validate_params)) {
    return false;
  }

  return true;
}

AffectedFrame_Data::AffectedFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedLocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AffectedLocation_Data* object = static_cast<const AffectedLocation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams script_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->script_id, validation_context,
                                         &script_id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

AffectedLocation_Data::AffectedLocation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlockedByResponseIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BlockedByResponseIssueDetails_Data* object = static_cast<const BlockedByResponseIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parentFrame, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blockedFrame, validation_context))
    return false;


  if (!::network::mojom::internal::BlockedByResponseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

BlockedByResponseIssueDetails_Data::BlockedByResponseIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HeavyAdIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HeavyAdIssueDetails_Data* object = static_cast<const HeavyAdIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::HeavyAdResolutionStatus_Data
        ::Validate(object->resolution, validation_context))
    return false;


  if (!::blink::mojom::internal::HeavyAdReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

HeavyAdIssueDetails_Data::HeavyAdIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MixedContentIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MixedContentIssueDetails_Data* object = static_cast<const MixedContentIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->request_context, validation_context))
    return false;


  if (!::blink::mojom::internal::MixedContentResolutionStatus_Data
        ::Validate(object->resolution_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->insecure_url, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams insecure_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->insecure_url, validation_context,
                                         &insecure_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_resource_url, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams main_resource_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->main_resource_url, validation_context,
                                         &main_resource_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

MixedContentIssueDetails_Data::MixedContentIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSecurityPolicyIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSecurityPolicyIssueDetails_Data* object = static_cast<const ContentSecurityPolicyIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->violated_directive, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams violated_directive_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->violated_directive, validation_context,
                                         &violated_directive_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ContentSecurityPolicyViolationType_Data
        ::Validate(object->content_security_policy_violation_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame_ancestor, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->affected_location, validation_context))
    return false;

  return true;
}

ContentSecurityPolicyIssueDetails_Data::ContentSecurityPolicyIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SameSiteCookieIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SameSiteCookieIssueDetails_Data* object = static_cast<const SameSiteCookieIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exclusion_reason, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams exclusion_reason_validate_params(
      0, ::blink::mojom::internal::SameSiteCookieExclusionReason_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->exclusion_reason, validation_context,
                                         &exclusion_reason_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->warning_reason, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams warning_reason_validate_params(
      0, ::blink::mojom::internal::SameSiteCookieWarningReason_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->warning_reason, validation_context,
                                         &warning_reason_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::SameSiteCookieOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cookie_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

SameSiteCookieIssueDetails_Data::SameSiteCookieIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedArrayBufferIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SharedArrayBufferIssueDetails_Data* object = static_cast<const SharedArrayBufferIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->affected_location, validation_context))
    return false;


  if (!::blink::mojom::internal::SharedArrayBufferIssueType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

SharedArrayBufferIssueDetails_Data::SharedArrayBufferIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedWebActivityIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TrustedWebActivityIssueDetails_Data* object = static_cast<const TrustedWebActivityIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::blink::mojom::internal::TwaQualityEnforcementViolationType_Data
        ::Validate(object->violation_type, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams package_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->package_name, validation_context,
                                         &package_name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  return true;
}

TrustedWebActivityIssueDetails_Data::TrustedWebActivityIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LowTextContrastIssue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LowTextContrastIssue_Data* object = static_cast<const LowTextContrastIssue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->violating_node_selector, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams violating_node_selector_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->violating_node_selector, validation_context,
                                         &violating_node_selector_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_size, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams font_size_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->font_size, validation_context,
                                         &font_size_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_weight, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams font_weight_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->font_weight, validation_context,
                                         &font_weight_validate_params)) {
    return false;
  }

  return true;
}

LowTextContrastIssue_Data::LowTextContrastIssue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspectorIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InspectorIssueDetails_Data* object = static_cast<const InspectorIssueDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->samesite_cookie_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mixed_content_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blocked_by_response_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->csp_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sab_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->twa_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->heavy_ad_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->low_text_contrast_details, validation_context))
    return false;

  return true;
}

InspectorIssueDetails_Data::InspectorIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspectorIssueInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InspectorIssueInfo_Data* object = static_cast<const InspectorIssueInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::InspectorIssueCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

InspectorIssueInfo_Data::InspectorIssueInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InspectorIssueCode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::InspectorIssueCode value) {
  return std::move(context).WriteString(::blink::mojom::InspectorIssueCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::HeavyAdResolutionStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::HeavyAdResolutionStatus value) {
  return std::move(context).WriteString(::blink::mojom::HeavyAdResolutionStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::HeavyAdReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::HeavyAdReason value) {
  return std::move(context).WriteString(::blink::mojom::HeavyAdReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::MixedContentResolutionStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::MixedContentResolutionStatus value) {
  return std::move(context).WriteString(::blink::mojom::MixedContentResolutionStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ContentSecurityPolicyViolationType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ContentSecurityPolicyViolationType value) {
  return std::move(context).WriteString(::blink::mojom::ContentSecurityPolicyViolationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SameSiteCookieOperation>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::SameSiteCookieOperation value) {
  return std::move(context).WriteString(::blink::mojom::SameSiteCookieOperationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SameSiteCookieExclusionReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::SameSiteCookieExclusionReason value) {
  return std::move(context).WriteString(::blink::mojom::SameSiteCookieExclusionReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SameSiteCookieWarningReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::SameSiteCookieWarningReason value) {
  return std::move(context).WriteString(::blink::mojom::SameSiteCookieWarningReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SharedArrayBufferIssueType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::SharedArrayBufferIssueType value) {
  return std::move(context).WriteString(::blink::mojom::SharedArrayBufferIssueTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::TwaQualityEnforcementViolationType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::TwaQualityEnforcementViolationType value) {
  return std::move(context).WriteString(::blink::mojom::TwaQualityEnforcementViolationTypeToString(value));
}

} // namespace perfetto
