// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool DirectSocketOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DirectSocketOptions_Data* object = static_cast<const DirectSocketOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams local_hostname_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->local_hostname, validation_context,
                                         &local_hostname_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams remote_hostname_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->remote_hostname, validation_context,
                                         &remote_hostname_validate_params)) {
    return false;
  }

  return true;
}

DirectSocketOptions_Data::DirectSocketOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenTcpSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DirectSocketsService_OpenTcpSocket_Params_Data* object = static_cast<const DirectSocketsService_OpenTcpSocket_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenTcpSocket_Params_Data::DirectSocketsService_OpenTcpSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenTcpSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DirectSocketsService_OpenTcpSocket_ResponseParams_Data* object = static_cast<const DirectSocketsService_OpenTcpSocket_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peer_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenTcpSocket_ResponseParams_Data::DirectSocketsService_OpenTcpSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenUdpSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DirectSocketsService_OpenUdpSocket_Params_Data* object = static_cast<const DirectSocketsService_OpenUdpSocket_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DirectSocketsService_OpenUdpSocket_Params_Data::DirectSocketsService_OpenUdpSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectSocketsService_OpenUdpSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DirectSocketsService_OpenUdpSocket_ResponseParams_Data* object = static_cast<const DirectSocketsService_OpenUdpSocket_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peer_addr, validation_context))
    return false;

  return true;
}

DirectSocketsService_OpenUdpSocket_ResponseParams_Data::DirectSocketsService_OpenUdpSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
