// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-params-data.h"
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
DirectSocketOptions::DirectSocketOptions()
    : local_hostname(),
      local_port(0U),
      remote_hostname(),
      remote_port(0U),
      send_buffer_size(0),
      receive_buffer_size(0),
      no_delay(false) {}

DirectSocketOptions::DirectSocketOptions(
    const base::Optional<std::string>& local_hostname_in,
    uint16_t local_port_in,
    const base::Optional<std::string>& remote_hostname_in,
    uint16_t remote_port_in,
    int32_t send_buffer_size_in,
    int32_t receive_buffer_size_in,
    bool no_delay_in)
    : local_hostname(std::move(local_hostname_in)),
      local_port(std::move(local_port_in)),
      remote_hostname(std::move(remote_hostname_in)),
      remote_port(std::move(remote_port_in)),
      send_buffer_size(std::move(send_buffer_size_in)),
      receive_buffer_size(std::move(receive_buffer_size_in)),
      no_delay(std::move(no_delay_in)) {}

DirectSocketOptions::~DirectSocketOptions() = default;

void DirectSocketOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_hostname"), this->local_hostname, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_port"), this->local_port, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_hostname"), this->remote_hostname, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_port"), this->remote_port, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_buffer_size"), this->send_buffer_size, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_buffer_size"), this->receive_buffer_size, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_delay"), this->no_delay, 
      "<value of type bool>");
}

bool DirectSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DirectSocketsService::Name_[] = "blink.mojom.DirectSocketsService";

class DirectSocketsService_OpenTcpSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DirectSocketsService_OpenTcpSocket_ForwardToCallback(
      DirectSocketsService::OpenTcpSocketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DirectSocketsService::OpenTcpSocketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DirectSocketsService_OpenTcpSocket_ForwardToCallback);
};

class DirectSocketsService_OpenUdpSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DirectSocketsService_OpenUdpSocket_ForwardToCallback(
      DirectSocketsService::OpenUdpSocketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DirectSocketsService::OpenUdpSocketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DirectSocketsService_OpenUdpSocket_ForwardToCallback);
};

DirectSocketsServiceProxy::DirectSocketsServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DirectSocketsServiceProxy::OpenTcpSocket(
    DirectSocketOptionsPtr in_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::SocketObserver> in_observer, OpenTcpSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DirectSocketsService::OpenTcpSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type DirectSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation, 
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<::network::mojom::SocketObserver>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDirectSocketsService_OpenTcpSocket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenTcpSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DirectSocketOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in DirectSocketsService.OpenTcpSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in DirectSocketsService.OpenTcpSocket request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DirectSocketsService.OpenTcpSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenTcpSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DirectSocketsService_OpenTcpSocket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DirectSocketsServiceProxy::OpenUdpSocket(
    DirectSocketOptionsPtr in_options, ::mojo::PendingReceiver<::network::mojom::UDPSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> in_listener, OpenUdpSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DirectSocketsService::OpenUdpSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type DirectSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::UDPSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener, 
                        "<value of type ::mojo::PendingRemote<::network::mojom::UDPSocketListener>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDirectSocketsService_OpenUdpSocket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenUdpSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DirectSocketOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in DirectSocketsService.OpenUdpSocket request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::UDPSocketInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DirectSocketsService.OpenUdpSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::UDPSocketListenerInterfaceBase>>(
      in_listener, &params->listener, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenUdpSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DirectSocketsService_OpenUdpSocket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DirectSocketsService_OpenTcpSocket_ProxyToResponder {
 public:
  static DirectSocketsService::OpenTcpSocketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DirectSocketsService_OpenTcpSocket_ProxyToResponder> proxy(
        new DirectSocketsService_OpenTcpSocket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DirectSocketsService_OpenTcpSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DirectSocketsService_OpenTcpSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DirectSocketsService_OpenTcpSocket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DirectSocketsService::OpenTcpSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DirectSocketsService_OpenTcpSocket_ProxyToResponder);
};

bool DirectSocketsService_OpenTcpSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DirectSocketsService::OpenTcpSocketCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DirectSocketsService_OpenTcpSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DirectSocketsService_OpenTcpSocket_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_result{};
  base::Optional<::net::IPEndPoint> p_local_addr{};
  base::Optional<::net::IPEndPoint> p_peer_addr{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  DirectSocketsService_OpenTcpSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DirectSocketsService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr), 
std::move(p_peer_addr), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  return true;
}

void DirectSocketsService_OpenTcpSocket_ProxyToResponder::Run(
    int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DirectSocketsService::OpenTcpSocketCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr, 
                        "<value of type const base::Optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr, 
                        "<value of type const base::Optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream, 
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDirectSocketsService_OpenTcpSocket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenTcpSocket_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, local_addr_fragment);
  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_peer_addr, peer_addr_fragment);
  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &params.message());
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DirectSocketsService::OpenTcpSocketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenTcpSocket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DirectSocketsService_OpenUdpSocket_ProxyToResponder {
 public:
  static DirectSocketsService::OpenUdpSocketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DirectSocketsService_OpenUdpSocket_ProxyToResponder> proxy(
        new DirectSocketsService_OpenUdpSocket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DirectSocketsService_OpenUdpSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DirectSocketsService_OpenUdpSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DirectSocketsService_OpenUdpSocket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DirectSocketsService::OpenUdpSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DirectSocketsService_OpenUdpSocket_ProxyToResponder);
};

bool DirectSocketsService_OpenUdpSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DirectSocketsService::OpenUdpSocketCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DirectSocketsService_OpenUdpSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DirectSocketsService_OpenUdpSocket_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_result{};
  base::Optional<::net::IPEndPoint> p_local_addr{};
  base::Optional<::net::IPEndPoint> p_peer_addr{};
  DirectSocketsService_OpenUdpSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DirectSocketsService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr), 
std::move(p_peer_addr));
  return true;
}

void DirectSocketsService_OpenUdpSocket_ProxyToResponder::Run(
    int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DirectSocketsService::OpenUdpSocketCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr, 
                        "<value of type const base::Optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr, 
                        "<value of type const base::Optional<::net::IPEndPoint>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDirectSocketsService_OpenUdpSocket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DirectSocketsService_OpenUdpSocket_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, local_addr_fragment);
  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_peer_addr, peer_addr_fragment);
  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DirectSocketsService::OpenUdpSocketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DirectSocketsService::Name_);
  message.set_method_name("OpenUdpSocket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DirectSocketsServiceStubDispatch::Accept(
    DirectSocketsService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDirectSocketsService_OpenTcpSocket_Name: {
      break;
    }
    case internal::kDirectSocketsService_OpenUdpSocket_Name: {
      break;
    }
  }
  return false;
}

// static
bool DirectSocketsServiceStubDispatch::AcceptWithResponder(
    DirectSocketsService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDirectSocketsService_OpenTcpSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DirectSocketsService::OpenTcpSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DirectSocketsService::OpenTcpSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DirectSocketsService_OpenTcpSocket_Params_Data* params =
          reinterpret_cast<
              internal::DirectSocketsService_OpenTcpSocket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DirectSocketOptionsPtr p_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::SocketObserver> p_observer{};
      DirectSocketsService_OpenTcpSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DirectSocketsService::Name_, 0, false);
        return false;
      }
      DirectSocketsService::OpenTcpSocketCallback callback =
          DirectSocketsService_OpenTcpSocket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenTcpSocket(
std::move(p_options), 
std::move(p_traffic_annotation), 
std::move(p_receiver), 
std::move(p_observer), std::move(callback));
      return true;
    }
    case internal::kDirectSocketsService_OpenUdpSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DirectSocketsService::OpenUdpSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DirectSocketsService::OpenUdpSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DirectSocketsService_OpenUdpSocket_Params_Data* params =
          reinterpret_cast<
              internal::DirectSocketsService_OpenUdpSocket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DirectSocketOptionsPtr p_options{};
      ::mojo::PendingReceiver<::network::mojom::UDPSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::UDPSocketListener> p_listener{};
      DirectSocketsService_OpenUdpSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DirectSocketsService::Name_, 1, false);
        return false;
      }
      DirectSocketsService::OpenUdpSocketCallback callback =
          DirectSocketsService_OpenUdpSocket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenUdpSocket(
std::move(p_options), 
std::move(p_receiver), 
std::move(p_listener), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDirectSocketsServiceValidationInfo[] = {
    {&internal::DirectSocketsService_OpenTcpSocket_Params_Data::Validate,
     &internal::DirectSocketsService_OpenTcpSocket_ResponseParams_Data::Validate},
    {&internal::DirectSocketsService_OpenUdpSocket_Params_Data::Validate,
     &internal::DirectSocketsService_OpenUdpSocket_ResponseParams_Data::Validate},
};

bool DirectSocketsServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::DirectSocketsService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDirectSocketsServiceValidationInfo);
}

bool DirectSocketsServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::DirectSocketsService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDirectSocketsServiceValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::DirectSocketOptions::DataView, ::blink::mojom::DirectSocketOptionsPtr>::Read(
    ::blink::mojom::DirectSocketOptions::DataView input,
    ::blink::mojom::DirectSocketOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::DirectSocketOptionsPtr result(::blink::mojom::DirectSocketOptions::New());
  
      if (success && !input.ReadLocalHostname(&result->local_hostname))
        success = false;
      if (success)
        result->local_port = input.local_port();
      if (success && !input.ReadRemoteHostname(&result->remote_hostname))
        success = false;
      if (success)
        result->remote_port = input.remote_port();
      if (success)
        result->send_buffer_size = input.send_buffer_size();
      if (success)
        result->receive_buffer_size = input.receive_buffer_size();
      if (success)
        result->no_delay = input.no_delay();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif