// third_party/blink/public/mojom/document_metadata/document_metadata.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-params-data.h"
#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOCUMENT_METADATA_DOCUMENT_METADATA_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOCUMENT_METADATA_DOCUMENT_METADATA_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
WebPage::WebPage()
    : url(),
      title(),
      entities() {}

WebPage::WebPage(
    const ::blink::KURL& url_in,
    const WTF::String& title_in,
    WTF::Vector<::schema_org::mojom::blink::EntityPtr> entities_in)
    : url(std::move(url_in)),
      title(std::move(title_in)),
      entities(std::move(entities_in)) {}

WebPage::~WebPage() = default;

void WebPage::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entities"), this->entities, 
      "<value of type WTF::Vector<::schema_org::mojom::blink::EntityPtr>>");
}

bool WebPage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DocumentMetadata::Name_[] = "blink.mojom.DocumentMetadata";

class DocumentMetadata_GetEntities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DocumentMetadata_GetEntities_ForwardToCallback(
      DocumentMetadata::GetEntitiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DocumentMetadata::GetEntitiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DocumentMetadata_GetEntities_ForwardToCallback);
};

DocumentMetadataProxy::DocumentMetadataProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DocumentMetadataProxy::GetEntities(
    GetEntitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DocumentMetadata::GetEntities");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentMetadata_GetEntities_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DocumentMetadata_GetEntities_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentMetadata::Name_);
  message.set_method_name("GetEntities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DocumentMetadata_GetEntities_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DocumentMetadata_GetEntities_ProxyToResponder {
 public:
  static DocumentMetadata::GetEntitiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DocumentMetadata_GetEntities_ProxyToResponder> proxy(
        new DocumentMetadata_GetEntities_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DocumentMetadata_GetEntities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DocumentMetadata_GetEntities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DocumentMetadata_GetEntities_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DocumentMetadata::GetEntitiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebPagePtr in_page);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DocumentMetadata_GetEntities_ProxyToResponder);
};

bool DocumentMetadata_GetEntities_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DocumentMetadata::GetEntitiesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DocumentMetadata_GetEntities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DocumentMetadata_GetEntities_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WebPagePtr p_page{};
  DocumentMetadata_GetEntities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPage(&p_page))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DocumentMetadata::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_page));
  return true;
}

void DocumentMetadata_GetEntities_ProxyToResponder::Run(
    WebPagePtr in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DocumentMetadata::GetEntitiesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page, 
                        "<value of type WebPagePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentMetadata_GetEntities_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DocumentMetadata_GetEntities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page)::BaseType> page_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WebPageDataView>(
      in_page, page_fragment);
  params->page.Set(
      page_fragment.is_null() ? nullptr : page_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DocumentMetadata::GetEntitiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentMetadata::Name_);
  message.set_method_name("GetEntities");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DocumentMetadataStubDispatch::Accept(
    DocumentMetadata* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDocumentMetadata_GetEntities_Name: {
      break;
    }
  }
  return false;
}

// static
bool DocumentMetadataStubDispatch::AcceptWithResponder(
    DocumentMetadata* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDocumentMetadata_GetEntities_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DocumentMetadata::GetEntities",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DocumentMetadata::GetEntities");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DocumentMetadata_GetEntities_Params_Data* params =
          reinterpret_cast<
              internal::DocumentMetadata_GetEntities_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DocumentMetadata_GetEntities_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentMetadata::Name_, 0, false);
        return false;
      }
      DocumentMetadata::GetEntitiesCallback callback =
          DocumentMetadata_GetEntities_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntities(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDocumentMetadataValidationInfo[] = {
    {&internal::DocumentMetadata_GetEntities_Params_Data::Validate,
     &internal::DocumentMetadata_GetEntities_ResponseParams_Data::Validate},
};

bool DocumentMetadataRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DocumentMetadata::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDocumentMetadataValidationInfo);
}

bool DocumentMetadataResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DocumentMetadata::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDocumentMetadataValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::WebPage::DataView, ::blink::mojom::blink::WebPagePtr>::Read(
    ::blink::mojom::blink::WebPage::DataView input,
    ::blink::mojom::blink::WebPagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPagePtr result(::blink::mojom::blink::WebPage::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadEntities(&result->entities))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif