// third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string FaviconIconTypeToString(FaviconIconType value) {
  switch(value) {
    case FaviconIconType::kInvalid:
      return "FaviconIconType::kInvalid";
    case FaviconIconType::kFavicon:
      return "FaviconIconType::kFavicon";
    case FaviconIconType::kTouchIcon:
      return "FaviconIconType::kTouchIcon";
    case FaviconIconType::kTouchPrecomposedIcon:
      return "FaviconIconType::kTouchPrecomposedIcon";
    default:
      return base::StringPrintf("Unknown FaviconIconType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FaviconIconType value) {
  return os << FaviconIconTypeToString(value);
}

namespace internal {


// static
bool FaviconURL_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FaviconURL_Data* object = static_cast<const FaviconURL_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_url, validation_context))
    return false;


  if (!::blink::mojom::internal::FaviconIconType_Data
        ::Validate(object->icon_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_sizes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams icon_sizes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->icon_sizes, validation_context,
                                         &icon_sizes_validate_params)) {
    return false;
  }

  return true;
}

FaviconURL_Data::FaviconURL_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FaviconIconType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::FaviconIconType value) {
  return std::move(context).WriteString(::blink::mojom::FaviconIconTypeToString(value));
}

} // namespace perfetto
