// third_party/blink/public/mojom/feature_observer/feature_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/feature_observer/feature_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/feature_observer/feature_observer.mojom-params-data.h"
#include "third_party/blink/public/mojom/feature_observer/feature_observer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/feature_observer/feature_observer.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_OBSERVER_FEATURE_OBSERVER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_OBSERVER_FEATURE_OBSERVER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char ObservedFeature::Name_[] = "blink.mojom.ObservedFeature";

ObservedFeatureProxy::ObservedFeatureProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool ObservedFeatureStubDispatch::Accept(
    ObservedFeature* impl,
    mojo::Message* message) {
  return false;
}

// static
bool ObservedFeatureStubDispatch::AcceptWithResponder(
    ObservedFeature* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool ObservedFeatureRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ObservedFeature::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char FeatureObserver::Name_[] = "blink.mojom.FeatureObserver";

FeatureObserverProxy::FeatureObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FeatureObserverProxy::Register(
    ::mojo::PendingReceiver<ObservedFeature> in_feature, ObservedFeatureType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FeatureObserver::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature, 
                        "<value of type ::mojo::PendingReceiver<ObservedFeature>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ObservedFeatureType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFeatureObserver_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FeatureObserver_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ObservedFeatureInterfaceBase>>(
      in_feature, &params->feature, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->feature),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid feature in FeatureObserver.Register request");
  mojo::internal::Serialize<::blink::mojom::ObservedFeatureType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FeatureObserver::Name_);
  message.set_method_name("Register");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FeatureObserverStubDispatch::Accept(
    FeatureObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFeatureObserver_Register_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FeatureObserver::Register",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FeatureObserver::Register");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FeatureObserver_Register_Params_Data* params =
          reinterpret_cast<internal::FeatureObserver_Register_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ObservedFeature> p_feature{};
      ObservedFeatureType p_type{};
      FeatureObserver_Register_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_feature =
            input_data_view.TakeFeature<decltype(p_feature)>();
      }
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FeatureObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(
std::move(p_feature), 
std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool FeatureObserverStubDispatch::AcceptWithResponder(
    FeatureObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFeatureObserver_Register_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFeatureObserverValidationInfo[] = {
    {&internal::FeatureObserver_Register_Params_Data::Validate,
     nullptr /* no response */},
};

bool FeatureObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FeatureObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFeatureObserverValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif