// third_party/blink/public/mojom/feature_policy/policy_value.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string PolicyValueTypeToString(PolicyValueType value) {
  switch(value) {
    case PolicyValueType::kNull:
      return "PolicyValueType::kNull";
    case PolicyValueType::kBool:
      return "PolicyValueType::kBool";
    case PolicyValueType::kDecDouble:
      return "PolicyValueType::kDecDouble";
    case PolicyValueType::kEnum:
      return "PolicyValueType::kEnum";
    default:
      return base::StringPrintf("Unknown PolicyValueType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PolicyValueType value) {
  return os << PolicyValueTypeToString(value);
}

namespace internal {
// static
bool PolicyValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PolicyValue_Data* object = static_cast<const PolicyValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PolicyValue_Tag::NULL_VALUE: {

      return true;
    }
    case PolicyValue_Tag::BOOL_VALUE: {

      return true;
    }
    case PolicyValue_Tag::DEC_DOUBLE_VALUE: {

      return true;
    }
    case PolicyValue_Tag::ENUM_VALUE: {

      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PolicyValue");
      return false;
    }
  }
}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PolicyValueType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::PolicyValueType value) {
  return std::move(context).WriteString(::blink::mojom::PolicyValueTypeToString(value));
}

} // namespace perfetto
