// third_party/blink/public/mojom/federated_learning/floc.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/federated_learning/floc.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/federated_learning/floc.mojom-params-data.h"
#include "third_party/blink/public/mojom/federated_learning/floc.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/federated_learning/floc.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEDERATED_LEARNING_FLOC_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEDERATED_LEARNING_FLOC_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
InterestCohort::InterestCohort()
    : id(),
      version() {}

InterestCohort::InterestCohort(
    const std::string& id_in,
    const std::string& version_in)
    : id(std::move(id_in)),
      version(std::move(version_in)) {}

InterestCohort::~InterestCohort() = default;
size_t InterestCohort::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->version);
  return seed;
}

void InterestCohort::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version, 
      "<value of type const std::string&>");
}

bool InterestCohort::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char FlocService::Name_[] = "blink.mojom.FlocService";

class FlocService_GetInterestCohort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FlocService_GetInterestCohort_ForwardToCallback(
      FlocService::GetInterestCohortCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FlocService::GetInterestCohortCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FlocService_GetInterestCohort_ForwardToCallback);
};

FlocServiceProxy::FlocServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FlocServiceProxy::GetInterestCohort(
    GetInterestCohortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FlocService::GetInterestCohort");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFlocService_GetInterestCohort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FlocService_GetInterestCohort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FlocService::Name_);
  message.set_method_name("GetInterestCohort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FlocService_GetInterestCohort_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FlocService_GetInterestCohort_ProxyToResponder {
 public:
  static FlocService::GetInterestCohortCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FlocService_GetInterestCohort_ProxyToResponder> proxy(
        new FlocService_GetInterestCohort_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FlocService_GetInterestCohort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FlocService_GetInterestCohort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FlocService_GetInterestCohort_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FlocService::GetInterestCohortCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      InterestCohortPtr in_interest_cohort);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FlocService_GetInterestCohort_ProxyToResponder);
};

bool FlocService_GetInterestCohort_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FlocService::GetInterestCohortCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FlocService_GetInterestCohort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FlocService_GetInterestCohort_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  InterestCohortPtr p_interest_cohort{};
  FlocService_GetInterestCohort_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInterestCohort(&p_interest_cohort))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FlocService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_interest_cohort));
  return true;
}

void FlocService_GetInterestCohort_ProxyToResponder::Run(
    InterestCohortPtr in_interest_cohort) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FlocService::GetInterestCohortCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interest_cohort"), in_interest_cohort, 
                        "<value of type InterestCohortPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFlocService_GetInterestCohort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FlocService_GetInterestCohort_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->interest_cohort)::BaseType> interest_cohort_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::InterestCohortDataView>(
      in_interest_cohort, interest_cohort_fragment);
  params->interest_cohort.Set(
      interest_cohort_fragment.is_null() ? nullptr : interest_cohort_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->interest_cohort.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interest_cohort in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FlocService::GetInterestCohortCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FlocService::Name_);
  message.set_method_name("GetInterestCohort");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FlocServiceStubDispatch::Accept(
    FlocService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFlocService_GetInterestCohort_Name: {
      break;
    }
  }
  return false;
}

// static
bool FlocServiceStubDispatch::AcceptWithResponder(
    FlocService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFlocService_GetInterestCohort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FlocService::GetInterestCohort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FlocService::GetInterestCohort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FlocService_GetInterestCohort_Params_Data* params =
          reinterpret_cast<
              internal::FlocService_GetInterestCohort_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FlocService_GetInterestCohort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FlocService::Name_, 0, false);
        return false;
      }
      FlocService::GetInterestCohortCallback callback =
          FlocService_GetInterestCohort_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInterestCohort(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFlocServiceValidationInfo[] = {
    {&internal::FlocService_GetInterestCohort_Params_Data::Validate,
     &internal::FlocService_GetInterestCohort_ResponseParams_Data::Validate},
};

bool FlocServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FlocService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFlocServiceValidationInfo);
}

bool FlocServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FlocService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFlocServiceValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::InterestCohort::DataView, ::blink::mojom::InterestCohortPtr>::Read(
    ::blink::mojom::InterestCohort::DataView input,
    ::blink::mojom::InterestCohortPtr* output) {
  bool success = true;
  ::blink::mojom::InterestCohortPtr result(::blink::mojom::InterestCohort::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif