// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string RequestContextTypeToString(RequestContextType value) {
  switch(value) {
    case RequestContextType::UNSPECIFIED:
      return "RequestContextType::UNSPECIFIED";
    case RequestContextType::AUDIO:
      return "RequestContextType::AUDIO";
    case RequestContextType::BEACON:
      return "RequestContextType::BEACON";
    case RequestContextType::CSP_REPORT:
      return "RequestContextType::CSP_REPORT";
    case RequestContextType::DOWNLOAD:
      return "RequestContextType::DOWNLOAD";
    case RequestContextType::EMBED:
      return "RequestContextType::EMBED";
    case RequestContextType::EVENT_SOURCE:
      return "RequestContextType::EVENT_SOURCE";
    case RequestContextType::FAVICON:
      return "RequestContextType::FAVICON";
    case RequestContextType::FETCH:
      return "RequestContextType::FETCH";
    case RequestContextType::FONT:
      return "RequestContextType::FONT";
    case RequestContextType::FORM:
      return "RequestContextType::FORM";
    case RequestContextType::FRAME:
      return "RequestContextType::FRAME";
    case RequestContextType::HYPERLINK:
      return "RequestContextType::HYPERLINK";
    case RequestContextType::IFRAME:
      return "RequestContextType::IFRAME";
    case RequestContextType::IMAGE:
      return "RequestContextType::IMAGE";
    case RequestContextType::IMAGE_SET:
      return "RequestContextType::IMAGE_SET";
    case RequestContextType::IMPORT:
      return "RequestContextType::IMPORT";
    case RequestContextType::INTERNAL:
      return "RequestContextType::INTERNAL";
    case RequestContextType::LOCATION:
      return "RequestContextType::LOCATION";
    case RequestContextType::MANIFEST:
      return "RequestContextType::MANIFEST";
    case RequestContextType::OBJECT:
      return "RequestContextType::OBJECT";
    case RequestContextType::PING:
      return "RequestContextType::PING";
    case RequestContextType::PLUGIN:
      return "RequestContextType::PLUGIN";
    case RequestContextType::PREFETCH:
      return "RequestContextType::PREFETCH";
    case RequestContextType::SCRIPT:
      return "RequestContextType::SCRIPT";
    case RequestContextType::SERVICE_WORKER:
      return "RequestContextType::SERVICE_WORKER";
    case RequestContextType::SHARED_WORKER:
      return "RequestContextType::SHARED_WORKER";
    case RequestContextType::SUBRESOURCE:
      return "RequestContextType::SUBRESOURCE";
    case RequestContextType::SUBRESOURCE_WEBBUNDLE:
      return "RequestContextType::SUBRESOURCE_WEBBUNDLE";
    case RequestContextType::STYLE:
      return "RequestContextType::STYLE";
    case RequestContextType::TRACK:
      return "RequestContextType::TRACK";
    case RequestContextType::VIDEO:
      return "RequestContextType::VIDEO";
    case RequestContextType::WORKER:
      return "RequestContextType::WORKER";
    case RequestContextType::XML_HTTP_REQUEST:
      return "RequestContextType::XML_HTTP_REQUEST";
    case RequestContextType::XSLT:
      return "RequestContextType::XSLT";
    default:
      return base::StringPrintf("Unknown RequestContextType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RequestContextType value) {
  return os << RequestContextTypeToString(value);
}

std::string FetchCacheModeToString(FetchCacheMode value) {
  switch(value) {
    case FetchCacheMode::kDefault:
      return "FetchCacheMode::kDefault";
    case FetchCacheMode::kNoStore:
      return "FetchCacheMode::kNoStore";
    case FetchCacheMode::kBypassCache:
      return "FetchCacheMode::kBypassCache";
    case FetchCacheMode::kValidateCache:
      return "FetchCacheMode::kValidateCache";
    case FetchCacheMode::kForceCache:
      return "FetchCacheMode::kForceCache";
    case FetchCacheMode::kOnlyIfCached:
      return "FetchCacheMode::kOnlyIfCached";
    case FetchCacheMode::kUnspecifiedOnlyIfCachedStrict:
      return "FetchCacheMode::kUnspecifiedOnlyIfCachedStrict";
    case FetchCacheMode::kUnspecifiedForceCacheMiss:
      return "FetchCacheMode::kUnspecifiedForceCacheMiss";
    default:
      return base::StringPrintf("Unknown FetchCacheMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FetchCacheMode value) {
  return os << FetchCacheModeToString(value);
}

std::string FetchImportanceModeToString(FetchImportanceMode value) {
  switch(value) {
    case FetchImportanceMode::kImportanceLow:
      return "FetchImportanceMode::kImportanceLow";
    case FetchImportanceMode::kImportanceAuto:
      return "FetchImportanceMode::kImportanceAuto";
    case FetchImportanceMode::kImportanceHigh:
      return "FetchImportanceMode::kImportanceHigh";
    default:
      return base::StringPrintf("Unknown FetchImportanceMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FetchImportanceMode value) {
  return os << FetchImportanceModeToString(value);
}

namespace internal {


// static
bool FetchAPIRequestHeaders_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FetchAPIRequestHeaders_Data* object = static_cast<const FetchAPIRequestHeaders_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  return true;
}

FetchAPIRequestHeaders_Data::FetchAPIRequestHeaders_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FetchAPIRequestBody_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FetchAPIRequestBody_Data* object = static_cast<const FetchAPIRequestBody_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elements, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams elements_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->elements, validation_context,
                                         &elements_validate_params)) {
    return false;
  }

  return true;
}

FetchAPIRequestBody_Data::FetchAPIRequestBody_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FetchAPIRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 128, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FetchAPIRequest_Data* object = static_cast<const FetchAPIRequest_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::RequestMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->destination, validation_context))
    return false;


  if (!::blink::mojom::internal::RequestContextFrameType_Data
        ::Validate(object->frame_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blob, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->body, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request_initiator, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_redirect_chain, 11, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams navigation_redirect_chain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->navigation_redirect_chain, validation_context,
                                         &navigation_redirect_chain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::network::mojom::internal::CredentialsMode_Data
        ::Validate(object->credentials_mode, validation_context))
    return false;


  if (!::blink::mojom::internal::FetchCacheMode_Data
        ::Validate(object->cache_mode, validation_context))
    return false;


  if (!::network::mojom::internal::RedirectMode_Data
        ::Validate(object->redirect_mode, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams integrity_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->integrity, validation_context,
                                         &integrity_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->fetch_window_id, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams devtools_stack_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtools_stack_id, validation_context,
                                         &devtools_stack_id_validate_params)) {
    return false;
  }

  return true;
}

FetchAPIRequest_Data::FetchAPIRequest_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestContextType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::RequestContextType value) {
  return std::move(context).WriteString(::blink::mojom::RequestContextTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FetchCacheMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::FetchCacheMode value) {
  return std::move(context).WriteString(::blink::mojom::FetchCacheModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FetchImportanceMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::FetchImportanceMode value) {
  return std::move(context).WriteString(::blink::mojom::FetchImportanceModeToString(value));
}

} // namespace perfetto
