// third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool FetchAPIResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 152, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FetchAPIResponse_Data* object = static_cast<const FetchAPIResponse_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_list, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams url_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url_list, validation_context,
                                         &url_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status_text, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams status_text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->status_text, validation_context,
                                         &status_text_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::FetchResponseType_Data
        ::Validate(object->response_type, validation_context))
    return false;


  if (!::network::mojom::internal::FetchResponseSource_Data
        ::Validate(object->response_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams request_method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->request_method, validation_context,
                                         &request_method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->blob, validation_context))
    return false;


  if (!::blink::mojom::internal::ServiceWorkerResponseError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_time, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_time, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams cache_storage_cache_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cache_storage_cache_name, validation_context,
                                         &cache_storage_cache_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cors_exposed_header_names, 14, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cors_exposed_header_names_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->cors_exposed_header_names, validation_context,
                                         &cors_exposed_header_names_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->side_data_blob, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->side_data_blob_for_cache_put, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parsed_headers, validation_context))
    return false;


  if (!::network::mojom::internal::ConnectionInfo_Data
        ::Validate(object->connection_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpn_negotiated_protocol, 19, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams alpn_negotiated_protocol_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->alpn_negotiated_protocol, validation_context,
                                         &alpn_negotiated_protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->auth_challenge_info, validation_context))
    return false;

  return true;
}

FetchAPIResponse_Data::FetchAPIResponse_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
