// third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DATA_TRANSFER_TOKEN_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DATA_TRANSFER_TOKEN_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char FileSystemAccessDataTransferToken::Name_[] = "blink.mojom.FileSystemAccessDataTransferToken";

class FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback(
      FileSystemAccessDataTransferToken::GetInternalIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDataTransferToken::GetInternalIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback);
};

FileSystemAccessDataTransferTokenProxy::FileSystemAccessDataTransferTokenProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessDataTransferTokenProxy::GetInternalId(
    GetInternalIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FileSystemAccessDataTransferToken::GetInternalId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessDataTransferToken_GetInternalId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDataTransferToken::Name_);
  message.set_method_name("GetInternalId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessDataTransferTokenProxy::Clone(
    ::mojo::PendingReceiver<FileSystemAccessDataTransferToken> in_token_clone) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessDataTransferToken::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token_clone"), in_token_clone, 
                        "<value of type ::mojo::PendingReceiver<FileSystemAccessDataTransferToken>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessDataTransferToken_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDataTransferToken_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessDataTransferTokenInterfaceBase>>(
      in_token_clone, &params->token_clone, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token_clone),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token_clone in FileSystemAccessDataTransferToken.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDataTransferToken::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder {
 public:
  static FileSystemAccessDataTransferToken::GetInternalIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder> proxy(
        new FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessDataTransferToken::GetInternalIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder);
};

bool FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessDataTransferToken::GetInternalIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::UnguessableToken p_id{};
  FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDataTransferToken::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_id));
  return true;
}

void FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessDataTransferToken::GetInternalIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessDataTransferToken_GetInternalId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessDataTransferToken::GetInternalIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDataTransferToken::Name_);
  message.set_method_name("GetInternalId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessDataTransferTokenStubDispatch::Accept(
    FileSystemAccessDataTransferToken* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessDataTransferToken_GetInternalId_Name: {
      break;
    }
    case internal::kFileSystemAccessDataTransferToken_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDataTransferToken::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDataTransferToken::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessDataTransferToken_Clone_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDataTransferToken_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<FileSystemAccessDataTransferToken> p_token_clone{};
      FileSystemAccessDataTransferToken_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token_clone =
            input_data_view.TakeTokenClone<decltype(p_token_clone)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDataTransferToken::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_token_clone));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessDataTransferTokenStubDispatch::AcceptWithResponder(
    FileSystemAccessDataTransferToken* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessDataTransferToken_GetInternalId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessDataTransferToken::GetInternalId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessDataTransferToken::GetInternalId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FileSystemAccessDataTransferToken_GetInternalId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDataTransferToken::Name_, 0, false);
        return false;
      }
      FileSystemAccessDataTransferToken::GetInternalIdCallback callback =
          FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInternalId(std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessDataTransferToken_Clone_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFileSystemAccessDataTransferTokenValidationInfo[] = {
    {&internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data::Validate,
     &internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessDataTransferToken_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessDataTransferTokenRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessDataTransferToken::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFileSystemAccessDataTransferTokenValidationInfo);
}

bool FileSystemAccessDataTransferTokenResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessDataTransferToken::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFileSystemAccessDataTransferTokenValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif