// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool FileSystemAccessHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FileSystemAccessHandle_Data* object = static_cast<const FileSystemAccessHandle_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FileSystemAccessHandle_Tag::FILE: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_file, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_file,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    case FileSystemAccessHandle_Tag::DIRECTORY: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_directory, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_directory,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FileSystemAccessHandle");
      return false;
    }
  }
}


// static
bool FileSystemAccessEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessEntry_Data* object = static_cast<const FileSystemAccessEntry_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->entry_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->entry_handle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessEntry_Data::FileSystemAccessEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data* object = static_cast<const FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data::FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data::FileSystemAccessDirectoryHandle_GetPermissionStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data* object = static_cast<const FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data::FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_RequestPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_RequestPermission_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_RequestPermission_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FileSystemAccessDirectoryHandle_RequestPermission_Params_Data::FileSystemAccessDirectoryHandle_RequestPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data* object = static_cast<const FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;


  if (!::blink::mojom::internal::PermissionStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data::FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_GetFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_GetFile_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_GetFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->basename, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams basename_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->basename, validation_context,
                                         &basename_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_GetFile_Params_Data::FileSystemAccessDirectoryHandle_GetFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data* object = static_cast<const FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->file,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data::FileSystemAccessDirectoryHandle_GetFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_GetDirectory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_GetDirectory_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_GetDirectory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->basename, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams basename_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->basename, validation_context,
                                         &basename_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_GetDirectory_Params_Data::FileSystemAccessDirectoryHandle_GetDirectory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data* object = static_cast<const FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->directory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data::FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_GetEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_GetEntries_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_GetEntries_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_GetEntries_Params_Data::FileSystemAccessDirectoryHandle_GetEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->basename, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams basename_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->basename, validation_context,
                                         &basename_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data::FileSystemAccessDirectoryHandle_RemoveEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data* object = static_cast<const FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data::FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_Resolve_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_Resolve_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_Resolve_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->possible_child, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->possible_child,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_Resolve_Params_Data::FileSystemAccessDirectoryHandle_Resolve_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data* object = static_cast<const FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data::FileSystemAccessDirectoryHandle_Resolve_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessDirectoryHandle_Transfer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessDirectoryHandle_Transfer_Params_Data* object = static_cast<const FileSystemAccessDirectoryHandle_Transfer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->token,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemAccessDirectoryHandle_Transfer_Params_Data::FileSystemAccessDirectoryHandle_Transfer_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
