// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_JUMBO_H_
#endif


namespace blink {
namespace mojom {


void FileSystemAccessDirectoryEntriesListenerInterceptorForTesting::DidReadDirectory(::blink::mojom::FileSystemAccessErrorPtr result, std::vector<FileSystemAccessEntryPtr> entries, bool has_more_entries) {
  GetForwardingInterface()->DidReadDirectory(std::move(result), std::move(entries), std::move(has_more_entries));
}
FileSystemAccessDirectoryEntriesListenerAsyncWaiter::FileSystemAccessDirectoryEntriesListenerAsyncWaiter(
    FileSystemAccessDirectoryEntriesListener* proxy) : proxy_(proxy) {}

FileSystemAccessDirectoryEntriesListenerAsyncWaiter::~FileSystemAccessDirectoryEntriesListenerAsyncWaiter() = default;




void FileSystemAccessDirectoryHandleInterceptorForTesting::GetPermissionStatus(bool writable, GetPermissionStatusCallback callback) {
  GetForwardingInterface()->GetPermissionStatus(std::move(writable), std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::RequestPermission(bool writable, RequestPermissionCallback callback) {
  GetForwardingInterface()->RequestPermission(std::move(writable), std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetFile(const std::string& basename, bool create, GetFileCallback callback) {
  GetForwardingInterface()->GetFile(std::move(basename), std::move(create), std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetDirectory(const std::string& basename, bool create, GetDirectoryCallback callback) {
  GetForwardingInterface()->GetDirectory(std::move(basename), std::move(create), std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::GetEntries(::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> listener) {
  GetForwardingInterface()->GetEntries(std::move(listener));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::RemoveEntry(const std::string& basename, bool recurse, RemoveEntryCallback callback) {
  GetForwardingInterface()->RemoveEntry(std::move(basename), std::move(recurse), std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::Resolve(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ResolveCallback callback) {
  GetForwardingInterface()->Resolve(std::move(possible_child), std::move(callback));
}
void FileSystemAccessDirectoryHandleInterceptorForTesting::Transfer(::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) {
  GetForwardingInterface()->Transfer(std::move(token));
}
FileSystemAccessDirectoryHandleAsyncWaiter::FileSystemAccessDirectoryHandleAsyncWaiter(
    FileSystemAccessDirectoryHandle* proxy) : proxy_(proxy) {}

FileSystemAccessDirectoryHandleAsyncWaiter::~FileSystemAccessDirectoryHandleAsyncWaiter() = default;

void FileSystemAccessDirectoryHandleAsyncWaiter::GetPermissionStatus(
    bool writable, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->GetPermissionStatus(std::move(writable),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::PermissionStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void FileSystemAccessDirectoryHandleAsyncWaiter::RequestPermission(
    bool writable, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::blink::mojom::PermissionStatus* out_status) {
  base::RunLoop loop;
  proxy_->RequestPermission(std::move(writable),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::PermissionStatus* out_status
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::blink::mojom::PermissionStatus status) {*out_result = std::move(result);*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_result,
          out_status));
  loop.Run();
}
void FileSystemAccessDirectoryHandleAsyncWaiter::GetFile(
    const std::string& basename, bool create, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>* out_file) {
  base::RunLoop loop;
  proxy_->GetFile(std::move(basename),std::move(create),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>* out_file
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> file) {*out_result = std::move(result);*out_file = std::move(file);
            loop->Quit();
          },
          &loop,
          out_result,
          out_file));
  loop.Run();
}
void FileSystemAccessDirectoryHandleAsyncWaiter::GetDirectory(
    const std::string& basename, bool create, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>* out_directory) {
  base::RunLoop loop;
  proxy_->GetDirectory(std::move(basename),std::move(create),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>* out_directory
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> directory) {*out_result = std::move(result);*out_directory = std::move(directory);
            loop->Quit();
          },
          &loop,
          out_result,
          out_directory));
  loop.Run();
}
void FileSystemAccessDirectoryHandleAsyncWaiter::RemoveEntry(
    const std::string& basename, bool recurse, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->RemoveEntry(std::move(basename),std::move(recurse),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void FileSystemAccessDirectoryHandleAsyncWaiter::Resolve(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ::blink::mojom::FileSystemAccessErrorPtr* out_result, base::Optional<std::vector<std::string>>* out_path) {
  base::RunLoop loop;
  proxy_->Resolve(std::move(possible_child),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             base::Optional<std::vector<std::string>>* out_path
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             const base::Optional<std::vector<std::string>>& path) {*out_result = std::move(result);*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_result,
          out_path));
  loop.Run();
}





}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif