// third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string FileSystemAccessStatusToString(FileSystemAccessStatus value) {
  switch(value) {
    case FileSystemAccessStatus::kOk:
      return "FileSystemAccessStatus::kOk";
    case FileSystemAccessStatus::kPermissionDenied:
      return "FileSystemAccessStatus::kPermissionDenied";
    case FileSystemAccessStatus::kSecurityError:
      return "FileSystemAccessStatus::kSecurityError";
    case FileSystemAccessStatus::kInvalidState:
      return "FileSystemAccessStatus::kInvalidState";
    case FileSystemAccessStatus::kInvalidArgument:
      return "FileSystemAccessStatus::kInvalidArgument";
    case FileSystemAccessStatus::kOperationFailed:
      return "FileSystemAccessStatus::kOperationFailed";
    case FileSystemAccessStatus::kOperationAborted:
      return "FileSystemAccessStatus::kOperationAborted";
    case FileSystemAccessStatus::kFileError:
      return "FileSystemAccessStatus::kFileError";
    default:
      return base::StringPrintf("Unknown FileSystemAccessStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FileSystemAccessStatus value) {
  return os << FileSystemAccessStatusToString(value);
}

namespace internal {


// static
bool FileSystemAccessError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemAccessError_Data* object = static_cast<const FileSystemAccessError_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FileSystemAccessStatus_Data
        ::Validate(object->status, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->file_error, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessError_Data::FileSystemAccessError_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FileSystemAccessStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::FileSystemAccessStatus value) {
  return std::move(context).WriteString(::blink::mojom::FileSystemAccessStatusToString(value));
}

} // namespace perfetto
