// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char FileSystemAccessFileHandle::Name_[] = "blink.mojom.FileSystemAccessFileHandle";

class FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback(
      FileSystemAccessFileHandle::GetPermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::GetPermissionStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback);
};

class FileSystemAccessFileHandle_RequestPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_RequestPermission_ForwardToCallback(
      FileSystemAccessFileHandle::RequestPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::RequestPermissionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_RequestPermission_ForwardToCallback);
};

class FileSystemAccessFileHandle_AsBlob_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_AsBlob_ForwardToCallback(
      FileSystemAccessFileHandle::AsBlobCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::AsBlobCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_AsBlob_ForwardToCallback);
};

class FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback(
      FileSystemAccessFileHandle::CreateFileWriterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::CreateFileWriterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback);
};

class FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback(
      FileSystemAccessFileHandle::IsSameEntryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileHandle::IsSameEntryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback);
};

FileSystemAccessFileHandleProxy::FileSystemAccessFileHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessFileHandleProxy::GetPermissionStatus(
    bool in_writable, GetPermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data> params(
          message);
  params.Allocate();
  params->writable = in_writable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessFileHandleProxy::RequestPermission(
    bool in_writable, RequestPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileHandle::RequestPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_RequestPermission_Params_Data> params(
          message);
  params.Allocate();
  params->writable = in_writable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("RequestPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_RequestPermission_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessFileHandleProxy::AsBlob(
    AsBlobCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FileSystemAccessFileHandle::AsBlob");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_AsBlob_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_AsBlob_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("AsBlob");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_AsBlob_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessFileHandleProxy::CreateFileWriter(
    bool in_keep_existing_data, bool in_auto_close, CreateFileWriterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileHandle::CreateFileWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_existing_data"), in_keep_existing_data, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auto_close"), in_auto_close, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_CreateFileWriter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data> params(
          message);
  params.Allocate();
  params->keep_existing_data = in_keep_existing_data;
  params->auto_close = in_auto_close;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("CreateFileWriter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessFileHandleProxy::IsSameEntry(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_other, IsSameEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileHandle::IsSameEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("other"), in_other, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_IsSameEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_other, &params->other, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->other),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid other in FileSystemAccessFileHandle.IsSameEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("IsSameEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessFileHandleProxy::Transfer(
    ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileHandle::Transfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_Transfer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_Transfer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in FileSystemAccessFileHandle.Transfer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("Transfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::GetPermissionStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileHandle::GetPermissionStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder);
};

bool FileSystemAccessFileHandle_GetPermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileHandle::GetPermissionStatusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::GetPermissionStatusCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::GetPermissionStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_RequestPermission_ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::RequestPermissionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileHandle_RequestPermission_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_RequestPermission_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileHandle_RequestPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_RequestPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileHandle_RequestPermission_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileHandle::RequestPermissionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_RequestPermission_ProxyToResponder);
};

bool FileSystemAccessFileHandle_RequestPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileHandle::RequestPermissionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::blink::mojom::PermissionStatus p_status{};
  FileSystemAccessFileHandle_RequestPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_status));
  return true;
}

void FileSystemAccessFileHandle_RequestPermission_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::RequestPermissionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::blink::mojom::PermissionStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::RequestPermissionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("RequestPermission");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_AsBlob_ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::AsBlobCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileHandle_AsBlob_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_AsBlob_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileHandle_AsBlob_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_AsBlob_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileHandle_AsBlob_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileHandle::AsBlobCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, const ::base::File::Info& in_info, ::blink::mojom::SerializedBlobPtr in_blob);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_AsBlob_ProxyToResponder);
};

bool FileSystemAccessFileHandle_AsBlob_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileHandle::AsBlobCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::base::File::Info p_info{};
  ::blink::mojom::SerializedBlobPtr p_blob{};
  FileSystemAccessFileHandle_AsBlob_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_info), 
std::move(p_blob));
  return true;
}

void FileSystemAccessFileHandle_AsBlob_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, const ::base::File::Info& in_info, ::blink::mojom::SerializedBlobPtr in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::AsBlobCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type const ::base::File::Info&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob, 
                        "<value of type ::blink::mojom::SerializedBlobPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_AsBlob_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_blob, blob_fragment);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::AsBlobCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("AsBlob");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::CreateFileWriterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileHandle::CreateFileWriterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter> in_writer);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder);
};

bool FileSystemAccessFileHandle_CreateFileWriter_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileHandle::CreateFileWriterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter> p_writer{};
  FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_writer =
        input_data_view.TakeWriter<decltype(p_writer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_writer));
  return true;
}

void FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::CreateFileWriterCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer"), in_writer, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileWriter>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_CreateFileWriter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileWriterInterfaceBase>>(
      in_writer, &params->writer, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::CreateFileWriterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("CreateFileWriter");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder {
 public:
  static FileSystemAccessFileHandle::IsSameEntryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder> proxy(
        new FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileHandle::IsSameEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, bool in_is_same);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder);
};

bool FileSystemAccessFileHandle_IsSameEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileHandle::IsSameEntryCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  bool p_is_same{};
  FileSystemAccessFileHandle_IsSameEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_is_same = input_data_view.is_same();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileHandle::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_is_same));
  return true;
}

void FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, bool in_is_same) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::IsSameEntryCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_same"), in_is_same, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessFileHandle_IsSameEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  params->is_same = in_is_same;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileHandle::IsSameEntryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileHandle::Name_);
  message.set_method_name("IsSameEntry");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessFileHandleStubDispatch::Accept(
    FileSystemAccessFileHandle* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessFileHandle_GetPermissionStatus_Name: {
      break;
    }
    case internal::kFileSystemAccessFileHandle_RequestPermission_Name: {
      break;
    }
    case internal::kFileSystemAccessFileHandle_AsBlob_Name: {
      break;
    }
    case internal::kFileSystemAccessFileHandle_CreateFileWriter_Name: {
      break;
    }
    case internal::kFileSystemAccessFileHandle_IsSameEntry_Name: {
      break;
    }
    case internal::kFileSystemAccessFileHandle_Transfer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileHandle::Transfer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileHandle::Transfer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessFileHandle_Transfer_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessFileHandle_Transfer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessFileHandle_Transfer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Transfer(
std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessFileHandleStubDispatch::AcceptWithResponder(
    FileSystemAccessFileHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessFileHandle_GetPermissionStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileHandle::GetPermissionStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      FileSystemAccessFileHandle_GetPermissionStatus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 0, false);
        return false;
      }
      FileSystemAccessFileHandle::GetPermissionStatusCallback callback =
          FileSystemAccessFileHandle_GetPermissionStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermissionStatus(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileHandle_RequestPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileHandle::RequestPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileHandle::RequestPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileHandle_RequestPermission_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_RequestPermission_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      FileSystemAccessFileHandle_RequestPermission_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 1, false);
        return false;
      }
      FileSystemAccessFileHandle::RequestPermissionCallback callback =
          FileSystemAccessFileHandle_RequestPermission_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermission(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileHandle_AsBlob_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileHandle::AsBlob",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileHandle::AsBlob");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileHandle_AsBlob_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_AsBlob_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FileSystemAccessFileHandle_AsBlob_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 2, false);
        return false;
      }
      FileSystemAccessFileHandle::AsBlobCallback callback =
          FileSystemAccessFileHandle_AsBlob_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AsBlob(std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileHandle_CreateFileWriter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileHandle::CreateFileWriter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileHandle::CreateFileWriter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_keep_existing_data{};
      bool p_auto_close{};
      FileSystemAccessFileHandle_CreateFileWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_keep_existing_data = input_data_view.keep_existing_data();
      if (success)
        p_auto_close = input_data_view.auto_close();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 3, false);
        return false;
      }
      FileSystemAccessFileHandle::CreateFileWriterCallback callback =
          FileSystemAccessFileHandle_CreateFileWriter_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFileWriter(
std::move(p_keep_existing_data), 
std::move(p_auto_close), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileHandle_IsSameEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileHandle::IsSameEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileHandle::IsSameEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_other{};
      FileSystemAccessFileHandle_IsSameEntry_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_other =
            input_data_view.TakeOther<decltype(p_other)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileHandle::Name_, 4, false);
        return false;
      }
      FileSystemAccessFileHandle::IsSameEntryCallback callback =
          FileSystemAccessFileHandle_IsSameEntry_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsSameEntry(
std::move(p_other), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileHandle_Transfer_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFileSystemAccessFileHandleValidationInfo[] = {
    {&internal::FileSystemAccessFileHandle_GetPermissionStatus_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileHandle_RequestPermission_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_RequestPermission_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileHandle_AsBlob_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_AsBlob_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileHandle_CreateFileWriter_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_CreateFileWriter_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileHandle_IsSameEntry_Params_Data::Validate,
     &internal::FileSystemAccessFileHandle_IsSameEntry_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileHandle_Transfer_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessFileHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessFileHandle::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFileSystemAccessFileHandleValidationInfo);
}

bool FileSystemAccessFileHandleResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessFileHandle::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFileSystemAccessFileHandleValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif