// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_MANAGER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ChooseFileSystemEntryAcceptsOption::ChooseFileSystemEntryAcceptsOption()
    : description(),
      mime_types(),
      extensions() {}

ChooseFileSystemEntryAcceptsOption::ChooseFileSystemEntryAcceptsOption(
    const ::base::string16& description_in,
    std::vector<std::string> mime_types_in,
    std::vector<std::string> extensions_in)
    : description(std::move(description_in)),
      mime_types(std::move(mime_types_in)),
      extensions(std::move(extensions_in)) {}

ChooseFileSystemEntryAcceptsOption::~ChooseFileSystemEntryAcceptsOption() = default;

void ChooseFileSystemEntryAcceptsOption::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description, 
      "<value of type const ::base::string16&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_types"), this->mime_types, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions, 
      "<value of type const std::vector<std::string>&>");
}

bool ChooseFileSystemEntryAcceptsOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AcceptsTypesInfo::AcceptsTypesInfo()
    : accepts(),
      include_accepts_all() {}

AcceptsTypesInfo::AcceptsTypesInfo(
    std::vector<ChooseFileSystemEntryAcceptsOptionPtr> accepts_in,
    bool include_accepts_all_in)
    : accepts(std::move(accepts_in)),
      include_accepts_all(std::move(include_accepts_all_in)) {}

AcceptsTypesInfo::~AcceptsTypesInfo() = default;

void AcceptsTypesInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accepts"), this->accepts, 
      "<value of type std::vector<ChooseFileSystemEntryAcceptsOptionPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_accepts_all"), this->include_accepts_all, 
      "<value of type bool>");
}

bool AcceptsTypesInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenFilePickerOptions::OpenFilePickerOptions()
    : accepts_types_info(),
      can_select_multiple_files() {}

OpenFilePickerOptions::OpenFilePickerOptions(
    AcceptsTypesInfoPtr accepts_types_info_in,
    bool can_select_multiple_files_in)
    : accepts_types_info(std::move(accepts_types_info_in)),
      can_select_multiple_files(std::move(can_select_multiple_files_in)) {}

OpenFilePickerOptions::~OpenFilePickerOptions() = default;

void OpenFilePickerOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accepts_types_info"), this->accepts_types_info, 
      "<value of type AcceptsTypesInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_select_multiple_files"), this->can_select_multiple_files, 
      "<value of type bool>");
}

bool OpenFilePickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SaveFilePickerOptions::SaveFilePickerOptions()
    : accepts_types_info(),
      suggested_name() {}

SaveFilePickerOptions::SaveFilePickerOptions(
    AcceptsTypesInfoPtr accepts_types_info_in,
    const std::string& suggested_name_in)
    : accepts_types_info(std::move(accepts_types_info_in)),
      suggested_name(std::move(suggested_name_in)) {}

SaveFilePickerOptions::~SaveFilePickerOptions() = default;

void SaveFilePickerOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accepts_types_info"), this->accepts_types_info, 
      "<value of type AcceptsTypesInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggested_name"), this->suggested_name, 
      "<value of type const std::string&>");
}

bool SaveFilePickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectoryPickerOptions::DirectoryPickerOptions() {}

DirectoryPickerOptions::~DirectoryPickerOptions() = default;
size_t DirectoryPickerOptions::Hash(size_t seed) const {
  return seed;
}

void DirectoryPickerOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
}

bool DirectoryPickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommonFilePickerOptions::CommonFilePickerOptions()
    : starting_directory_id(),
      well_known_starting_directory(),
      starting_directory_token() {}

CommonFilePickerOptions::CommonFilePickerOptions(
    const std::string& starting_directory_id_in,
    WellKnownDirectory well_known_starting_directory_in,
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> starting_directory_token_in)
    : starting_directory_id(std::move(starting_directory_id_in)),
      well_known_starting_directory(std::move(well_known_starting_directory_in)),
      starting_directory_token(std::move(starting_directory_token_in)) {}

CommonFilePickerOptions::~CommonFilePickerOptions() = default;

void CommonFilePickerOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "starting_directory_id"), this->starting_directory_id, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "well_known_starting_directory"), this->well_known_starting_directory, 
      "<value of type WellKnownDirectory>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "starting_directory_token"), this->starting_directory_token, 
      "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
}

bool CommonFilePickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FilePickerOptions::FilePickerOptions() : tag_(Tag::OPEN_FILE_PICKER_OPTIONS) {
  data_.open_file_picker_options = new OpenFilePickerOptionsPtr;
}

FilePickerOptions::~FilePickerOptions() {
  DestroyActive();
}


void FilePickerOptions::set_open_file_picker_options(
    OpenFilePickerOptionsPtr open_file_picker_options) {
  if (tag_ == Tag::OPEN_FILE_PICKER_OPTIONS) {
    *(data_.open_file_picker_options) = std::move(open_file_picker_options);
  } else {
    DestroyActive();
    tag_ = Tag::OPEN_FILE_PICKER_OPTIONS;
    data_.open_file_picker_options = new OpenFilePickerOptionsPtr(
        std::move(open_file_picker_options));
  }
}
void FilePickerOptions::set_save_file_picker_options(
    SaveFilePickerOptionsPtr save_file_picker_options) {
  if (tag_ == Tag::SAVE_FILE_PICKER_OPTIONS) {
    *(data_.save_file_picker_options) = std::move(save_file_picker_options);
  } else {
    DestroyActive();
    tag_ = Tag::SAVE_FILE_PICKER_OPTIONS;
    data_.save_file_picker_options = new SaveFilePickerOptionsPtr(
        std::move(save_file_picker_options));
  }
}
void FilePickerOptions::set_directory_picker_options(
    DirectoryPickerOptionsPtr directory_picker_options) {
  if (tag_ == Tag::DIRECTORY_PICKER_OPTIONS) {
    *(data_.directory_picker_options) = std::move(directory_picker_options);
  } else {
    DestroyActive();
    tag_ = Tag::DIRECTORY_PICKER_OPTIONS;
    data_.directory_picker_options = new DirectoryPickerOptionsPtr(
        std::move(directory_picker_options));
  }
}

void FilePickerOptions::DestroyActive() {
  switch (tag_) {

    case Tag::OPEN_FILE_PICKER_OPTIONS:

      delete data_.open_file_picker_options;
      break;
    case Tag::SAVE_FILE_PICKER_OPTIONS:

      delete data_.save_file_picker_options;
      break;
    case Tag::DIRECTORY_PICKER_OPTIONS:

      delete data_.directory_picker_options;
      break;
  }
}

bool FilePickerOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char FileSystemAccessManager::Name_[] = "blink.mojom.FileSystemAccessManager";

class FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback(
      FileSystemAccessManager::GetSandboxedFileSystemCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessManager::GetSandboxedFileSystemCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback);
};

class FileSystemAccessManager_ChooseEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessManager_ChooseEntries_ForwardToCallback(
      FileSystemAccessManager::ChooseEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessManager::ChooseEntriesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessManager_ChooseEntries_ForwardToCallback);
};

class FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback(
      FileSystemAccessManager::GetEntryFromDataTransferTokenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessManager::GetEntryFromDataTransferTokenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback);
};

FileSystemAccessManagerProxy::FileSystemAccessManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessManagerProxy::GetSandboxedFileSystem(
    GetSandboxedFileSystemCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_GetSandboxedFileSystem_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetSandboxedFileSystem");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessManagerProxy::ChooseEntries(
    FilePickerOptionsPtr in_options, CommonFilePickerOptionsPtr in_common_options, ChooseEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessManager::ChooseEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type FilePickerOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_options"), in_common_options, 
                        "<value of type CommonFilePickerOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_ChooseEntries_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_ChooseEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->options)>
      options_fragment(params.message());
  options_fragment.Claim(&params->options);
  mojo::internal::Serialize<::blink::mojom::FilePickerOptionsDataView>(
      in_options, options_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in FileSystemAccessManager.ChooseEntries request");
  mojo::internal::MessageFragment<
      typename decltype(params->common_options)::BaseType> common_options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CommonFilePickerOptionsDataView>(
      in_common_options, common_options_fragment);
  params->common_options.Set(
      common_options_fragment.is_null() ? nullptr : common_options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_options in FileSystemAccessManager.ChooseEntries request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("ChooseEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessManager_ChooseEntries_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessManagerProxy::GetFileHandleFromToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_token, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessFileHandle> in_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessManager::GetFileHandleFromToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_handle"), in_file_handle, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessFileHandle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_GetFileHandleFromToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in FileSystemAccessManager.GetFileHandleFromToken request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessFileHandleInterfaceBase>>(
      in_file_handle, &params->file_handle, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->file_handle),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_handle in FileSystemAccessManager.GetFileHandleFromToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetFileHandleFromToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FileSystemAccessManagerProxy::GetDirectoryHandleFromToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_token, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessManager::GetDirectoryHandleFromToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_handle"), in_directory_handle, 
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessDirectoryHandle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_GetDirectoryHandleFromToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in FileSystemAccessManager.GetDirectoryHandleFromToken request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
      in_directory_handle, &params->directory_handle, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->directory_handle),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid directory_handle in FileSystemAccessManager.GetDirectoryHandleFromToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetDirectoryHandleFromToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FileSystemAccessManagerProxy::GetEntryFromDataTransferToken(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> in_token, GetEntryFromDataTransferTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_GetEntryFromDataTransferToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDataTransferTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in FileSystemAccessManager.GetEntryFromDataTransferToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetEntryFromDataTransferToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder {
 public:
  static FileSystemAccessManager::GetSandboxedFileSystemCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder> proxy(
        new FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessManager::GetSandboxedFileSystemCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder);
};

bool FileSystemAccessManager_GetSandboxedFileSystem_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> p_directory{};
  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  return true;
}

void FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory, 
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_GetSandboxedFileSystem_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
      in_directory, &params->directory, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessManager::GetSandboxedFileSystemCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetSandboxedFileSystem");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessManager_ChooseEntries_ProxyToResponder {
 public:
  static FileSystemAccessManager::ChooseEntriesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessManager_ChooseEntries_ProxyToResponder> proxy(
        new FileSystemAccessManager_ChooseEntries_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessManager_ChooseEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessManager_ChooseEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessManager_ChooseEntries_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessManager::ChooseEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessEntryPtr> in_entries);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessManager_ChooseEntries_ProxyToResponder);
};

bool FileSystemAccessManager_ChooseEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessManager::ChooseEntriesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  std::vector<::blink::mojom::FileSystemAccessEntryPtr> p_entries{};
  FileSystemAccessManager_ChooseEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_entries));
  return true;
}

void FileSystemAccessManager_ChooseEntries_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, std::vector<::blink::mojom::FileSystemAccessEntryPtr> in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessManager::ChooseEntriesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries, 
                        "<value of type std::vector<::blink::mojom::FileSystemAccessEntryPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_ChooseEntries_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileSystemAccessEntryDataView>>(
      in_entries, entries_fragment, &entries_validate_params);
  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessManager::ChooseEntriesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("ChooseEntries");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder {
 public:
  static FileSystemAccessManager::GetEntryFromDataTransferTokenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder> proxy(
        new FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessManager::GetEntryFromDataTransferTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessEntryPtr in_entry);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder);
};

bool FileSystemAccessManager_GetEntryFromDataTransferToken_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferTokenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::FileSystemAccessEntryPtr p_entry{};
  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntry(&p_entry))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_entry));
  return true;
}

void FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessEntryPtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferTokenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry, 
                        "<value of type ::blink::mojom::FileSystemAccessEntryPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFileSystemAccessManager_GetEntryFromDataTransferToken_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entry)::BaseType> entry_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessEntryDataView>(
      in_entry, entry_fragment);
  params->entry.Set(
      entry_fragment.is_null() ? nullptr : entry_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entry in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferTokenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessManager::Name_);
  message.set_method_name("GetEntryFromDataTransferToken");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessManagerStubDispatch::Accept(
    FileSystemAccessManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessManager_GetSandboxedFileSystem_Name: {
      break;
    }
    case internal::kFileSystemAccessManager_ChooseEntries_Name: {
      break;
    }
    case internal::kFileSystemAccessManager_GetFileHandleFromToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessManager::GetFileHandleFromToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessManager::GetFileHandleFromToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessFileHandle> p_file_handle{};
      FileSystemAccessManager_GetFileHandleFromToken_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success) {
        p_file_handle =
            input_data_view.TakeFileHandle<decltype(p_file_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileHandleFromToken(
std::move(p_token), 
std::move(p_file_handle));
      return true;
    }
    case internal::kFileSystemAccessManager_GetDirectoryHandleFromToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessManager::GetDirectoryHandleFromToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessManager::GetDirectoryHandleFromToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessDirectoryHandle> p_directory_handle{};
      FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success) {
        p_directory_handle =
            input_data_view.TakeDirectoryHandle<decltype(p_directory_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectoryHandleFromToken(
std::move(p_token), 
std::move(p_directory_handle));
      return true;
    }
    case internal::kFileSystemAccessManager_GetEntryFromDataTransferToken_Name: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemAccessManagerStubDispatch::AcceptWithResponder(
    FileSystemAccessManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessManager_GetSandboxedFileSystem_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessManager::GetSandboxedFileSystem");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FileSystemAccessManager_GetSandboxedFileSystem_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 0, false);
        return false;
      }
      FileSystemAccessManager::GetSandboxedFileSystemCallback callback =
          FileSystemAccessManager_GetSandboxedFileSystem_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSandboxedFileSystem(std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessManager_ChooseEntries_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessManager::ChooseEntries",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessManager::ChooseEntries");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessManager_ChooseEntries_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessManager_ChooseEntries_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FilePickerOptionsPtr p_options{};
      CommonFilePickerOptionsPtr p_common_options{};
      FileSystemAccessManager_ChooseEntries_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadCommonOptions(&p_common_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 1, false);
        return false;
      }
      FileSystemAccessManager::ChooseEntriesCallback callback =
          FileSystemAccessManager_ChooseEntries_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChooseEntries(
std::move(p_options), 
std::move(p_common_options), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessManager_GetFileHandleFromToken_Name: {
      break;
    }
    case internal::kFileSystemAccessManager_GetDirectoryHandleFromToken_Name: {
      break;
    }
    case internal::kFileSystemAccessManager_GetEntryFromDataTransferToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessManager::GetEntryFromDataTransferToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDataTransferToken> p_token{};
      FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessManager::Name_, 4, false);
        return false;
      }
      FileSystemAccessManager::GetEntryFromDataTransferTokenCallback callback =
          FileSystemAccessManager_GetEntryFromDataTransferToken_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntryFromDataTransferToken(
std::move(p_token), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFileSystemAccessManagerValidationInfo[] = {
    {&internal::FileSystemAccessManager_GetSandboxedFileSystem_Params_Data::Validate,
     &internal::FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessManager_ChooseEntries_Params_Data::Validate,
     &internal::FileSystemAccessManager_ChooseEntries_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessManager_GetFileHandleFromToken_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FileSystemAccessManager_GetDirectoryHandleFromToken_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FileSystemAccessManager_GetEntryFromDataTransferToken_Params_Data::Validate,
     &internal::FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams_Data::Validate},
};

bool FileSystemAccessManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFileSystemAccessManagerValidationInfo);
}

bool FileSystemAccessManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFileSystemAccessManagerValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView, ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr>::Read(
    ::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView input,
    ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr* output) {
  bool success = true;
  ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr result(::blink::mojom::ChooseFileSystemEntryAcceptsOption::New());
  
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadMimeTypes(&result->mime_types))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AcceptsTypesInfo::DataView, ::blink::mojom::AcceptsTypesInfoPtr>::Read(
    ::blink::mojom::AcceptsTypesInfo::DataView input,
    ::blink::mojom::AcceptsTypesInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AcceptsTypesInfoPtr result(::blink::mojom::AcceptsTypesInfo::New());
  
      if (success && !input.ReadAccepts(&result->accepts))
        success = false;
      if (success)
        result->include_accepts_all = input.include_accepts_all();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::OpenFilePickerOptions::DataView, ::blink::mojom::OpenFilePickerOptionsPtr>::Read(
    ::blink::mojom::OpenFilePickerOptions::DataView input,
    ::blink::mojom::OpenFilePickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::OpenFilePickerOptionsPtr result(::blink::mojom::OpenFilePickerOptions::New());
  
      if (success && !input.ReadAcceptsTypesInfo(&result->accepts_types_info))
        success = false;
      if (success)
        result->can_select_multiple_files = input.can_select_multiple_files();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SaveFilePickerOptions::DataView, ::blink::mojom::SaveFilePickerOptionsPtr>::Read(
    ::blink::mojom::SaveFilePickerOptions::DataView input,
    ::blink::mojom::SaveFilePickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::SaveFilePickerOptionsPtr result(::blink::mojom::SaveFilePickerOptions::New());
  
      if (success && !input.ReadAcceptsTypesInfo(&result->accepts_types_info))
        success = false;
      if (success && !input.ReadSuggestedName(&result->suggested_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DirectoryPickerOptions::DataView, ::blink::mojom::DirectoryPickerOptionsPtr>::Read(
    ::blink::mojom::DirectoryPickerOptions::DataView input,
    ::blink::mojom::DirectoryPickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::DirectoryPickerOptionsPtr result(::blink::mojom::DirectoryPickerOptions::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CommonFilePickerOptions::DataView, ::blink::mojom::CommonFilePickerOptionsPtr>::Read(
    ::blink::mojom::CommonFilePickerOptions::DataView input,
    ::blink::mojom::CommonFilePickerOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::CommonFilePickerOptionsPtr result(::blink::mojom::CommonFilePickerOptions::New());
  
      if (success && !input.ReadStartingDirectoryId(&result->starting_directory_id))
        success = false;
      if (success && !input.ReadWellKnownStartingDirectory(&result->well_known_starting_directory))
        success = false;
      if (success) {
        result->starting_directory_token =
            input.TakeStartingDirectoryToken<decltype(result->starting_directory_token)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::FilePickerOptions::DataView, ::blink::mojom::FilePickerOptionsPtr>::Read(
    ::blink::mojom::FilePickerOptions::DataView input,
    ::blink::mojom::FilePickerOptionsPtr* output) {
  using UnionType = ::blink::mojom::FilePickerOptions;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::OPEN_FILE_PICKER_OPTIONS: {
      ::blink::mojom::OpenFilePickerOptionsPtr result_open_file_picker_options;
      if (!input.ReadOpenFilePickerOptions(&result_open_file_picker_options))
        return false;

      *output = UnionType::NewOpenFilePickerOptions(
          std::move(result_open_file_picker_options));
      break;
    }
    case Tag::SAVE_FILE_PICKER_OPTIONS: {
      ::blink::mojom::SaveFilePickerOptionsPtr result_save_file_picker_options;
      if (!input.ReadSaveFilePickerOptions(&result_save_file_picker_options))
        return false;

      *output = UnionType::NewSaveFilePickerOptions(
          std::move(result_save_file_picker_options));
      break;
    }
    case Tag::DIRECTORY_PICKER_OPTIONS: {
      ::blink::mojom::DirectoryPickerOptionsPtr result_directory_picker_options;
      if (!input.ReadDirectoryPickerOptions(&result_directory_picker_options))
        return false;

      *output = UnionType::NewDirectoryPickerOptions(
          std::move(result_directory_picker_options));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif