// third_party/blink/public/mojom/font_access/font_access.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string FontEnumerationStatusToString(FontEnumerationStatus value) {
  switch(value) {
    case FontEnumerationStatus::kOk:
      return "FontEnumerationStatus::kOk";
    case FontEnumerationStatus::kUnimplemented:
      return "FontEnumerationStatus::kUnimplemented";
    case FontEnumerationStatus::kUnexpectedError:
      return "FontEnumerationStatus::kUnexpectedError";
    case FontEnumerationStatus::kNeedsUserActivation:
      return "FontEnumerationStatus::kNeedsUserActivation";
    case FontEnumerationStatus::kNotVisible:
      return "FontEnumerationStatus::kNotVisible";
    case FontEnumerationStatus::kPermissionDenied:
      return "FontEnumerationStatus::kPermissionDenied";
    case FontEnumerationStatus::kCanceled:
      return "FontEnumerationStatus::kCanceled";
    default:
      return base::StringPrintf("Unknown FontEnumerationStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FontEnumerationStatus value) {
  return os << FontEnumerationStatusToString(value);
}

namespace internal {


// static
bool FontMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontMetadata_Data* object = static_cast<const FontMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->postscript_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams postscript_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->postscript_name, validation_context,
                                         &postscript_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->full_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams full_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->full_name, validation_context,
                                         &full_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams family_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->family, validation_context,
                                         &family_validate_params)) {
    return false;
  }

  return true;
}

FontMetadata_Data::FontMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontAccessManager_EnumerateLocalFonts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontAccessManager_EnumerateLocalFonts_Params_Data* object = static_cast<const FontAccessManager_EnumerateLocalFonts_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FontAccessManager_EnumerateLocalFonts_Params_Data::FontAccessManager_EnumerateLocalFonts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontAccessManager_EnumerateLocalFonts_ResponseParams_Data* object = static_cast<const FontAccessManager_EnumerateLocalFonts_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FontEnumerationStatus_Data
        ::Validate(object->enumeration_status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->enumeration_table, validation_context))
    return false;

  return true;
}

FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontAccessManager_ChooseLocalFonts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontAccessManager_ChooseLocalFonts_Params_Data* object = static_cast<const FontAccessManager_ChooseLocalFonts_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams selection_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->selection, validation_context,
                                         &selection_validate_params)) {
    return false;
  }

  return true;
}

FontAccessManager_ChooseLocalFonts_Params_Data::FontAccessManager_ChooseLocalFonts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontAccessManager_ChooseLocalFonts_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontAccessManager_ChooseLocalFonts_ResponseParams_Data* object = static_cast<const FontAccessManager_ChooseLocalFonts_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FontEnumerationStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chosen_fonts, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams chosen_fonts_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->chosen_fonts, validation_context,
                                         &chosen_fonts_validate_params)) {
    return false;
  }

  return true;
}

FontAccessManager_ChooseLocalFonts_ResponseParams_Data::FontAccessManager_ChooseLocalFonts_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FontEnumerationStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::FontEnumerationStatus value) {
  return std::move(context).WriteString(::blink::mojom::FontEnumerationStatusToString(value));
}

} // namespace perfetto
