// third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string RendererEvictionReasonToString(RendererEvictionReason value) {
  switch(value) {
    case RendererEvictionReason::kJavaScriptExecution:
      return "RendererEvictionReason::kJavaScriptExecution";
    case RendererEvictionReason::kNetworkRequestDatapipeDrained:
      return "RendererEvictionReason::kNetworkRequestDatapipeDrained";
    case RendererEvictionReason::kNetworkRequestRedirected:
      return "RendererEvictionReason::kNetworkRequestRedirected";
    case RendererEvictionReason::kNetworkRequestTimeout:
      return "RendererEvictionReason::kNetworkRequestTimeout";
    case RendererEvictionReason::kNetworkExceedsBufferLimit:
      return "RendererEvictionReason::kNetworkExceedsBufferLimit";
    default:
      return base::StringPrintf("Unknown RendererEvictionReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RendererEvictionReason value) {
  return os << RendererEvictionReasonToString(value);
}

namespace internal {


// static
bool BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data* object = static_cast<const BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::RendererEvictionReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data::BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RendererEvictionReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::RendererEvictionReason value) {
  return std::move(context).WriteString(::blink::mojom::RendererEvictionReasonToString(value));
}

} // namespace perfetto
