// third_party/blink/public/mojom/frame/frame.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/frame/frame.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "cc/mojom/browser_controls_state.mojom.h"
#include "cc/mojom/render_frame_metadata.mojom.h"
#include "cc/mojom/touch_action.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom.h"
#include "services/network/public/mojom/source_location.mojom.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "third_party/blink/public/mojom/ad_tagging/ad_frame.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom.h"
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom.h"
#include "third_party/blink/public/mojom/frame/blocked_navigation_types.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom.h"
#include "third_party/blink/public/mojom/frame/media_player_action.mojom.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom.h"
#include "third_party/blink/public/mojom/frame/sudden_termination_disabler_type.mojom.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom.h"
#include "third_party/blink/public/mojom/modal_close_watcher/modal_close_listener.mojom.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/portal/portal.mojom.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/events/mojom/scroll_granularity.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/range/mojom/range.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_JUMBO_H_
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#include "third_party/blink/public/common/messaging/cloneable_message_mojom_traits.h"
#include "third_party/blink/public/common/messaging/transferable_message_mojom_traits.h"
#endif


namespace blink {
namespace mojom {


KeepAliveHandleAsyncWaiter::KeepAliveHandleAsyncWaiter(
    KeepAliveHandle* proxy) : proxy_(proxy) {}

KeepAliveHandleAsyncWaiter::~KeepAliveHandleAsyncWaiter() = default;




void KeepAliveHandleFactoryInterceptorForTesting::IssueKeepAliveHandle(::mojo::PendingReceiver<KeepAliveHandle> keep_alive_handle) {
  GetForwardingInterface()->IssueKeepAliveHandle(std::move(keep_alive_handle));
}
KeepAliveHandleFactoryAsyncWaiter::KeepAliveHandleFactoryAsyncWaiter(
    KeepAliveHandleFactory* proxy) : proxy_(proxy) {}

KeepAliveHandleFactoryAsyncWaiter::~KeepAliveHandleFactoryAsyncWaiter() = default;




void LocalFrameHostInterceptorForTesting::EnterFullscreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullscreenCallback callback) {
  GetForwardingInterface()->EnterFullscreen(std::move(options), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::ExitFullscreen() {
  GetForwardingInterface()->ExitFullscreen();
}
void LocalFrameHostInterceptorForTesting::FullscreenStateChanged(bool is_fullscreen, ::blink::mojom::FullscreenOptionsPtr options) {
  GetForwardingInterface()->FullscreenStateChanged(std::move(is_fullscreen), std::move(options));
}
void LocalFrameHostInterceptorForTesting::RegisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) {
  GetForwardingInterface()->RegisterProtocolHandler(std::move(scheme), std::move(url), std::move(user_gesture));
}
void LocalFrameHostInterceptorForTesting::UnregisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) {
  GetForwardingInterface()->UnregisterProtocolHandler(std::move(scheme), std::move(url), std::move(user_gesture));
}
void LocalFrameHostInterceptorForTesting::DidDisplayInsecureContent() {
  GetForwardingInterface()->DidDisplayInsecureContent();
}
void LocalFrameHostInterceptorForTesting::DidContainInsecureFormAction() {
  GetForwardingInterface()->DidContainInsecureFormAction();
}
void LocalFrameHostInterceptorForTesting::DocumentAvailableInMainFrame(bool uses_temporary_zoom_level) {
  GetForwardingInterface()->DocumentAvailableInMainFrame(std::move(uses_temporary_zoom_level));
}
void LocalFrameHostInterceptorForTesting::SetNeedsOcclusionTracking(bool needs_tracking) {
  GetForwardingInterface()->SetNeedsOcclusionTracking(std::move(needs_tracking));
}
void LocalFrameHostInterceptorForTesting::SetVirtualKeyboardOverlayPolicy(bool vk_overlays_content) {
  GetForwardingInterface()->SetVirtualKeyboardOverlayPolicy(std::move(vk_overlays_content));
}
void LocalFrameHostInterceptorForTesting::VisibilityChanged(::blink::mojom::FrameVisibility visibility) {
  GetForwardingInterface()->VisibilityChanged(std::move(visibility));
}
void LocalFrameHostInterceptorForTesting::DidChangeThemeColor(base::Optional<::SkColor> theme_color) {
  GetForwardingInterface()->DidChangeThemeColor(std::move(theme_color));
}
void LocalFrameHostInterceptorForTesting::DidChangeBackgroundColor(::SkColor background_color, bool color_adjust) {
  GetForwardingInterface()->DidChangeBackgroundColor(std::move(background_color), std::move(color_adjust));
}
void LocalFrameHostInterceptorForTesting::DidFailLoadWithError(const ::GURL& url, int32_t error_code) {
  GetForwardingInterface()->DidFailLoadWithError(std::move(url), std::move(error_code));
}
void LocalFrameHostInterceptorForTesting::DidFocusFrame() {
  GetForwardingInterface()->DidFocusFrame();
}
void LocalFrameHostInterceptorForTesting::DidCallFocus() {
  GetForwardingInterface()->DidCallFocus();
}
void LocalFrameHostInterceptorForTesting::DidAddContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyPtr> policies) {
  GetForwardingInterface()->DidAddContentSecurityPolicies(std::move(policies));
}
void LocalFrameHostInterceptorForTesting::EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy_bitmap) {
  GetForwardingInterface()->EnforceInsecureRequestPolicy(std::move(policy_bitmap));
}
void LocalFrameHostInterceptorForTesting::EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) {
  GetForwardingInterface()->EnforceInsecureNavigationsSet(std::move(set));
}
void LocalFrameHostInterceptorForTesting::DidChangeActiveSchedulerTrackedFeatures(uint64_t features_mask) {
  GetForwardingInterface()->DidChangeActiveSchedulerTrackedFeatures(std::move(features_mask));
}
void LocalFrameHostInterceptorForTesting::SuddenTerminationDisablerChanged(bool present, ::blink::mojom::SuddenTerminationDisablerType disabler_type) {
  GetForwardingInterface()->SuddenTerminationDisablerChanged(std::move(present), std::move(disabler_type));
}
void LocalFrameHostInterceptorForTesting::HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) {
  GetForwardingInterface()->HadStickyUserActivationBeforeNavigationChanged(std::move(has_gesture));
}
void LocalFrameHostInterceptorForTesting::ScrollRectToVisibleInParentFrame(const ::gfx::Rect& rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr params) {
  GetForwardingInterface()->ScrollRectToVisibleInParentFrame(std::move(rect_to_scroll), std::move(params));
}
void LocalFrameHostInterceptorForTesting::BubbleLogicalScrollInParentFrame(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) {
  GetForwardingInterface()->BubbleLogicalScrollInParentFrame(std::move(direction), std::move(granularity));
}
void LocalFrameHostInterceptorForTesting::DidAccessInitialDocument() {
  GetForwardingInterface()->DidAccessInitialDocument();
}
void LocalFrameHostInterceptorForTesting::DidBlockNavigation(const ::GURL& blocked_url, const ::GURL& initiator_url, ::blink::mojom::NavigationBlockedReason reason) {
  GetForwardingInterface()->DidBlockNavigation(std::move(blocked_url), std::move(initiator_url), std::move(reason));
}
void LocalFrameHostInterceptorForTesting::DidChangeLoadProgress(double load_progress) {
  GetForwardingInterface()->DidChangeLoadProgress(std::move(load_progress));
}
void LocalFrameHostInterceptorForTesting::DidFinishLoad(const ::GURL& validated_url) {
  GetForwardingInterface()->DidFinishLoad(std::move(validated_url));
}
void LocalFrameHostInterceptorForTesting::DispatchLoad() {
  GetForwardingInterface()->DispatchLoad();
}
void LocalFrameHostInterceptorForTesting::GoToEntryAtOffset(int32_t offset, bool has_user_gesture) {
  GetForwardingInterface()->GoToEntryAtOffset(std::move(offset), std::move(has_user_gesture));
}
void LocalFrameHostInterceptorForTesting::RenderFallbackContentInParentProcess() {
  GetForwardingInterface()->RenderFallbackContentInParentProcess();
}
void LocalFrameHostInterceptorForTesting::UpdateTitle(const base::Optional<::base::string16>& title, ::base::i18n::TextDirection title_direction) {
  GetForwardingInterface()->UpdateTitle(std::move(title), std::move(title_direction));
}
void LocalFrameHostInterceptorForTesting::UpdateUserActivationState(::blink::mojom::UserActivationUpdateType update_type, ::blink::mojom::UserActivationNotificationType notification_type) {
  GetForwardingInterface()->UpdateUserActivationState(std::move(update_type), std::move(notification_type));
}
void LocalFrameHostInterceptorForTesting::HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) {
  GetForwardingInterface()->HandleAccessibilityFindInPageResult(std::move(params));
}
void LocalFrameHostInterceptorForTesting::HandleAccessibilityFindInPageTermination() {
  GetForwardingInterface()->HandleAccessibilityFindInPageTermination();
}
void LocalFrameHostInterceptorForTesting::DocumentOnLoadCompleted() {
  GetForwardingInterface()->DocumentOnLoadCompleted();
}
void LocalFrameHostInterceptorForTesting::ForwardResourceTimingToParent(::blink::mojom::ResourceTimingInfoPtr timing) {
  GetForwardingInterface()->ForwardResourceTimingToParent(std::move(timing));
}
void LocalFrameHostInterceptorForTesting::DidFinishDocumentLoad() {
  GetForwardingInterface()->DidFinishDocumentLoad();
}
void LocalFrameHostInterceptorForTesting::RunModalAlertDialog(const ::base::string16& alert_message, RunModalAlertDialogCallback callback) {
  GetForwardingInterface()->RunModalAlertDialog(std::move(alert_message), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::RunModalConfirmDialog(const ::base::string16& alert_message, RunModalConfirmDialogCallback callback) {
  GetForwardingInterface()->RunModalConfirmDialog(std::move(alert_message), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::RunModalPromptDialog(const ::base::string16& alert_message, const ::base::string16& default_value, RunModalPromptDialogCallback callback) {
  GetForwardingInterface()->RunModalPromptDialog(std::move(alert_message), std::move(default_value), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) {
  GetForwardingInterface()->RunBeforeUnloadConfirm(std::move(is_reload), std::move(callback));
}
void LocalFrameHostInterceptorForTesting::UpdateFaviconURL(std::vector<::blink::mojom::FaviconURLPtr> favicon_urls) {
  GetForwardingInterface()->UpdateFaviconURL(std::move(favicon_urls));
}
void LocalFrameHostInterceptorForTesting::DownloadURL(DownloadURLParamsPtr params) {
  GetForwardingInterface()->DownloadURL(std::move(params));
}
void LocalFrameHostInterceptorForTesting::FocusedElementChanged(bool is_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::FocusType focus_type) {
  GetForwardingInterface()->FocusedElementChanged(std::move(is_editable_element), std::move(bounds_in_frame_widget), std::move(focus_type));
}
void LocalFrameHostInterceptorForTesting::TextSelectionChanged(const ::base::string16& text, uint32_t offset, const ::gfx::Range& range, bool user_initiated) {
  GetForwardingInterface()->TextSelectionChanged(std::move(text), std::move(offset), std::move(range), std::move(user_initiated));
}
void LocalFrameHostInterceptorForTesting::ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, int32_t item_height, double font_size, int32_t selected_item, std::vector<::blink::mojom::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) {
  GetForwardingInterface()->ShowPopupMenu(std::move(popup_client), std::move(bounds), std::move(item_height), std::move(font_size), std::move(selected_item), std::move(menu_items), std::move(right_aligned), std::move(allow_multiple_selection));
}
void LocalFrameHostInterceptorForTesting::ShowContextMenu(::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> client, const ::blink::UntrustworthyContextMenuParams& params) {
  GetForwardingInterface()->ShowContextMenu(std::move(client), std::move(params));
}
void LocalFrameHostInterceptorForTesting::DidLoadResourceFromMemoryCache(const ::GURL& url, const std::string& http_method, const std::string& mime_type, ::network::mojom::RequestDestination request_destination) {
  GetForwardingInterface()->DidLoadResourceFromMemoryCache(std::move(url), std::move(http_method), std::move(mime_type), std::move(request_destination));
}
void LocalFrameHostInterceptorForTesting::DidChangeFrameOwnerProperties(const ::blink::FrameToken& child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties) {
  GetForwardingInterface()->DidChangeFrameOwnerProperties(std::move(child_frame_token), std::move(frame_owner_properties));
}
void LocalFrameHostInterceptorForTesting::DidChangeOpener(const base::Optional<::blink::LocalFrameToken>& opener_frame) {
  GetForwardingInterface()->DidChangeOpener(std::move(opener_frame));
}
void LocalFrameHostInterceptorForTesting::DidChangeFramePolicy(const ::blink::FrameToken& child_frame_token, const ::blink::FramePolicy& frame_policy) {
  GetForwardingInterface()->DidChangeFramePolicy(std::move(child_frame_token), std::move(frame_policy));
}
void LocalFrameHostInterceptorForTesting::DidChangeCSPAttribute(const ::blink::FrameToken& child_frame_token, ::network::mojom::ContentSecurityPolicyPtr parsed_csp_attribute) {
  GetForwardingInterface()->DidChangeCSPAttribute(std::move(child_frame_token), std::move(parsed_csp_attribute));
}
void LocalFrameHostInterceptorForTesting::CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) {
  GetForwardingInterface()->CapturePaintPreviewOfSubframe(std::move(clip_rect), std::move(guid));
}
void LocalFrameHostInterceptorForTesting::SetModalCloseListener(::mojo::PendingRemote<::blink::mojom::ModalCloseListener> listener) {
  GetForwardingInterface()->SetModalCloseListener(std::move(listener));
}
void LocalFrameHostInterceptorForTesting::Detach() {
  GetForwardingInterface()->Detach();
}
void LocalFrameHostInterceptorForTesting::GetKeepAliveHandleFactory(::mojo::PendingReceiver<KeepAliveHandleFactory> factory) {
  GetForwardingInterface()->GetKeepAliveHandleFactory(std::move(factory));
}
void LocalFrameHostInterceptorForTesting::DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const ::base::string16& msg, int32_t line_number, const base::Optional<::base::string16>& source_id, const base::Optional<::base::string16>& untrusted_stack_trace) {
  GetForwardingInterface()->DidAddMessageToConsole(std::move(log_level), std::move(msg), std::move(line_number), std::move(source_id), std::move(untrusted_stack_trace));
}
void LocalFrameHostInterceptorForTesting::FrameSizeChanged(const ::gfx::Size& size) {
  GetForwardingInterface()->FrameSizeChanged(std::move(size));
}
LocalFrameHostAsyncWaiter::LocalFrameHostAsyncWaiter(
    LocalFrameHost* proxy) : proxy_(proxy) {}

LocalFrameHostAsyncWaiter::~LocalFrameHostAsyncWaiter() = default;

void LocalFrameHostAsyncWaiter::EnterFullscreen(
    ::blink::mojom::FullscreenOptionsPtr options, bool* out_granted) {
  base::RunLoop loop;
  proxy_->EnterFullscreen(std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_granted
,
             bool granted) {*out_granted = std::move(granted);
            loop->Quit();
          },
          &loop,
          out_granted));
  loop.Run();
}
void LocalFrameHostAsyncWaiter::RunModalAlertDialog(
    const ::base::string16& alert_message) {
  base::RunLoop loop;
  proxy_->RunModalAlertDialog(std::move(alert_message),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void LocalFrameHostAsyncWaiter::RunModalConfirmDialog(
    const ::base::string16& alert_message, bool* out_success) {
  base::RunLoop loop;
  proxy_->RunModalConfirmDialog(std::move(alert_message),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void LocalFrameHostAsyncWaiter::RunModalPromptDialog(
    const ::base::string16& alert_message, const ::base::string16& default_value, bool* out_success, ::base::string16* out_result) {
  base::RunLoop loop;
  proxy_->RunModalPromptDialog(std::move(alert_message),std::move(default_value),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::base::string16* out_result
,
             bool success,
             const ::base::string16& result) {*out_success = std::move(success);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_success,
          out_result));
  loop.Run();
}
void LocalFrameHostAsyncWaiter::RunBeforeUnloadConfirm(
    bool is_reload, bool* out_success) {
  base::RunLoop loop;
  proxy_->RunBeforeUnloadConfirm(std::move(is_reload),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}



void LocalFrameInterceptorForTesting::GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) {
  GetForwardingInterface()->GetTextSurroundingSelection(std::move(max_length), std::move(callback));
}
void LocalFrameInterceptorForTesting::SendInterventionReport(const std::string& id, const std::string& message) {
  GetForwardingInterface()->SendInterventionReport(std::move(id), std::move(message));
}
void LocalFrameInterceptorForTesting::SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) {
  GetForwardingInterface()->SetFrameOwnerProperties(std::move(properties));
}
void LocalFrameInterceptorForTesting::NotifyUserActivation(::blink::mojom::UserActivationNotificationType notification_type) {
  GetForwardingInterface()->NotifyUserActivation(std::move(notification_type));
}
void LocalFrameInterceptorForTesting::NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) {
  GetForwardingInterface()->NotifyVirtualKeyboardOverlayRect(std::move(keyboard_rect));
}
void LocalFrameInterceptorForTesting::AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message, bool discard_duplicates) {
  GetForwardingInterface()->AddMessageToConsole(std::move(level), std::move(message), std::move(discard_duplicates));
}
void LocalFrameInterceptorForTesting::AddInspectorIssue(::blink::mojom::InspectorIssueInfoPtr info) {
  GetForwardingInterface()->AddInspectorIssue(std::move(info));
}
void LocalFrameInterceptorForTesting::SwapInImmediately() {
  GetForwardingInterface()->SwapInImmediately();
}
void LocalFrameInterceptorForTesting::CheckCompleted() {
  GetForwardingInterface()->CheckCompleted();
}
void LocalFrameInterceptorForTesting::StopLoading() {
  GetForwardingInterface()->StopLoading();
}
void LocalFrameInterceptorForTesting::Collapse(bool collapsed) {
  GetForwardingInterface()->Collapse(std::move(collapsed));
}
void LocalFrameInterceptorForTesting::EnableViewSourceMode() {
  GetForwardingInterface()->EnableViewSourceMode();
}
void LocalFrameInterceptorForTesting::Focus() {
  GetForwardingInterface()->Focus();
}
void LocalFrameInterceptorForTesting::ClearFocusedElement() {
  GetForwardingInterface()->ClearFocusedElement();
}
void LocalFrameInterceptorForTesting::GetResourceSnapshotForWebBundle(::mojo::PendingReceiver<::data_decoder::mojom::ResourceSnapshotForWebBundle> receiver) {
  GetForwardingInterface()->GetResourceSnapshotForWebBundle(std::move(receiver));
}
void LocalFrameInterceptorForTesting::CopyImageAt(const ::gfx::Point& window_point) {
  GetForwardingInterface()->CopyImageAt(std::move(window_point));
}
void LocalFrameInterceptorForTesting::SaveImageAt(const ::gfx::Point& window_point) {
  GetForwardingInterface()->SaveImageAt(std::move(window_point));
}
void LocalFrameInterceptorForTesting::ReportBlinkFeatureUsage(const std::vector<::blink::mojom::WebFeature>& features) {
  GetForwardingInterface()->ReportBlinkFeatureUsage(std::move(features));
}
void LocalFrameInterceptorForTesting::RenderFallbackContent() {
  GetForwardingInterface()->RenderFallbackContent();
}
void LocalFrameInterceptorForTesting::BeforeUnload(bool is_reload, BeforeUnloadCallback callback) {
  GetForwardingInterface()->BeforeUnload(std::move(is_reload), std::move(callback));
}
void LocalFrameInterceptorForTesting::MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::MediaPlayerActionPtr action) {
  GetForwardingInterface()->MediaPlayerActionAt(std::move(location), std::move(action));
}
void LocalFrameInterceptorForTesting::AdvanceFocusInFrame(::blink::mojom::FocusType focus_type, const base::Optional<::blink::RemoteFrameToken>& source_frame_token) {
  GetForwardingInterface()->AdvanceFocusInFrame(std::move(focus_type), std::move(source_frame_token));
}
void LocalFrameInterceptorForTesting::AdvanceFocusInForm(::blink::mojom::FocusType focus_type) {
  GetForwardingInterface()->AdvanceFocusInForm(std::move(focus_type));
}
void LocalFrameInterceptorForTesting::ReportContentSecurityPolicyViolation(::network::mojom::CSPViolationPtr violation) {
  GetForwardingInterface()->ReportContentSecurityPolicyViolation(std::move(violation));
}
void LocalFrameInterceptorForTesting::DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) {
  GetForwardingInterface()->DidUpdateFramePolicy(std::move(frame_policy));
}
void LocalFrameInterceptorForTesting::OnScreensChange() {
  GetForwardingInterface()->OnScreensChange();
}
void LocalFrameInterceptorForTesting::PostMessageEvent(const base::Optional<::blink::RemoteFrameToken>& source_frame_token, const ::base::string16& source_origin, const ::base::string16& target_origin, ::blink::TransferableMessage message) {
  GetForwardingInterface()->PostMessageEvent(std::move(source_frame_token), std::move(source_origin), std::move(target_origin), std::move(message));
}
void LocalFrameInterceptorForTesting::BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::ReportingObserver> receiver) {
  GetForwardingInterface()->BindReportingObserver(std::move(receiver));
}
void LocalFrameInterceptorForTesting::UpdateOpener(const base::Optional<::blink::FrameToken>& opener_frame_token) {
  GetForwardingInterface()->UpdateOpener(std::move(opener_frame_token));
}
void LocalFrameInterceptorForTesting::GetSavableResourceLinks(GetSavableResourceLinksCallback callback) {
  GetForwardingInterface()->GetSavableResourceLinks(std::move(callback));
}
void LocalFrameInterceptorForTesting::MixedContentFound(const ::GURL& main_resource_url, const ::GURL& mixed_content_url, ::blink::mojom::RequestContextType request_context, bool was_allowed, const ::GURL& url_before_redirects, bool had_redirect, ::network::mojom::SourceLocationPtr source_location) {
  GetForwardingInterface()->MixedContentFound(std::move(main_resource_url), std::move(mixed_content_url), std::move(request_context), std::move(was_allowed), std::move(url_before_redirects), std::move(had_redirect), std::move(source_location));
}
LocalFrameAsyncWaiter::LocalFrameAsyncWaiter(
    LocalFrame* proxy) : proxy_(proxy) {}

LocalFrameAsyncWaiter::~LocalFrameAsyncWaiter() = default;

void LocalFrameAsyncWaiter::GetTextSurroundingSelection(
    uint32_t max_length, ::base::string16* out_content, uint32_t* out_start_offset, uint32_t* out_end_offset) {
  base::RunLoop loop;
  proxy_->GetTextSurroundingSelection(std::move(max_length),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::string16* out_content
,
             uint32_t* out_start_offset
,
             uint32_t* out_end_offset
,
             const ::base::string16& content,
             uint32_t start_offset,
             uint32_t end_offset) {*out_content = std::move(content);*out_start_offset = std::move(start_offset);*out_end_offset = std::move(end_offset);
            loop->Quit();
          },
          &loop,
          out_content,
          out_start_offset,
          out_end_offset));
  loop.Run();
}
void LocalFrameAsyncWaiter::BeforeUnload(
    bool is_reload, bool* out_proceed, ::base::TimeTicks* out_before_unload_start_time, ::base::TimeTicks* out_before_unload_end_time) {
  base::RunLoop loop;
  proxy_->BeforeUnload(std::move(is_reload),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_proceed
,
             ::base::TimeTicks* out_before_unload_start_time
,
             ::base::TimeTicks* out_before_unload_end_time
,
             bool proceed,
             ::base::TimeTicks before_unload_start_time,
             ::base::TimeTicks before_unload_end_time) {*out_proceed = std::move(proceed);*out_before_unload_start_time = std::move(before_unload_start_time);*out_before_unload_end_time = std::move(before_unload_end_time);
            loop->Quit();
          },
          &loop,
          out_proceed,
          out_before_unload_start_time,
          out_before_unload_end_time));
  loop.Run();
}
void LocalFrameAsyncWaiter::GetSavableResourceLinks(
    GetSavableResourceLinksReplyPtr* out_reply) {
  base::RunLoop loop;
  proxy_->GetSavableResourceLinks(
      base::BindOnce(
          [](base::RunLoop* loop,
             GetSavableResourceLinksReplyPtr* out_reply
,
             GetSavableResourceLinksReplyPtr reply) {*out_reply = std::move(reply);
            loop->Quit();
          },
          &loop,
          out_reply));
  loop.Run();
}



void HighPriorityLocalFrameInterceptorForTesting::DispatchBeforeUnload(bool is_reload, DispatchBeforeUnloadCallback callback) {
  GetForwardingInterface()->DispatchBeforeUnload(std::move(is_reload), std::move(callback));
}
HighPriorityLocalFrameAsyncWaiter::HighPriorityLocalFrameAsyncWaiter(
    HighPriorityLocalFrame* proxy) : proxy_(proxy) {}

HighPriorityLocalFrameAsyncWaiter::~HighPriorityLocalFrameAsyncWaiter() = default;

void HighPriorityLocalFrameAsyncWaiter::DispatchBeforeUnload(
    bool is_reload, bool* out_proceed, ::base::TimeTicks* out_before_unload_start_time, ::base::TimeTicks* out_before_unload_end_time) {
  base::RunLoop loop;
  proxy_->DispatchBeforeUnload(std::move(is_reload),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_proceed
,
             ::base::TimeTicks* out_before_unload_start_time
,
             ::base::TimeTicks* out_before_unload_end_time
,
             bool proceed,
             ::base::TimeTicks before_unload_start_time,
             ::base::TimeTicks before_unload_end_time) {*out_proceed = std::move(proceed);*out_before_unload_start_time = std::move(before_unload_start_time);*out_before_unload_end_time = std::move(before_unload_end_time);
            loop->Quit();
          },
          &loop,
          out_proceed,
          out_before_unload_start_time,
          out_before_unload_end_time));
  loop.Run();
}



void RemoteFrameHostInterceptorForTesting::SetInheritedEffectiveTouchAction(::cc::TouchAction touch_action) {
  GetForwardingInterface()->SetInheritedEffectiveTouchAction(std::move(touch_action));
}
void RemoteFrameHostInterceptorForTesting::UpdateRenderThrottlingStatus(bool is_throttled, bool subtree_throttled, bool display_locked) {
  GetForwardingInterface()->UpdateRenderThrottlingStatus(std::move(is_throttled), std::move(subtree_throttled), std::move(display_locked));
}
void RemoteFrameHostInterceptorForTesting::VisibilityChanged(::blink::mojom::FrameVisibility visibility) {
  GetForwardingInterface()->VisibilityChanged(std::move(visibility));
}
void RemoteFrameHostInterceptorForTesting::DidFocusFrame() {
  GetForwardingInterface()->DidFocusFrame();
}
void RemoteFrameHostInterceptorForTesting::CheckCompleted() {
  GetForwardingInterface()->CheckCompleted();
}
void RemoteFrameHostInterceptorForTesting::CapturePaintPreviewOfCrossProcessSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) {
  GetForwardingInterface()->CapturePaintPreviewOfCrossProcessSubframe(std::move(clip_rect), std::move(guid));
}
void RemoteFrameHostInterceptorForTesting::SetIsInert(bool inert) {
  GetForwardingInterface()->SetIsInert(std::move(inert));
}
void RemoteFrameHostInterceptorForTesting::DidChangeOpener(const base::Optional<::blink::LocalFrameToken>& opener_frame) {
  GetForwardingInterface()->DidChangeOpener(std::move(opener_frame));
}
void RemoteFrameHostInterceptorForTesting::AdvanceFocus(::blink::mojom::FocusType focus_type, const ::blink::LocalFrameToken& source_frame_token) {
  GetForwardingInterface()->AdvanceFocus(std::move(focus_type), std::move(source_frame_token));
}
void RemoteFrameHostInterceptorForTesting::RouteMessageEvent(const base::Optional<::blink::LocalFrameToken>& source_frame_token, const ::base::string16& source_origin, const ::base::string16& target_origin, ::blink::TransferableMessage message) {
  GetForwardingInterface()->RouteMessageEvent(std::move(source_frame_token), std::move(source_origin), std::move(target_origin), std::move(message));
}
void RemoteFrameHostInterceptorForTesting::PrintCrossProcessSubframe(const ::gfx::Rect& frame_content_rect, int32_t document_cookie) {
  GetForwardingInterface()->PrintCrossProcessSubframe(std::move(frame_content_rect), std::move(document_cookie));
}
void RemoteFrameHostInterceptorForTesting::Detach() {
  GetForwardingInterface()->Detach();
}
void RemoteFrameHostInterceptorForTesting::UpdateViewportIntersection(::blink::mojom::ViewportIntersectionStatePtr intersection_state, const base::Optional<::blink::FrameVisualProperties>& visual_properties) {
  GetForwardingInterface()->UpdateViewportIntersection(std::move(intersection_state), std::move(visual_properties));
}
void RemoteFrameHostInterceptorForTesting::SynchronizeVisualProperties(const ::blink::FrameVisualProperties& properties) {
  GetForwardingInterface()->SynchronizeVisualProperties(std::move(properties));
}
RemoteFrameHostAsyncWaiter::RemoteFrameHostAsyncWaiter(
    RemoteFrameHost* proxy) : proxy_(proxy) {}

RemoteFrameHostAsyncWaiter::~RemoteFrameHostAsyncWaiter() = default;




void RemoteFrameInterceptorForTesting::WillEnterFullscreen(::blink::mojom::FullscreenOptionsPtr options) {
  GetForwardingInterface()->WillEnterFullscreen(std::move(options));
}
void RemoteFrameInterceptorForTesting::AddReplicatedContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyPtr> csps) {
  GetForwardingInterface()->AddReplicatedContentSecurityPolicies(std::move(csps));
}
void RemoteFrameInterceptorForTesting::ResetReplicatedContentSecurityPolicy() {
  GetForwardingInterface()->ResetReplicatedContentSecurityPolicy();
}
void RemoteFrameInterceptorForTesting::EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) {
  GetForwardingInterface()->EnforceInsecureNavigationsSet(std::move(set));
}
void RemoteFrameInterceptorForTesting::SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) {
  GetForwardingInterface()->SetFrameOwnerProperties(std::move(properties));
}
void RemoteFrameInterceptorForTesting::EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy) {
  GetForwardingInterface()->EnforceInsecureRequestPolicy(std::move(policy));
}
void RemoteFrameInterceptorForTesting::SetReplicatedOrigin(const ::url::Origin& origin, bool is_potentially_trustworthy_unique_origin) {
  GetForwardingInterface()->SetReplicatedOrigin(std::move(origin), std::move(is_potentially_trustworthy_unique_origin));
}
void RemoteFrameInterceptorForTesting::SetReplicatedAdFrameType(::blink::mojom::AdFrameType ad_frame_type) {
  GetForwardingInterface()->SetReplicatedAdFrameType(std::move(ad_frame_type));
}
void RemoteFrameInterceptorForTesting::SetReplicatedName(const std::string& name, const std::string& unique_name) {
  GetForwardingInterface()->SetReplicatedName(std::move(name), std::move(unique_name));
}
void RemoteFrameInterceptorForTesting::DispatchLoadEventForFrameOwner() {
  GetForwardingInterface()->DispatchLoadEventForFrameOwner();
}
void RemoteFrameInterceptorForTesting::SetNeedsOcclusionTracking(bool needs_tracking) {
  GetForwardingInterface()->SetNeedsOcclusionTracking(std::move(needs_tracking));
}
void RemoteFrameInterceptorForTesting::Collapse(bool collapsed) {
  GetForwardingInterface()->Collapse(std::move(collapsed));
}
void RemoteFrameInterceptorForTesting::Focus() {
  GetForwardingInterface()->Focus();
}
void RemoteFrameInterceptorForTesting::SetHadStickyUserActivationBeforeNavigation(bool has_gesture) {
  GetForwardingInterface()->SetHadStickyUserActivationBeforeNavigation(std::move(has_gesture));
}
void RemoteFrameInterceptorForTesting::BubbleLogicalScroll(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) {
  GetForwardingInterface()->BubbleLogicalScroll(std::move(direction), std::move(granularity));
}
void RemoteFrameInterceptorForTesting::UpdateUserActivationState(::blink::mojom::UserActivationUpdateType state_update_type, ::blink::mojom::UserActivationNotificationType notification_type) {
  GetForwardingInterface()->UpdateUserActivationState(std::move(state_update_type), std::move(notification_type));
}
void RemoteFrameInterceptorForTesting::SetEmbeddingToken(const ::base::UnguessableToken& embedding_token) {
  GetForwardingInterface()->SetEmbeddingToken(std::move(embedding_token));
}
void RemoteFrameInterceptorForTesting::SetPageFocus(bool is_focused) {
  GetForwardingInterface()->SetPageFocus(std::move(is_focused));
}
void RemoteFrameInterceptorForTesting::RenderFallbackContent() {
  GetForwardingInterface()->RenderFallbackContent();
}
void RemoteFrameInterceptorForTesting::AddResourceTimingFromChild(::blink::mojom::ResourceTimingInfoPtr timing) {
  GetForwardingInterface()->AddResourceTimingFromChild(std::move(timing));
}
void RemoteFrameInterceptorForTesting::ScrollRectToVisible(const ::gfx::Rect& rect, ::blink::mojom::ScrollIntoViewParamsPtr params) {
  GetForwardingInterface()->ScrollRectToVisible(std::move(rect), std::move(params));
}
void RemoteFrameInterceptorForTesting::DidStartLoading() {
  GetForwardingInterface()->DidStartLoading();
}
void RemoteFrameInterceptorForTesting::DidStopLoading() {
  GetForwardingInterface()->DidStopLoading();
}
void RemoteFrameInterceptorForTesting::IntrinsicSizingInfoOfChildChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) {
  GetForwardingInterface()->IntrinsicSizingInfoOfChildChanged(std::move(sizing_info));
}
void RemoteFrameInterceptorForTesting::DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::blink::ParsedFeaturePolicyDeclaration>& parsed_feature_policy) {
  GetForwardingInterface()->DidSetFramePolicyHeaders(std::move(sandbox_flags), std::move(parsed_feature_policy));
}
void RemoteFrameInterceptorForTesting::DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) {
  GetForwardingInterface()->DidUpdateFramePolicy(std::move(frame_policy));
}
void RemoteFrameInterceptorForTesting::UpdateOpener(const base::Optional<::blink::FrameToken>& opener_frame_token) {
  GetForwardingInterface()->UpdateOpener(std::move(opener_frame_token));
}
void RemoteFrameInterceptorForTesting::DetachAndDispose() {
  GetForwardingInterface()->DetachAndDispose();
}
void RemoteFrameInterceptorForTesting::EnableAutoResize(const ::gfx::Size& min_size, const ::gfx::Size& max_size) {
  GetForwardingInterface()->EnableAutoResize(std::move(min_size), std::move(max_size));
}
void RemoteFrameInterceptorForTesting::DisableAutoResize() {
  GetForwardingInterface()->DisableAutoResize();
}
void RemoteFrameInterceptorForTesting::DidUpdateVisualProperties(const ::cc::RenderFrameMetadata& metadata) {
  GetForwardingInterface()->DidUpdateVisualProperties(std::move(metadata));
}
void RemoteFrameInterceptorForTesting::SetFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->SetFrameSinkId(std::move(frame_sink_id));
}
RemoteFrameAsyncWaiter::RemoteFrameAsyncWaiter(
    RemoteFrame* proxy) : proxy_(proxy) {}

RemoteFrameAsyncWaiter::~RemoteFrameAsyncWaiter() = default;




void LocalMainFrameInterceptorForTesting::AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) {
  GetForwardingInterface()->AnimateDoubleTapZoom(std::move(point), std::move(rect));
}
void LocalMainFrameInterceptorForTesting::SetScaleFactor(float scale) {
  GetForwardingInterface()->SetScaleFactor(std::move(scale));
}
void LocalMainFrameInterceptorForTesting::ClosePage(ClosePageCallback callback) {
  GetForwardingInterface()->ClosePage(std::move(callback));
}
void LocalMainFrameInterceptorForTesting::PluginActionAt(const ::gfx::Point& location, PluginActionType action) {
  GetForwardingInterface()->PluginActionAt(std::move(location), std::move(action));
}
void LocalMainFrameInterceptorForTesting::SetInitialFocus(bool reverse) {
  GetForwardingInterface()->SetInitialFocus(std::move(reverse));
}
void LocalMainFrameInterceptorForTesting::EnablePreferredSizeChangedMode() {
  GetForwardingInterface()->EnablePreferredSizeChangedMode();
}
void LocalMainFrameInterceptorForTesting::ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) {
  GetForwardingInterface()->ZoomToFindInPageRect(std::move(rect_in_root_frame));
}
void LocalMainFrameInterceptorForTesting::InstallCoopAccessMonitor(::network::mojom::CoopAccessReportType report_type, const ::blink::FrameToken& accessed_window, ::mojo::PendingRemote<::network::mojom::CrossOriginOpenerPolicyReporter> reporter, bool endpoint_defined, const std::string& reported_window_url) {
  GetForwardingInterface()->InstallCoopAccessMonitor(std::move(report_type), std::move(accessed_window), std::move(reporter), std::move(endpoint_defined), std::move(reported_window_url));
}
void LocalMainFrameInterceptorForTesting::OnPortalActivated(const ::blink::PortalToken& portal_token, ::mojo::PendingAssociatedRemote<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedReceiver<::blink::mojom::PortalClient> portal_client, ::blink::TransferableMessage data, uint64_t trace_id, OnPortalActivatedCallback callback) {
  GetForwardingInterface()->OnPortalActivated(std::move(portal_token), std::move(portal), std::move(portal_client), std::move(data), std::move(trace_id), std::move(callback));
}
void LocalMainFrameInterceptorForTesting::ForwardMessageFromHost(::blink::TransferableMessage message, const ::url::Origin& source_origin) {
  GetForwardingInterface()->ForwardMessageFromHost(std::move(message), std::move(source_origin));
}
void LocalMainFrameInterceptorForTesting::UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate) {
  GetForwardingInterface()->UpdateBrowserControlsState(std::move(constraints), std::move(current), std::move(animate));
}
void LocalMainFrameInterceptorForTesting::UpdateWindowControlsOverlay(const ::gfx::Rect& window_controls_overlay_rect, const ::gfx::Insets& insets) {
  GetForwardingInterface()->UpdateWindowControlsOverlay(std::move(window_controls_overlay_rect), std::move(insets));
}
LocalMainFrameAsyncWaiter::LocalMainFrameAsyncWaiter(
    LocalMainFrame* proxy) : proxy_(proxy) {}

LocalMainFrameAsyncWaiter::~LocalMainFrameAsyncWaiter() = default;

void LocalMainFrameAsyncWaiter::ClosePage(
    ) {
  base::RunLoop loop;
  proxy_->ClosePage(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void LocalMainFrameAsyncWaiter::OnPortalActivated(
    const ::blink::PortalToken& portal_token, ::mojo::PendingAssociatedRemote<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedReceiver<::blink::mojom::PortalClient> portal_client, ::blink::TransferableMessage data, uint64_t trace_id, ::blink::mojom::PortalActivateResult* out_result) {
  base::RunLoop loop;
  proxy_->OnPortalActivated(std::move(portal_token),std::move(portal),std::move(portal_client),std::move(data),std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PortalActivateResult* out_result
,
             ::blink::mojom::PortalActivateResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void RemoteMainFrameInterceptorForTesting::UpdateTextAutosizerPageInfo(TextAutosizerPageInfoPtr page_info) {
  GetForwardingInterface()->UpdateTextAutosizerPageInfo(std::move(page_info));
}
RemoteMainFrameAsyncWaiter::RemoteMainFrameAsyncWaiter(
    RemoteMainFrame* proxy) : proxy_(proxy) {}

RemoteMainFrameAsyncWaiter::~RemoteMainFrameAsyncWaiter() = default;




void LocalMainFrameHostInterceptorForTesting::ScaleFactorChanged(float scale) {
  GetForwardingInterface()->ScaleFactorChanged(std::move(scale));
}
void LocalMainFrameHostInterceptorForTesting::ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) {
  GetForwardingInterface()->ContentsPreferredSizeChanged(std::move(pref_size));
}
void LocalMainFrameHostInterceptorForTesting::TextAutosizerPageInfoChanged(TextAutosizerPageInfoPtr page_info) {
  GetForwardingInterface()->TextAutosizerPageInfoChanged(std::move(page_info));
}
void LocalMainFrameHostInterceptorForTesting::FocusPage() {
  GetForwardingInterface()->FocusPage();
}
void LocalMainFrameHostInterceptorForTesting::TakeFocus(bool reverse) {
  GetForwardingInterface()->TakeFocus(std::move(reverse));
}
void LocalMainFrameHostInterceptorForTesting::UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) {
  GetForwardingInterface()->UpdateTargetURL(std::move(url), std::move(callback));
}
void LocalMainFrameHostInterceptorForTesting::RequestClose() {
  GetForwardingInterface()->RequestClose();
}
void LocalMainFrameHostInterceptorForTesting::ShowCreatedWindow(const ::blink::LocalFrameToken& opener_frame_token, ::WindowOpenDisposition disposition, const ::gfx::Rect& rect, bool opened_by_user_gesture, ShowCreatedWindowCallback callback) {
  GetForwardingInterface()->ShowCreatedWindow(std::move(opener_frame_token), std::move(disposition), std::move(rect), std::move(opened_by_user_gesture), std::move(callback));
}
void LocalMainFrameHostInterceptorForTesting::SetWindowRect(const ::gfx::Rect& bounds, SetWindowRectCallback callback) {
  GetForwardingInterface()->SetWindowRect(std::move(bounds), std::move(callback));
}
LocalMainFrameHostAsyncWaiter::LocalMainFrameHostAsyncWaiter(
    LocalMainFrameHost* proxy) : proxy_(proxy) {}

LocalMainFrameHostAsyncWaiter::~LocalMainFrameHostAsyncWaiter() = default;

void LocalMainFrameHostAsyncWaiter::UpdateTargetURL(
    const ::GURL& url) {
  base::RunLoop loop;
  proxy_->UpdateTargetURL(std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void LocalMainFrameHostAsyncWaiter::ShowCreatedWindow(
    const ::blink::LocalFrameToken& opener_frame_token, ::WindowOpenDisposition disposition, const ::gfx::Rect& rect, bool opened_by_user_gesture) {
  base::RunLoop loop;
  proxy_->ShowCreatedWindow(std::move(opener_frame_token),std::move(disposition),std::move(rect),std::move(opened_by_user_gesture),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void LocalMainFrameHostAsyncWaiter::SetWindowRect(
    const ::gfx::Rect& bounds) {
  base::RunLoop loop;
  proxy_->SetWindowRect(std::move(bounds),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void RemoteMainFrameHostInterceptorForTesting::FocusPage() {
  GetForwardingInterface()->FocusPage();
}
void RemoteMainFrameHostInterceptorForTesting::TakeFocus(bool reverse) {
  GetForwardingInterface()->TakeFocus(std::move(reverse));
}
void RemoteMainFrameHostInterceptorForTesting::UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) {
  GetForwardingInterface()->UpdateTargetURL(std::move(url), std::move(callback));
}
void RemoteMainFrameHostInterceptorForTesting::RouteCloseEvent() {
  GetForwardingInterface()->RouteCloseEvent();
}
RemoteMainFrameHostAsyncWaiter::RemoteMainFrameHostAsyncWaiter(
    RemoteMainFrameHost* proxy) : proxy_(proxy) {}

RemoteMainFrameHostAsyncWaiter::~RemoteMainFrameHostAsyncWaiter() = default;

void RemoteMainFrameHostAsyncWaiter::UpdateTargetURL(
    const ::GURL& url) {
  base::RunLoop loop;
  proxy_->UpdateTargetURL(std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif