// third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool FrameOwnerProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameOwnerProperties_Data* object = static_cast<const FrameOwnerProperties_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ScrollbarMode_Data
        ::Validate(object->scrollbar_mode, validation_context))
    return false;


  if (!::blink::mojom::internal::ColorScheme_Data
        ::Validate(object->color_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->required_csp, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams required_csp_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->required_csp, validation_context,
                                         &required_csp_validate_params)) {
    return false;
  }

  return true;
}

FrameOwnerProperties_Data::FrameOwnerProperties_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
