// third_party/blink/public/mojom/frame/frame_policy.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/frame_policy.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/frame_policy.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_JUMBO_H_
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
FramePolicy::FramePolicy()
    : sandbox_flags(),
      container_policy(),
      required_document_policy(),
      disallow_document_access(false) {}

FramePolicy::FramePolicy(
    ::network::mojom::WebSandboxFlags sandbox_flags_in,
    std::vector<::blink::ParsedFeaturePolicyDeclaration> container_policy_in,
    const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& required_document_policy_in,
    bool disallow_document_access_in)
    : sandbox_flags(std::move(sandbox_flags_in)),
      container_policy(std::move(container_policy_in)),
      required_document_policy(std::move(required_document_policy_in)),
      disallow_document_access(std::move(disallow_document_access_in)) {}

FramePolicy::~FramePolicy() = default;

void FramePolicy::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandbox_flags"), this->sandbox_flags, 
      "<value of type ::network::mojom::WebSandboxFlags>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "container_policy"), this->container_policy, 
      "<value of type const std::vector<::blink::ParsedFeaturePolicyDeclaration>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_document_policy"), this->required_document_policy, 
      "<value of type const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disallow_document_access"), this->disallow_document_access, 
      "<value of type bool>");
}

bool FramePolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FramePolicy::DataView, ::blink::mojom::FramePolicyPtr>::Read(
    ::blink::mojom::FramePolicy::DataView input,
    ::blink::mojom::FramePolicyPtr* output) {
  bool success = true;
  ::blink::mojom::FramePolicyPtr result(::blink::mojom::FramePolicy::New());
  
      if (success && !input.ReadSandboxFlags(&result->sandbox_flags))
        success = false;
      if (success && !input.ReadContainerPolicy(&result->container_policy))
        success = false;
      if (success && !input.ReadRequiredDocumentPolicy(&result->required_document_policy))
        success = false;
      if (success)
        result->disallow_document_access = input.disallow_document_access();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif