// third_party/blink/public/mojom/frame/frame_visual_properties.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
FrameVisualProperties::FrameVisualProperties()
    : screen_info(),
      auto_resize_enabled(),
      is_pinch_gesture_active(),
      capture_sequence_number(),
      zoom_level(),
      page_scale_factor(1),
      compositing_scale_factor(1),
      visible_viewport_size(),
      min_size_for_auto_resize(),
      max_size_for_auto_resize(),
      root_widget_window_segments(),
      compositor_viewport(),
      screen_space_rect(),
      local_frame_size(),
      local_surface_id() {}

FrameVisualProperties::FrameVisualProperties(
    const ::blink::ScreenInfo& screen_info_in,
    bool auto_resize_enabled_in,
    bool is_pinch_gesture_active_in,
    uint32_t capture_sequence_number_in,
    double zoom_level_in,
    float page_scale_factor_in,
    float compositing_scale_factor_in,
    const ::gfx::Size& visible_viewport_size_in,
    const ::gfx::Size& min_size_for_auto_resize_in,
    const ::gfx::Size& max_size_for_auto_resize_in,
    WTF::Vector<::gfx::Rect> root_widget_window_segments_in,
    const ::gfx::Rect& compositor_viewport_in,
    const ::gfx::Rect& screen_space_rect_in,
    const ::gfx::Size& local_frame_size_in,
    const ::viz::LocalSurfaceId& local_surface_id_in)
    : screen_info(std::move(screen_info_in)),
      auto_resize_enabled(std::move(auto_resize_enabled_in)),
      is_pinch_gesture_active(std::move(is_pinch_gesture_active_in)),
      capture_sequence_number(std::move(capture_sequence_number_in)),
      zoom_level(std::move(zoom_level_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      compositing_scale_factor(std::move(compositing_scale_factor_in)),
      visible_viewport_size(std::move(visible_viewport_size_in)),
      min_size_for_auto_resize(std::move(min_size_for_auto_resize_in)),
      max_size_for_auto_resize(std::move(max_size_for_auto_resize_in)),
      root_widget_window_segments(std::move(root_widget_window_segments_in)),
      compositor_viewport(std::move(compositor_viewport_in)),
      screen_space_rect(std::move(screen_space_rect_in)),
      local_frame_size(std::move(local_frame_size_in)),
      local_surface_id(std::move(local_surface_id_in)) {}

FrameVisualProperties::~FrameVisualProperties() = default;

void FrameVisualProperties::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_info"), this->screen_info, 
      "<value of type const ::blink::ScreenInfo&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_resize_enabled"), this->auto_resize_enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_pinch_gesture_active"), this->is_pinch_gesture_active, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_sequence_number"), this->capture_sequence_number, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zoom_level"), this->zoom_level, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compositing_scale_factor"), this->compositing_scale_factor, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_viewport_size"), this->visible_viewport_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_size_for_auto_resize"), this->min_size_for_auto_resize, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_size_for_auto_resize"), this->max_size_for_auto_resize, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_widget_window_segments"), this->root_widget_window_segments, 
      "<value of type const WTF::Vector<::gfx::Rect>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compositor_viewport"), this->compositor_viewport, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_space_rect"), this->screen_space_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_frame_size"), this->local_frame_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_surface_id"), this->local_surface_id, 
      "<value of type const ::viz::LocalSurfaceId&>");
}

bool FrameVisualProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::FrameVisualProperties::DataView, ::blink::mojom::blink::FrameVisualPropertiesPtr>::Read(
    ::blink::mojom::blink::FrameVisualProperties::DataView input,
    ::blink::mojom::blink::FrameVisualPropertiesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FrameVisualPropertiesPtr result(::blink::mojom::blink::FrameVisualProperties::New());
  
      if (success && !input.ReadScreenInfo(&result->screen_info))
        success = false;
      if (success)
        result->auto_resize_enabled = input.auto_resize_enabled();
      if (success)
        result->is_pinch_gesture_active = input.is_pinch_gesture_active();
      if (success)
        result->capture_sequence_number = input.capture_sequence_number();
      if (success)
        result->zoom_level = input.zoom_level();
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->compositing_scale_factor = input.compositing_scale_factor();
      if (success && !input.ReadVisibleViewportSize(&result->visible_viewport_size))
        success = false;
      if (success && !input.ReadMinSizeForAutoResize(&result->min_size_for_auto_resize))
        success = false;
      if (success && !input.ReadMaxSizeForAutoResize(&result->max_size_for_auto_resize))
        success = false;
      if (success && !input.ReadRootWidgetWindowSegments(&result->root_widget_window_segments))
        success = false;
      if (success && !input.ReadCompositorViewport(&result->compositor_viewport))
        success = false;
      if (success && !input.ReadScreenSpaceRect(&result->screen_space_rect))
        success = false;
      if (success && !input.ReadLocalFrameSize(&result->local_frame_size))
        success = false;
      if (success && !input.ReadLocalSurfaceId(&result->local_surface_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif