// third_party/blink/public/mojom/frame/lifecycle.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/lifecycle.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string FrameVisibilityToString(FrameVisibility value) {
  switch(value) {
    case FrameVisibility::kRenderedOutOfViewport:
      return "FrameVisibility::kRenderedOutOfViewport";
    case FrameVisibility::kRenderedInViewport:
      return "FrameVisibility::kRenderedInViewport";
    case FrameVisibility::kNotRendered:
      return "FrameVisibility::kNotRendered";
    default:
      return base::StringPrintf("Unknown FrameVisibility value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FrameVisibility value) {
  return os << FrameVisibilityToString(value);
}

std::string FrameLifecycleStateToString(FrameLifecycleState value) {
  switch(value) {
    case FrameLifecycleState::kRunning:
      return "FrameLifecycleState::kRunning";
    case FrameLifecycleState::kPaused:
      return "FrameLifecycleState::kPaused";
    case FrameLifecycleState::kFrozen:
      return "FrameLifecycleState::kFrozen";
    case FrameLifecycleState::kFrozenAutoResumeMedia:
      return "FrameLifecycleState::kFrozenAutoResumeMedia";
    default:
      return base::StringPrintf("Unknown FrameLifecycleState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FrameLifecycleState value) {
  return os << FrameLifecycleStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FrameVisibility>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::FrameVisibility value) {
  return std::move(context).WriteString(::blink::mojom::FrameVisibilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FrameLifecycleState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::FrameLifecycleState value) {
  return std::move(context).WriteString(::blink::mojom::FrameLifecycleStateToString(value));
}

} // namespace perfetto
