// third_party/blink/public/mojom/frame/policy_container.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/policy_container.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
PolicyContainerPolicies::PolicyContainerPolicies()
    : referrer_policy(::network::mojom::ReferrerPolicy::kDefault),
      ip_address_space(::network::mojom::IPAddressSpace::kUnknown) {}

PolicyContainerPolicies::PolicyContainerPolicies(
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    ::network::mojom::IPAddressSpace ip_address_space_in)
    : referrer_policy(std::move(referrer_policy_in)),
      ip_address_space(std::move(ip_address_space_in)) {}

PolicyContainerPolicies::~PolicyContainerPolicies() = default;
size_t PolicyContainerPolicies::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->referrer_policy);
  seed = mojo::internal::Hash(seed, this->ip_address_space);
  return seed;
}

void PolicyContainerPolicies::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy, 
      "<value of type ::network::mojom::ReferrerPolicy>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_address_space"), this->ip_address_space, 
      "<value of type ::network::mojom::IPAddressSpace>");
}

bool PolicyContainerPolicies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PolicyContainer::PolicyContainer()
    : policies(),
      remote() {}

PolicyContainer::PolicyContainer(
    PolicyContainerPoliciesPtr policies_in,
    ::mojo::PendingAssociatedRemote<PolicyContainerHost> remote_in)
    : policies(std::move(policies_in)),
      remote(std::move(remote_in)) {}

PolicyContainer::~PolicyContainer() = default;

void PolicyContainer::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policies"), this->policies, 
      "<value of type PolicyContainerPoliciesPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote"), this->remote, 
      "<value of type ::mojo::PendingAssociatedRemote<PolicyContainerHost>>");
}

bool PolicyContainer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PolicyContainerBindParams::PolicyContainerBindParams()
    : receiver() {}

PolicyContainerBindParams::PolicyContainerBindParams(
    ::mojo::PendingAssociatedReceiver<PolicyContainerHost> receiver_in)
    : receiver(std::move(receiver_in)) {}

PolicyContainerBindParams::~PolicyContainerBindParams() = default;

void PolicyContainerBindParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver"), this->receiver, 
      "<value of type ::mojo::PendingAssociatedReceiver<PolicyContainerHost>>");
}

bool PolicyContainerBindParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PolicyContainerHost::Name_[] = "blink.mojom.PolicyContainerHost";

PolicyContainerHostProxy::PolicyContainerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PolicyContainerHostProxy::SetReferrerPolicy(
    ::network::mojom::ReferrerPolicy in_referrer_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PolicyContainerHost::SetReferrerPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("referrer_policy"), in_referrer_policy, 
                        "<value of type ::network::mojom::ReferrerPolicy>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPolicyContainerHost_SetReferrerPolicy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PolicyContainerHost_SetReferrerPolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
      in_referrer_policy, &params->referrer_policy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PolicyContainerHost::Name_);
  message.set_method_name("SetReferrerPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PolicyContainerHostProxy::IssueKeepAliveHandle(
    ::mojo::PendingReceiver<PolicyContainerHostKeepAliveHandle> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PolicyContainerHost::IssueKeepAliveHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<PolicyContainerHostKeepAliveHandle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPolicyContainerHost_IssueKeepAliveHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PolicyContainerHost_IssueKeepAliveHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::PolicyContainerHostKeepAliveHandleInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in PolicyContainerHost.IssueKeepAliveHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PolicyContainerHost::Name_);
  message.set_method_name("IssueKeepAliveHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PolicyContainerHostStubDispatch::Accept(
    PolicyContainerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPolicyContainerHost_SetReferrerPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PolicyContainerHost::SetReferrerPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PolicyContainerHost::SetReferrerPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PolicyContainerHost_SetReferrerPolicy_Params_Data* params =
          reinterpret_cast<internal::PolicyContainerHost_SetReferrerPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::ReferrerPolicy p_referrer_policy{};
      PolicyContainerHost_SetReferrerPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReferrerPolicy(&p_referrer_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PolicyContainerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReferrerPolicy(
std::move(p_referrer_policy));
      return true;
    }
    case internal::kPolicyContainerHost_IssueKeepAliveHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PolicyContainerHost::IssueKeepAliveHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PolicyContainerHost::IssueKeepAliveHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PolicyContainerHost_IssueKeepAliveHandle_Params_Data* params =
          reinterpret_cast<internal::PolicyContainerHost_IssueKeepAliveHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<PolicyContainerHostKeepAliveHandle> p_receiver{};
      PolicyContainerHost_IssueKeepAliveHandle_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PolicyContainerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueKeepAliveHandle(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool PolicyContainerHostStubDispatch::AcceptWithResponder(
    PolicyContainerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPolicyContainerHost_SetReferrerPolicy_Name: {
      break;
    }
    case internal::kPolicyContainerHost_IssueKeepAliveHandle_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPolicyContainerHostValidationInfo[] = {
    {internal::kPolicyContainerHost_SetReferrerPolicy_Name,
     {&internal::PolicyContainerHost_SetReferrerPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPolicyContainerHost_IssueKeepAliveHandle_Name,
     {&internal::PolicyContainerHost_IssueKeepAliveHandle_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PolicyContainerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PolicyContainerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPolicyContainerHostValidationInfo);
}

const char PolicyContainerHostKeepAliveHandle::Name_[] = "blink.mojom.PolicyContainerHostKeepAliveHandle";

PolicyContainerHostKeepAliveHandleProxy::PolicyContainerHostKeepAliveHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool PolicyContainerHostKeepAliveHandleStubDispatch::Accept(
    PolicyContainerHostKeepAliveHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool PolicyContainerHostKeepAliveHandleStubDispatch::AcceptWithResponder(
    PolicyContainerHostKeepAliveHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool PolicyContainerHostKeepAliveHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PolicyContainerHostKeepAliveHandle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::PolicyContainerPolicies::DataView, ::blink::mojom::PolicyContainerPoliciesPtr>::Read(
    ::blink::mojom::PolicyContainerPolicies::DataView input,
    ::blink::mojom::PolicyContainerPoliciesPtr* output) {
  bool success = true;
  ::blink::mojom::PolicyContainerPoliciesPtr result(::blink::mojom::PolicyContainerPolicies::New());
  
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadIpAddressSpace(&result->ip_address_space))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PolicyContainer::DataView, ::blink::mojom::PolicyContainerPtr>::Read(
    ::blink::mojom::PolicyContainer::DataView input,
    ::blink::mojom::PolicyContainerPtr* output) {
  bool success = true;
  ::blink::mojom::PolicyContainerPtr result(::blink::mojom::PolicyContainer::New());
  
      if (success && !input.ReadPolicies(&result->policies))
        success = false;
      if (success) {
        result->remote =
            input.TakeRemote<decltype(result->remote)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PolicyContainerBindParams::DataView, ::blink::mojom::PolicyContainerBindParamsPtr>::Read(
    ::blink::mojom::PolicyContainerBindParams::DataView input,
    ::blink::mojom::PolicyContainerBindParamsPtr* output) {
  bool success = true;
  ::blink::mojom::PolicyContainerBindParamsPtr result(::blink::mojom::PolicyContainerBindParams::New());
  
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif