// third_party/blink/public/mojom/frame/viewport_intersection_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ViewportIntersectionState::ViewportIntersectionState()
    : viewport_intersection(),
      main_frame_intersection(),
      compositor_visible_rect(),
      occlusion_state(FrameOcclusionState::kUnknown),
      main_frame_viewport_size(),
      main_frame_scroll_offset(),
      main_frame_transform() {}

ViewportIntersectionState::ViewportIntersectionState(
    const ::gfx::Rect& viewport_intersection_in,
    const ::gfx::Rect& main_frame_intersection_in,
    const ::gfx::Rect& compositor_visible_rect_in,
    FrameOcclusionState occlusion_state_in,
    const ::gfx::Size& main_frame_viewport_size_in,
    const ::gfx::Point& main_frame_scroll_offset_in,
    const ::gfx::Transform& main_frame_transform_in)
    : viewport_intersection(std::move(viewport_intersection_in)),
      main_frame_intersection(std::move(main_frame_intersection_in)),
      compositor_visible_rect(std::move(compositor_visible_rect_in)),
      occlusion_state(std::move(occlusion_state_in)),
      main_frame_viewport_size(std::move(main_frame_viewport_size_in)),
      main_frame_scroll_offset(std::move(main_frame_scroll_offset_in)),
      main_frame_transform(std::move(main_frame_transform_in)) {}

ViewportIntersectionState::~ViewportIntersectionState() = default;

void ViewportIntersectionState::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_intersection"), this->viewport_intersection, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_intersection"), this->main_frame_intersection, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compositor_visible_rect"), this->compositor_visible_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "occlusion_state"), this->occlusion_state, 
      "<value of type FrameOcclusionState>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_viewport_size"), this->main_frame_viewport_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_scroll_offset"), this->main_frame_scroll_offset, 
      "<value of type const ::gfx::Point&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_transform"), this->main_frame_transform, 
      "<value of type const ::gfx::Transform&>");
}

bool ViewportIntersectionState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ViewportIntersectionState::DataView, ::blink::mojom::ViewportIntersectionStatePtr>::Read(
    ::blink::mojom::ViewportIntersectionState::DataView input,
    ::blink::mojom::ViewportIntersectionStatePtr* output) {
  bool success = true;
  ::blink::mojom::ViewportIntersectionStatePtr result(::blink::mojom::ViewportIntersectionState::New());
  
      if (success && !input.ReadViewportIntersection(&result->viewport_intersection))
        success = false;
      if (success && !input.ReadMainFrameIntersection(&result->main_frame_intersection))
        success = false;
      if (success && !input.ReadCompositorVisibleRect(&result->compositor_visible_rect))
        success = false;
      if (success && !input.ReadOcclusionState(&result->occlusion_state))
        success = false;
      if (success && !input.ReadMainFrameViewportSize(&result->main_frame_viewport_size))
        success = false;
      if (success && !input.ReadMainFrameScrollOffset(&result->main_frame_scroll_offset))
        success = false;
      if (success && !input.ReadMainFrameTransform(&result->main_frame_transform))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif