// third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_SINKS_EMBEDDED_FRAME_SINK_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_SINKS_EMBEDDED_FRAME_SINK_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char SurfaceEmbedder::Name_[] = "blink.mojom.SurfaceEmbedder";

SurfaceEmbedderProxy::SurfaceEmbedderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SurfaceEmbedderProxy::SetLocalSurfaceId(
    const ::viz::LocalSurfaceId& in_local_surface_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SurfaceEmbedder::SetLocalSurfaceId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id, 
                        "<value of type const ::viz::LocalSurfaceId&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSurfaceEmbedder_SetLocalSurfaceId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in SurfaceEmbedder.SetLocalSurfaceId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SurfaceEmbedder::Name_);
  message.set_method_name("SetLocalSurfaceId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SurfaceEmbedderStubDispatch::Accept(
    SurfaceEmbedder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSurfaceEmbedder_SetLocalSurfaceId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SurfaceEmbedder::SetLocalSurfaceId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SurfaceEmbedder::SetLocalSurfaceId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data* params =
          reinterpret_cast<internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      SurfaceEmbedder_SetLocalSurfaceId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SurfaceEmbedder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLocalSurfaceId(
std::move(p_local_surface_id));
      return true;
    }
  }
  return false;
}

// static
bool SurfaceEmbedderStubDispatch::AcceptWithResponder(
    SurfaceEmbedder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSurfaceEmbedder_SetLocalSurfaceId_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSurfaceEmbedderValidationInfo[] = {
    {internal::kSurfaceEmbedder_SetLocalSurfaceId_Name,
     {&internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SurfaceEmbedderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::SurfaceEmbedder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSurfaceEmbedderValidationInfo);
}

const char EmbeddedFrameSinkClient::Name_[] = "blink.mojom.EmbeddedFrameSinkClient";

EmbeddedFrameSinkClientProxy::EmbeddedFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedFrameSinkClientProxy::BindSurfaceEmbedder(
    ::mojo::PendingReceiver<SurfaceEmbedder> in_embedder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedFrameSinkClient::BindSurfaceEmbedder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder"), in_embedder, 
                        "<value of type ::mojo::PendingReceiver<SurfaceEmbedder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedFrameSinkClient_BindSurfaceEmbedder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SurfaceEmbedderInterfaceBase>>(
      in_embedder, &params->embedder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->embedder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid embedder in EmbeddedFrameSinkClient.BindSurfaceEmbedder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkClient::Name_);
  message.set_method_name("BindSurfaceEmbedder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool EmbeddedFrameSinkClientStubDispatch::Accept(
    EmbeddedFrameSinkClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kEmbeddedFrameSinkClient_BindSurfaceEmbedder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedFrameSinkClient::BindSurfaceEmbedder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedFrameSinkClient::BindSurfaceEmbedder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<SurfaceEmbedder> p_embedder{};
      EmbeddedFrameSinkClient_BindSurfaceEmbedder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_embedder =
            input_data_view.TakeEmbedder<decltype(p_embedder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSurfaceEmbedder(
std::move(p_embedder));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedFrameSinkClientStubDispatch::AcceptWithResponder(
    EmbeddedFrameSinkClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kEmbeddedFrameSinkClient_BindSurfaceEmbedder_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kEmbeddedFrameSinkClientValidationInfo[] = {
    {internal::kEmbeddedFrameSinkClient_BindSurfaceEmbedder_Name,
     {&internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data::Validate,
      nullptr /* no response */}},
};

bool EmbeddedFrameSinkClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::EmbeddedFrameSinkClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kEmbeddedFrameSinkClientValidationInfo);
}

const char EmbeddedFrameSinkProvider::Name_[] = "blink.mojom.EmbeddedFrameSinkProvider";

EmbeddedFrameSinkProviderProxy::EmbeddedFrameSinkProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedFrameSinkProviderProxy::RegisterEmbeddedFrameSink(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_sink_id"), in_parent_frame_sink_id, 
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id, 
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<EmbeddedFrameSinkClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_sink_id)::BaseType> parent_frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_parent_frame_sink_id, parent_frame_sink_id_fragment);
  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_fragment.is_null() ? nullptr : parent_frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parent_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_frame_sink_id in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSink request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, frame_sink_id_fragment);
  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSink request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::EmbeddedFrameSinkClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("RegisterEmbeddedFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedFrameSinkProviderProxy::CreateCompositorFrameSink(
    const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient> in_client, ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink> in_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedFrameSinkProvider::CreateCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id, 
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink"), in_sink, 
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedFrameSinkProvider_CreateCompositorFrameSink_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, frame_sink_id_fragment);
  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in EmbeddedFrameSinkProvider.CreateCompositorFrameSink request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in EmbeddedFrameSinkProvider.CreateCompositorFrameSink request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
      in_sink, &params->sink, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->sink),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid sink in EmbeddedFrameSinkProvider.CreateCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("CreateCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedFrameSinkProviderProxy::CreateSimpleCompositorFrameSink(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> in_surface_client, ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient> in_client, ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink> in_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_sink_id"), in_parent_frame_sink_id, 
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id, 
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_client"), in_surface_client, 
                        "<value of type ::mojo::PendingRemote<EmbeddedFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink"), in_sink, 
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_sink_id)::BaseType> parent_frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_parent_frame_sink_id, parent_frame_sink_id_fragment);
  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_fragment.is_null() ? nullptr : parent_frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parent_frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_frame_sink_id in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, frame_sink_id_fragment);
  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::EmbeddedFrameSinkClientInterfaceBase>>(
      in_surface_client, &params->surface_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->surface_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid surface_client in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
      in_sink, &params->sink, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->sink),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid sink in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("CreateSimpleCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void EmbeddedFrameSinkProviderProxy::ConnectToEmbedder(
    const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingReceiver<SurfaceEmbedder> in_embedder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::EmbeddedFrameSinkProvider::ConnectToEmbedder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id, 
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder"), in_embedder, 
                        "<value of type ::mojo::PendingReceiver<SurfaceEmbedder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kEmbeddedFrameSinkProvider_ConnectToEmbedder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, frame_sink_id_fragment);
  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in EmbeddedFrameSinkProvider.ConnectToEmbedder request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SurfaceEmbedderInterfaceBase>>(
      in_embedder, &params->embedder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->embedder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid embedder in EmbeddedFrameSinkProvider.ConnectToEmbedder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("ConnectToEmbedder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool EmbeddedFrameSinkProviderStubDispatch::Accept(
    EmbeddedFrameSinkProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kEmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingRemote<EmbeddedFrameSinkClient> p_client{};
      EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterEmbeddedFrameSink(
std::move(p_parent_frame_sink_id), 
std::move(p_frame_sink_id), 
std::move(p_client));
      return true;
    }
    case internal::kEmbeddedFrameSinkProvider_CreateCompositorFrameSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedFrameSinkProvider::CreateCompositorFrameSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedFrameSinkProvider::CreateCompositorFrameSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient> p_client{};
      ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink> p_sink{};
      EmbeddedFrameSinkProvider_CreateCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_sink =
            input_data_view.TakeSink<decltype(p_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCompositorFrameSink(
std::move(p_frame_sink_id), 
std::move(p_client), 
std::move(p_sink));
      return true;
    }
    case internal::kEmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingRemote<EmbeddedFrameSinkClient> p_surface_client{};
      ::mojo::PendingRemote<::viz::mojom::blink::CompositorFrameSinkClient> p_client{};
      ::mojo::PendingReceiver<::viz::mojom::blink::CompositorFrameSink> p_sink{};
      EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_surface_client =
            input_data_view.TakeSurfaceClient<decltype(p_surface_client)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_sink =
            input_data_view.TakeSink<decltype(p_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSimpleCompositorFrameSink(
std::move(p_parent_frame_sink_id), 
std::move(p_frame_sink_id), 
std::move(p_surface_client), 
std::move(p_client), 
std::move(p_sink));
      return true;
    }
    case internal::kEmbeddedFrameSinkProvider_ConnectToEmbedder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EmbeddedFrameSinkProvider::ConnectToEmbedder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EmbeddedFrameSinkProvider::ConnectToEmbedder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingReceiver<SurfaceEmbedder> p_embedder{};
      EmbeddedFrameSinkProvider_ConnectToEmbedder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_embedder =
            input_data_view.TakeEmbedder<decltype(p_embedder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToEmbedder(
std::move(p_frame_sink_id), 
std::move(p_embedder));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedFrameSinkProviderStubDispatch::AcceptWithResponder(
    EmbeddedFrameSinkProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kEmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Name: {
      break;
    }
    case internal::kEmbeddedFrameSinkProvider_CreateCompositorFrameSink_Name: {
      break;
    }
    case internal::kEmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Name: {
      break;
    }
    case internal::kEmbeddedFrameSinkProvider_ConnectToEmbedder_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kEmbeddedFrameSinkProviderValidationInfo[] = {
    {internal::kEmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Name,
     {&internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedFrameSinkProvider_CreateCompositorFrameSink_Name,
     {&internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Name,
     {&internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kEmbeddedFrameSinkProvider_ConnectToEmbedder_Name,
     {&internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data::Validate,
      nullptr /* no response */}},
};

bool EmbeddedFrameSinkProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::EmbeddedFrameSinkProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kEmbeddedFrameSinkProviderValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif