// third_party/blink/public/mojom/geolocation/geolocation_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/geolocation/geolocation_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/geolocation/geolocation_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/geolocation/geolocation_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/geolocation/geolocation_service.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_GEOLOCATION_GEOLOCATION_SERVICE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_GEOLOCATION_GEOLOCATION_SERVICE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char GeolocationService::Name_[] = "blink.mojom.GeolocationService";

class GeolocationService_CreateGeolocation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GeolocationService_CreateGeolocation_ForwardToCallback(
      GeolocationService::CreateGeolocationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GeolocationService::CreateGeolocationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GeolocationService_CreateGeolocation_ForwardToCallback);
};

GeolocationServiceProxy::GeolocationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GeolocationServiceProxy::CreateGeolocation(
    ::mojo::PendingReceiver<::device::mojom::blink::Geolocation> in_receiver, bool in_user_gesture, CreateGeolocationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::GeolocationService::CreateGeolocation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::Geolocation>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGeolocationService_CreateGeolocation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::GeolocationService_CreateGeolocation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in GeolocationService.CreateGeolocation request");
  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationService::Name_);
  message.set_method_name("CreateGeolocation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GeolocationService_CreateGeolocation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GeolocationService_CreateGeolocation_ProxyToResponder {
 public:
  static GeolocationService::CreateGeolocationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GeolocationService_CreateGeolocation_ProxyToResponder> proxy(
        new GeolocationService_CreateGeolocation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GeolocationService_CreateGeolocation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GeolocationService_CreateGeolocation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GeolocationService_CreateGeolocation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GeolocationService::CreateGeolocationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GeolocationService_CreateGeolocation_ProxyToResponder);
};

bool GeolocationService_CreateGeolocation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::GeolocationService::CreateGeolocationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GeolocationService_CreateGeolocation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GeolocationService_CreateGeolocation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::blink::PermissionStatus p_status{};
  GeolocationService_CreateGeolocation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GeolocationService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void GeolocationService_CreateGeolocation_ProxyToResponder::Run(
    ::blink::mojom::blink::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::GeolocationService::CreateGeolocationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::blink::mojom::blink::PermissionStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGeolocationService_CreateGeolocation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::GeolocationService_CreateGeolocation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::GeolocationService::CreateGeolocationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationService::Name_);
  message.set_method_name("CreateGeolocation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GeolocationServiceStubDispatch::Accept(
    GeolocationService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGeolocationService_CreateGeolocation_Name: {
      break;
    }
  }
  return false;
}

// static
bool GeolocationServiceStubDispatch::AcceptWithResponder(
    GeolocationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGeolocationService_CreateGeolocation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::GeolocationService::CreateGeolocation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::GeolocationService::CreateGeolocation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GeolocationService_CreateGeolocation_Params_Data* params =
          reinterpret_cast<
              internal::GeolocationService_CreateGeolocation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::blink::Geolocation> p_receiver{};
      bool p_user_gesture{};
      GeolocationService_CreateGeolocation_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationService::Name_, 0, false);
        return false;
      }
      GeolocationService::CreateGeolocationCallback callback =
          GeolocationService_CreateGeolocation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGeolocation(
std::move(p_receiver), 
std::move(p_user_gesture), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kGeolocationServiceValidationInfo[] = {
    {&internal::GeolocationService_CreateGeolocation_Params_Data::Validate,
     &internal::GeolocationService_CreateGeolocation_ResponseParams_Data::Validate},
};

bool GeolocationServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::GeolocationService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kGeolocationServiceValidationInfo);
}

bool GeolocationServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::GeolocationService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kGeolocationServiceValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif