// third_party/blink/public/mojom/handwriting/handwriting.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-params-data.h"
namespace handwriting {
namespace mojom {

std::string HandwritingFeatureStatusToString(HandwritingFeatureStatus value) {
  switch(value) {
    case HandwritingFeatureStatus::kNotQueried:
      return "HandwritingFeatureStatus::kNotQueried";
    case HandwritingFeatureStatus::kSupported:
      return "HandwritingFeatureStatus::kSupported";
    case HandwritingFeatureStatus::kNotSupported:
      return "HandwritingFeatureStatus::kNotSupported";
    default:
      return base::StringPrintf("Unknown HandwritingFeatureStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, HandwritingFeatureStatus value) {
  return os << HandwritingFeatureStatusToString(value);
}

std::string CreateHandwritingRecognizerResultToString(CreateHandwritingRecognizerResult value) {
  switch(value) {
    case CreateHandwritingRecognizerResult::kOk:
      return "CreateHandwritingRecognizerResult::kOk";
    case CreateHandwritingRecognizerResult::kError:
      return "CreateHandwritingRecognizerResult::kError";
    default:
      return base::StringPrintf("Unknown CreateHandwritingRecognizerResult value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CreateHandwritingRecognizerResult value) {
  return os << CreateHandwritingRecognizerResultToString(value);
}

namespace internal {


// static
bool HandwritingPoint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingPoint_Data* object = static_cast<const HandwritingPoint_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->t, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->t, validation_context))
    return false;

  return true;
}

HandwritingPoint_Data::HandwritingPoint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingStroke_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingStroke_Data* object = static_cast<const HandwritingStroke_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->points, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams points_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->points, validation_context,
                                         &points_validate_params)) {
    return false;
  }

  return true;
}

HandwritingStroke_Data::HandwritingStroke_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingDrawingSegment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingDrawingSegment_Data* object = static_cast<const HandwritingDrawingSegment_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

HandwritingDrawingSegment_Data::HandwritingDrawingSegment_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingSegment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingSegment_Data* object = static_cast<const HandwritingSegment_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->grapheme, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams grapheme_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->grapheme, validation_context,
                                         &grapheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drawing_segments, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams drawing_segments_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->drawing_segments, validation_context,
                                         &drawing_segments_validate_params)) {
    return false;
  }

  return true;
}

HandwritingSegment_Data::HandwritingSegment_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingPrediction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingPrediction_Data* object = static_cast<const HandwritingPrediction_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segmentation_result, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams segmentation_result_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->segmentation_result, validation_context,
                                         &segmentation_result_validate_params)) {
    return false;
  }

  return true;
}

HandwritingPrediction_Data::HandwritingPrediction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingHints_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingHints_Data* object = static_cast<const HandwritingHints_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recognition_type, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams recognition_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->recognition_type, validation_context,
                                         &recognition_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_type, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams input_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->input_type, validation_context,
                                         &input_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_context, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_context_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_context, validation_context,
                                         &text_context_validate_params)) {
    return false;
  }

  return true;
}

HandwritingHints_Data::HandwritingHints_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingFeatureQuery_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingFeatureQuery_Data* object = static_cast<const HandwritingFeatureQuery_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->languages, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams languages_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->languages, validation_context,
                                         &languages_validate_params)) {
    return false;
  }

  return true;
}

HandwritingFeatureQuery_Data::HandwritingFeatureQuery_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingFeatureQueryResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingFeatureQueryResult_Data* object = static_cast<const HandwritingFeatureQueryResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::handwriting::mojom::internal::HandwritingFeatureStatus_Data
        ::Validate(object->languages, validation_context))
    return false;


  if (!::handwriting::mojom::internal::HandwritingFeatureStatus_Data
        ::Validate(object->alternatives, validation_context))
    return false;


  if (!::handwriting::mojom::internal::HandwritingFeatureStatus_Data
        ::Validate(object->segmentation_result, validation_context))
    return false;

  return true;
}

HandwritingFeatureQueryResult_Data::HandwritingFeatureQueryResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingModelConstraint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingModelConstraint_Data* object = static_cast<const HandwritingModelConstraint_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->languages, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams languages_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->languages, validation_context,
                                         &languages_validate_params)) {
    return false;
  }

  return true;
}

HandwritingModelConstraint_Data::HandwritingModelConstraint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognizer_GetPrediction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingRecognizer_GetPrediction_Params_Data* object = static_cast<const HandwritingRecognizer_GetPrediction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->strokes, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams strokes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->strokes, validation_context,
                                         &strokes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hints, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hints, validation_context))
    return false;

  return true;
}

HandwritingRecognizer_GetPrediction_Params_Data::HandwritingRecognizer_GetPrediction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognizer_GetPrediction_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingRecognizer_GetPrediction_ResponseParams_Data* object = static_cast<const HandwritingRecognizer_GetPrediction_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams prediction_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->prediction, validation_context,
                                         &prediction_validate_params)) {
    return false;
  }

  return true;
}

HandwritingRecognizer_GetPrediction_ResponseParams_Data::HandwritingRecognizer_GetPrediction_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data* object = static_cast<const HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constraint, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constraint, validation_context))
    return false;

  return true;
}

HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data* object = static_cast<const HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::handwriting::mojom::internal::CreateHandwritingRecognizerResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->handwriting_recognizer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data* object = static_cast<const HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query, validation_context))
    return false;

  return true;
}

HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data* object = static_cast<const HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace handwriting

namespace perfetto {

// static
void TraceFormatTraits<::handwriting::mojom::HandwritingFeatureStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::handwriting::mojom::HandwritingFeatureStatus value) {
  return std::move(context).WriteString(::handwriting::mojom::HandwritingFeatureStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::handwriting::mojom::CreateHandwritingRecognizerResult>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::handwriting::mojom::CreateHandwritingRecognizerResult value) {
  return std::move(context).WriteString(::handwriting::mojom::CreateHandwritingRecognizerResultToString(value));
}

} // namespace perfetto
