// third_party/blink/public/mojom/handwriting/handwriting.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-params-data.h"
#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_JUMBO_H_
#endif
namespace handwriting {
namespace mojom {
HandwritingPoint::HandwritingPoint()
    : location(),
      t() {}

HandwritingPoint::HandwritingPoint(
    const ::gfx::PointF& location_in,
    ::base::TimeDelta t_in)
    : location(std::move(location_in)),
      t(std::move(t_in)) {}

HandwritingPoint::~HandwritingPoint() = default;

void HandwritingPoint::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "t"), this->t, 
      "<value of type ::base::TimeDelta>");
}

bool HandwritingPoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingStroke::HandwritingStroke()
    : points() {}

HandwritingStroke::HandwritingStroke(
    std::vector<HandwritingPointPtr> points_in)
    : points(std::move(points_in)) {}

HandwritingStroke::~HandwritingStroke() = default;

void HandwritingStroke::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "points"), this->points, 
      "<value of type std::vector<HandwritingPointPtr>>");
}

bool HandwritingStroke::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingDrawingSegment::HandwritingDrawingSegment()
    : stroke_index(),
      begin_point_index(),
      end_point_index() {}

HandwritingDrawingSegment::HandwritingDrawingSegment(
    uint32_t stroke_index_in,
    uint32_t begin_point_index_in,
    uint32_t end_point_index_in)
    : stroke_index(std::move(stroke_index_in)),
      begin_point_index(std::move(begin_point_index_in)),
      end_point_index(std::move(end_point_index_in)) {}

HandwritingDrawingSegment::~HandwritingDrawingSegment() = default;
size_t HandwritingDrawingSegment::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->stroke_index);
  seed = mojo::internal::Hash(seed, this->begin_point_index);
  seed = mojo::internal::Hash(seed, this->end_point_index);
  return seed;
}

void HandwritingDrawingSegment::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stroke_index"), this->stroke_index, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_point_index"), this->begin_point_index, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_point_index"), this->end_point_index, 
      "<value of type uint32_t>");
}

bool HandwritingDrawingSegment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingSegment::HandwritingSegment()
    : grapheme(),
      begin_index(),
      end_index(),
      drawing_segments() {}

HandwritingSegment::HandwritingSegment(
    const std::string& grapheme_in,
    uint32_t begin_index_in,
    uint32_t end_index_in,
    std::vector<HandwritingDrawingSegmentPtr> drawing_segments_in)
    : grapheme(std::move(grapheme_in)),
      begin_index(std::move(begin_index_in)),
      end_index(std::move(end_index_in)),
      drawing_segments(std::move(drawing_segments_in)) {}

HandwritingSegment::~HandwritingSegment() = default;

void HandwritingSegment::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "grapheme"), this->grapheme, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_index"), this->begin_index, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_index"), this->end_index, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "drawing_segments"), this->drawing_segments, 
      "<value of type std::vector<HandwritingDrawingSegmentPtr>>");
}

bool HandwritingSegment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingPrediction::HandwritingPrediction()
    : text(),
      segmentation_result() {}

HandwritingPrediction::HandwritingPrediction(
    const std::string& text_in,
    std::vector<HandwritingSegmentPtr> segmentation_result_in)
    : text(std::move(text_in)),
      segmentation_result(std::move(segmentation_result_in)) {}

HandwritingPrediction::~HandwritingPrediction() = default;

void HandwritingPrediction::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segmentation_result"), this->segmentation_result, 
      "<value of type std::vector<HandwritingSegmentPtr>>");
}

bool HandwritingPrediction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingHints::HandwritingHints()
    : recognition_type(),
      input_type(),
      text_context(),
      alternatives() {}

HandwritingHints::HandwritingHints(
    const std::string& recognition_type_in,
    const std::string& input_type_in,
    const std::string& text_context_in,
    uint32_t alternatives_in)
    : recognition_type(std::move(recognition_type_in)),
      input_type(std::move(input_type_in)),
      text_context(std::move(text_context_in)),
      alternatives(std::move(alternatives_in)) {}

HandwritingHints::~HandwritingHints() = default;
size_t HandwritingHints::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->recognition_type);
  seed = mojo::internal::Hash(seed, this->input_type);
  seed = mojo::internal::Hash(seed, this->text_context);
  seed = mojo::internal::Hash(seed, this->alternatives);
  return seed;
}

void HandwritingHints::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognition_type"), this->recognition_type, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_type"), this->input_type, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_context"), this->text_context, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternatives"), this->alternatives, 
      "<value of type uint32_t>");
}

bool HandwritingHints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingFeatureQuery::HandwritingFeatureQuery()
    : languages(),
      alternatives(),
      segmentation_result() {}

HandwritingFeatureQuery::HandwritingFeatureQuery(
    std::vector<std::string> languages_in,
    bool alternatives_in,
    bool segmentation_result_in)
    : languages(std::move(languages_in)),
      alternatives(std::move(alternatives_in)),
      segmentation_result(std::move(segmentation_result_in)) {}

HandwritingFeatureQuery::~HandwritingFeatureQuery() = default;

void HandwritingFeatureQuery::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "languages"), this->languages, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternatives"), this->alternatives, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segmentation_result"), this->segmentation_result, 
      "<value of type bool>");
}

bool HandwritingFeatureQuery::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingFeatureQueryResult::HandwritingFeatureQueryResult()
    : languages(HandwritingFeatureStatus::kNotQueried),
      alternatives(HandwritingFeatureStatus::kNotQueried),
      segmentation_result(HandwritingFeatureStatus::kNotQueried) {}

HandwritingFeatureQueryResult::HandwritingFeatureQueryResult(
    HandwritingFeatureStatus languages_in,
    HandwritingFeatureStatus alternatives_in,
    HandwritingFeatureStatus segmentation_result_in)
    : languages(std::move(languages_in)),
      alternatives(std::move(alternatives_in)),
      segmentation_result(std::move(segmentation_result_in)) {}

HandwritingFeatureQueryResult::~HandwritingFeatureQueryResult() = default;
size_t HandwritingFeatureQueryResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->languages);
  seed = mojo::internal::Hash(seed, this->alternatives);
  seed = mojo::internal::Hash(seed, this->segmentation_result);
  return seed;
}

void HandwritingFeatureQueryResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "languages"), this->languages, 
      "<value of type HandwritingFeatureStatus>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternatives"), this->alternatives, 
      "<value of type HandwritingFeatureStatus>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segmentation_result"), this->segmentation_result, 
      "<value of type HandwritingFeatureStatus>");
}

bool HandwritingFeatureQueryResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HandwritingModelConstraint::HandwritingModelConstraint()
    : languages() {}

HandwritingModelConstraint::HandwritingModelConstraint(
    std::vector<std::string> languages_in)
    : languages(std::move(languages_in)) {}

HandwritingModelConstraint::~HandwritingModelConstraint() = default;

void HandwritingModelConstraint::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "languages"), this->languages, 
      "<value of type const std::vector<std::string>&>");
}

bool HandwritingModelConstraint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char HandwritingRecognizer::Name_[] = "handwriting.mojom.HandwritingRecognizer";

class HandwritingRecognizer_GetPrediction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HandwritingRecognizer_GetPrediction_ForwardToCallback(
      HandwritingRecognizer::GetPredictionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HandwritingRecognizer::GetPredictionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HandwritingRecognizer_GetPrediction_ForwardToCallback);
};

HandwritingRecognizerProxy::HandwritingRecognizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HandwritingRecognizerProxy::GetPrediction(
    std::vector<HandwritingStrokePtr> in_strokes, HandwritingHintsPtr in_hints, GetPredictionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "handwriting::mojom::HandwritingRecognizer::GetPrediction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strokes"), in_strokes, 
                        "<value of type std::vector<HandwritingStrokePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hints"), in_hints, 
                        "<value of type HandwritingHintsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHandwritingRecognizer_GetPrediction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognizer_GetPrediction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->strokes)::BaseType>
      strokes_fragment(params.message());
  const mojo::internal::ContainerValidateParams strokes_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingStrokeDataView>>(
      in_strokes, strokes_fragment, &strokes_validate_params);
  params->strokes.Set(
      strokes_fragment.is_null() ? nullptr : strokes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->strokes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null strokes in HandwritingRecognizer.GetPrediction request");
  mojo::internal::MessageFragment<
      typename decltype(params->hints)::BaseType> hints_fragment(
          params.message());
  mojo::internal::Serialize<::handwriting::mojom::HandwritingHintsDataView>(
      in_hints, hints_fragment);
  params->hints.Set(
      hints_fragment.is_null() ? nullptr : hints_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hints in HandwritingRecognizer.GetPrediction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognizer::Name_);
  message.set_method_name("GetPrediction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HandwritingRecognizer_GetPrediction_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HandwritingRecognizer_GetPrediction_ProxyToResponder {
 public:
  static HandwritingRecognizer::GetPredictionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HandwritingRecognizer_GetPrediction_ProxyToResponder> proxy(
        new HandwritingRecognizer_GetPrediction_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HandwritingRecognizer_GetPrediction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HandwritingRecognizer_GetPrediction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HandwritingRecognizer_GetPrediction_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HandwritingRecognizer::GetPredictionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::Optional<std::vector<HandwritingPredictionPtr>> in_prediction);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HandwritingRecognizer_GetPrediction_ProxyToResponder);
};

bool HandwritingRecognizer_GetPrediction_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "handwriting::mojom::HandwritingRecognizer::GetPredictionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<std::vector<HandwritingPredictionPtr>> p_prediction{};
  HandwritingRecognizer_GetPrediction_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPrediction(&p_prediction))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HandwritingRecognizer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_prediction));
  return true;
}

void HandwritingRecognizer_GetPrediction_ProxyToResponder::Run(
    base::Optional<std::vector<HandwritingPredictionPtr>> in_prediction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)handwriting::mojom::HandwritingRecognizer::GetPredictionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prediction"), in_prediction, 
                        "<value of type base::Optional<std::vector<HandwritingPredictionPtr>>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHandwritingRecognizer_GetPrediction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prediction)::BaseType>
      prediction_fragment(params.message());
  const mojo::internal::ContainerValidateParams prediction_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::handwriting::mojom::HandwritingPredictionDataView>>(
      in_prediction, prediction_fragment, &prediction_validate_params);
  params->prediction.Set(
      prediction_fragment.is_null() ? nullptr : prediction_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)handwriting::mojom::HandwritingRecognizer::GetPredictionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognizer::Name_);
  message.set_method_name("GetPrediction");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HandwritingRecognizerStubDispatch::Accept(
    HandwritingRecognizer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHandwritingRecognizer_GetPrediction_Name: {
      break;
    }
  }
  return false;
}

// static
bool HandwritingRecognizerStubDispatch::AcceptWithResponder(
    HandwritingRecognizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHandwritingRecognizer_GetPrediction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)handwriting::mojom::HandwritingRecognizer::GetPrediction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)handwriting::mojom::HandwritingRecognizer::GetPrediction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HandwritingRecognizer_GetPrediction_Params_Data* params =
          reinterpret_cast<
              internal::HandwritingRecognizer_GetPrediction_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<HandwritingStrokePtr> p_strokes{};
      HandwritingHintsPtr p_hints{};
      HandwritingRecognizer_GetPrediction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStrokes(&p_strokes))
        success = false;
      if (success && !input_data_view.ReadHints(&p_hints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HandwritingRecognizer::Name_, 0, false);
        return false;
      }
      HandwritingRecognizer::GetPredictionCallback callback =
          HandwritingRecognizer_GetPrediction_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPrediction(
std::move(p_strokes), 
std::move(p_hints), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kHandwritingRecognizerValidationInfo[] = {
    {&internal::HandwritingRecognizer_GetPrediction_Params_Data::Validate,
     &internal::HandwritingRecognizer_GetPrediction_ResponseParams_Data::Validate},
};

bool HandwritingRecognizerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::handwriting::mojom::HandwritingRecognizer::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kHandwritingRecognizerValidationInfo);
}

bool HandwritingRecognizerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::handwriting::mojom::HandwritingRecognizer::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kHandwritingRecognizerValidationInfo);
}
const char HandwritingRecognitionService::Name_[] = "handwriting.mojom.HandwritingRecognitionService";

class HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback(
      HandwritingRecognitionService::CreateHandwritingRecognizerCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HandwritingRecognitionService::CreateHandwritingRecognizerCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback);
};

class HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ForwardToCallback(
      HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ForwardToCallback);
};

HandwritingRecognitionServiceProxy::HandwritingRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HandwritingRecognitionServiceProxy::CreateHandwritingRecognizer(
    HandwritingModelConstraintPtr in_constraint, CreateHandwritingRecognizerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constraint"), in_constraint, 
                        "<value of type HandwritingModelConstraintPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHandwritingRecognitionService_CreateHandwritingRecognizer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->constraint)::BaseType> constraint_fragment(
          params.message());
  mojo::internal::Serialize<::handwriting::mojom::HandwritingModelConstraintDataView>(
      in_constraint, constraint_fragment);
  params->constraint.Set(
      constraint_fragment.is_null() ? nullptr : constraint_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->constraint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null constraint in HandwritingRecognitionService.CreateHandwritingRecognizer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("CreateHandwritingRecognizer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void HandwritingRecognitionServiceProxy::QueryHandwritingRecognizerSupport(
    HandwritingFeatureQueryPtr in_query, QueryHandwritingRecognizerSupportCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizerSupport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query, 
                        "<value of type HandwritingFeatureQueryPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHandwritingRecognitionService_QueryHandwritingRecognizerSupport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  mojo::internal::Serialize<::handwriting::mojom::HandwritingFeatureQueryDataView>(
      in_query, query_fragment);
  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->query.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query in HandwritingRecognitionService.QueryHandwritingRecognizerSupport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("QueryHandwritingRecognizerSupport");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder {
 public:
  static HandwritingRecognitionService::CreateHandwritingRecognizerCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder> proxy(
        new HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HandwritingRecognitionService::CreateHandwritingRecognizerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateHandwritingRecognizerResult in_result, ::mojo::PendingRemote<HandwritingRecognizer> in_handwriting_recognizer);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder);
};

bool HandwritingRecognitionService_CreateHandwritingRecognizer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizerCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CreateHandwritingRecognizerResult p_result{};
  ::mojo::PendingRemote<HandwritingRecognizer> p_handwriting_recognizer{};
  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_handwriting_recognizer =
        input_data_view.TakeHandwritingRecognizer<decltype(p_handwriting_recognizer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HandwritingRecognitionService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_handwriting_recognizer));
  return true;
}

void HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder::Run(
    CreateHandwritingRecognizerResult in_result, ::mojo::PendingRemote<HandwritingRecognizer> in_handwriting_recognizer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizerCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type CreateHandwritingRecognizerResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handwriting_recognizer"), in_handwriting_recognizer, 
                        "<value of type ::mojo::PendingRemote<HandwritingRecognizer>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHandwritingRecognitionService_CreateHandwritingRecognizer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::handwriting::mojom::CreateHandwritingRecognizerResult>(
      in_result, &params->result);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::handwriting::mojom::HandwritingRecognizerInterfaceBase>>(
      in_handwriting_recognizer, &params->handwriting_recognizer, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizerCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("CreateHandwritingRecognizer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder {
 public:
  static HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder> proxy(
        new HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      HandwritingFeatureQueryResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder);
};

bool HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  HandwritingFeatureQueryResultPtr p_result{};
  HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HandwritingRecognitionService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder::Run(
    HandwritingFeatureQueryResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type HandwritingFeatureQueryResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHandwritingRecognitionService_QueryHandwritingRecognizerSupport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::handwriting::mojom::internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::handwriting::mojom::HandwritingFeatureQueryResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HandwritingRecognitionService::Name_);
  message.set_method_name("QueryHandwritingRecognizerSupport");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HandwritingRecognitionServiceStubDispatch::Accept(
    HandwritingRecognitionService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHandwritingRecognitionService_CreateHandwritingRecognizer_Name: {
      break;
    }
    case internal::kHandwritingRecognitionService_QueryHandwritingRecognizerSupport_Name: {
      break;
    }
  }
  return false;
}

// static
bool HandwritingRecognitionServiceStubDispatch::AcceptWithResponder(
    HandwritingRecognitionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHandwritingRecognitionService_CreateHandwritingRecognizer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)handwriting::mojom::HandwritingRecognitionService::CreateHandwritingRecognizer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data* params =
          reinterpret_cast<
              internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      HandwritingModelConstraintPtr p_constraint{};
      HandwritingRecognitionService_CreateHandwritingRecognizer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConstraint(&p_constraint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HandwritingRecognitionService::Name_, 0, false);
        return false;
      }
      HandwritingRecognitionService::CreateHandwritingRecognizerCallback callback =
          HandwritingRecognitionService_CreateHandwritingRecognizer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateHandwritingRecognizer(
std::move(p_constraint), std::move(callback));
      return true;
    }
    case internal::kHandwritingRecognitionService_QueryHandwritingRecognizerSupport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizerSupport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)handwriting::mojom::HandwritingRecognitionService::QueryHandwritingRecognizerSupport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data* params =
          reinterpret_cast<
              internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      HandwritingFeatureQueryPtr p_query{};
      HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HandwritingRecognitionService::Name_, 1, false);
        return false;
      }
      HandwritingRecognitionService::QueryHandwritingRecognizerSupportCallback callback =
          HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryHandwritingRecognizerSupport(
std::move(p_query), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kHandwritingRecognitionServiceValidationInfo[] = {
    {&internal::HandwritingRecognitionService_CreateHandwritingRecognizer_Params_Data::Validate,
     &internal::HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams_Data::Validate},
    {&internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_Params_Data::Validate,
     &internal::HandwritingRecognitionService_QueryHandwritingRecognizerSupport_ResponseParams_Data::Validate},
};

bool HandwritingRecognitionServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::handwriting::mojom::HandwritingRecognitionService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kHandwritingRecognitionServiceValidationInfo);
}

bool HandwritingRecognitionServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::handwriting::mojom::HandwritingRecognitionService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kHandwritingRecognitionServiceValidationInfo);
}
}  // namespace mojom
}  // namespace handwriting

namespace mojo {


// static
bool StructTraits<::handwriting::mojom::HandwritingPoint::DataView, ::handwriting::mojom::HandwritingPointPtr>::Read(
    ::handwriting::mojom::HandwritingPoint::DataView input,
    ::handwriting::mojom::HandwritingPointPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingPointPtr result(::handwriting::mojom::HandwritingPoint::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadT(&result->t))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingStroke::DataView, ::handwriting::mojom::HandwritingStrokePtr>::Read(
    ::handwriting::mojom::HandwritingStroke::DataView input,
    ::handwriting::mojom::HandwritingStrokePtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingStrokePtr result(::handwriting::mojom::HandwritingStroke::New());
  
      if (success && !input.ReadPoints(&result->points))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingDrawingSegment::DataView, ::handwriting::mojom::HandwritingDrawingSegmentPtr>::Read(
    ::handwriting::mojom::HandwritingDrawingSegment::DataView input,
    ::handwriting::mojom::HandwritingDrawingSegmentPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingDrawingSegmentPtr result(::handwriting::mojom::HandwritingDrawingSegment::New());
  
      if (success)
        result->stroke_index = input.stroke_index();
      if (success)
        result->begin_point_index = input.begin_point_index();
      if (success)
        result->end_point_index = input.end_point_index();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingSegment::DataView, ::handwriting::mojom::HandwritingSegmentPtr>::Read(
    ::handwriting::mojom::HandwritingSegment::DataView input,
    ::handwriting::mojom::HandwritingSegmentPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingSegmentPtr result(::handwriting::mojom::HandwritingSegment::New());
  
      if (success && !input.ReadGrapheme(&result->grapheme))
        success = false;
      if (success)
        result->begin_index = input.begin_index();
      if (success)
        result->end_index = input.end_index();
      if (success && !input.ReadDrawingSegments(&result->drawing_segments))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingPrediction::DataView, ::handwriting::mojom::HandwritingPredictionPtr>::Read(
    ::handwriting::mojom::HandwritingPrediction::DataView input,
    ::handwriting::mojom::HandwritingPredictionPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingPredictionPtr result(::handwriting::mojom::HandwritingPrediction::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadSegmentationResult(&result->segmentation_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingHints::DataView, ::handwriting::mojom::HandwritingHintsPtr>::Read(
    ::handwriting::mojom::HandwritingHints::DataView input,
    ::handwriting::mojom::HandwritingHintsPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingHintsPtr result(::handwriting::mojom::HandwritingHints::New());
  
      if (success && !input.ReadRecognitionType(&result->recognition_type))
        success = false;
      if (success && !input.ReadInputType(&result->input_type))
        success = false;
      if (success && !input.ReadTextContext(&result->text_context))
        success = false;
      if (success)
        result->alternatives = input.alternatives();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingFeatureQuery::DataView, ::handwriting::mojom::HandwritingFeatureQueryPtr>::Read(
    ::handwriting::mojom::HandwritingFeatureQuery::DataView input,
    ::handwriting::mojom::HandwritingFeatureQueryPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingFeatureQueryPtr result(::handwriting::mojom::HandwritingFeatureQuery::New());
  
      if (success && !input.ReadLanguages(&result->languages))
        success = false;
      if (success)
        result->alternatives = input.alternatives();
      if (success)
        result->segmentation_result = input.segmentation_result();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingFeatureQueryResult::DataView, ::handwriting::mojom::HandwritingFeatureQueryResultPtr>::Read(
    ::handwriting::mojom::HandwritingFeatureQueryResult::DataView input,
    ::handwriting::mojom::HandwritingFeatureQueryResultPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingFeatureQueryResultPtr result(::handwriting::mojom::HandwritingFeatureQueryResult::New());
  
      if (success && !input.ReadLanguages(&result->languages))
        success = false;
      if (success && !input.ReadAlternatives(&result->alternatives))
        success = false;
      if (success && !input.ReadSegmentationResult(&result->segmentation_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::handwriting::mojom::HandwritingModelConstraint::DataView, ::handwriting::mojom::HandwritingModelConstraintPtr>::Read(
    ::handwriting::mojom::HandwritingModelConstraint::DataView input,
    ::handwriting::mojom::HandwritingModelConstraintPtr* output) {
  bool success = true;
  ::handwriting::mojom::HandwritingModelConstraintPtr result(::handwriting::mojom::HandwritingModelConstraint::New());
  
      if (success && !input.ReadLanguages(&result->languages))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif