// third_party/blink/public/mojom/hid/hid.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/hid/hid.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-params-data.h"
#include "third_party/blink/public/mojom/hid/hid.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
VendorAndProduct::VendorAndProduct()
    : vendor(),
      product() {}

VendorAndProduct::VendorAndProduct(
    uint16_t vendor_in,
    uint16_t product_in)
    : vendor(std::move(vendor_in)),
      product(std::move(product_in)) {}

VendorAndProduct::~VendorAndProduct() = default;
size_t VendorAndProduct::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->vendor);
  seed = mojo::internal::WTFHash(seed, this->product);
  return seed;
}

void VendorAndProduct::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor"), this->vendor, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product"), this->product, 
      "<value of type uint16_t>");
}

bool VendorAndProduct::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HidDeviceFilter::HidDeviceFilter()
    : device_ids(),
      usage() {}

HidDeviceFilter::HidDeviceFilter(
    DeviceIdFilterPtr device_ids_in,
    UsageFilterPtr usage_in)
    : device_ids(std::move(device_ids_in)),
      usage(std::move(usage_in)) {}

HidDeviceFilter::~HidDeviceFilter() = default;

void HidDeviceFilter::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_ids"), this->device_ids, 
      "<value of type DeviceIdFilterPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage, 
      "<value of type UsageFilterPtr>");
}

bool HidDeviceFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceIdFilter::DeviceIdFilter() : tag_(Tag::VENDOR) {
  data_.vendor = uint16_t();
}

DeviceIdFilter::~DeviceIdFilter() {
  DestroyActive();
}


void DeviceIdFilter::set_vendor(
    uint16_t vendor) {
  if (tag_ != Tag::VENDOR) {
    DestroyActive();
    tag_ = Tag::VENDOR;
  }
  data_.vendor = vendor;
}
void DeviceIdFilter::set_vendor_and_product(
    VendorAndProductPtr vendor_and_product) {
  if (tag_ == Tag::VENDOR_AND_PRODUCT) {
    *(data_.vendor_and_product) = std::move(vendor_and_product);
  } else {
    DestroyActive();
    tag_ = Tag::VENDOR_AND_PRODUCT;
    data_.vendor_and_product = new VendorAndProductPtr(
        std::move(vendor_and_product));
  }
}

void DeviceIdFilter::DestroyActive() {
  switch (tag_) {

    case Tag::VENDOR:

      break;
    case Tag::VENDOR_AND_PRODUCT:

      delete data_.vendor_and_product;
      break;
  }
}
size_t DeviceIdFilter::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::VENDOR:
      return mojo::internal::WTFHash(seed, data_.vendor);
    case Tag::VENDOR_AND_PRODUCT:
      return mojo::internal::WTFHash(seed, data_.vendor_and_product);
    default:
      NOTREACHED();
      return seed;
  }
}

bool DeviceIdFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UsageFilter::UsageFilter() : tag_(Tag::PAGE) {
  data_.page = uint16_t();
}

UsageFilter::~UsageFilter() {
  DestroyActive();
}


void UsageFilter::set_page(
    uint16_t page) {
  if (tag_ != Tag::PAGE) {
    DestroyActive();
    tag_ = Tag::PAGE;
  }
  data_.page = page;
}
void UsageFilter::set_usage_and_page(
    ::device::mojom::blink::HidUsageAndPagePtr usage_and_page) {
  if (tag_ == Tag::USAGE_AND_PAGE) {
    *(data_.usage_and_page) = std::move(usage_and_page);
  } else {
    DestroyActive();
    tag_ = Tag::USAGE_AND_PAGE;
    data_.usage_and_page = new ::device::mojom::blink::HidUsageAndPagePtr(
        std::move(usage_and_page));
  }
}

void UsageFilter::DestroyActive() {
  switch (tag_) {

    case Tag::PAGE:

      break;
    case Tag::USAGE_AND_PAGE:

      delete data_.usage_and_page;
      break;
  }
}
size_t UsageFilter::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::PAGE:
      return mojo::internal::WTFHash(seed, data_.page);
    case Tag::USAGE_AND_PAGE:
      return mojo::internal::WTFHash(seed, data_.usage_and_page);
    default:
      NOTREACHED();
      return seed;
  }
}

bool UsageFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char HidService::Name_[] = "blink.mojom.HidService";

class HidService_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidService_GetDevices_ForwardToCallback(
      HidService::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HidService::GetDevicesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HidService_GetDevices_ForwardToCallback);
};

class HidService_RequestDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidService_RequestDevice_ForwardToCallback(
      HidService::RequestDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HidService::RequestDeviceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HidService_RequestDevice_ForwardToCallback);
};

class HidService_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidService_Connect_ForwardToCallback(
      HidService::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HidService::ConnectCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HidService_Connect_ForwardToCallback);
};

HidServiceProxy::HidServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HidServiceProxy::RegisterClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::HidManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::HidService::RegisterClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::blink::HidManagerClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHidService_RegisterClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_RegisterClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::HidManagerClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in HidService.RegisterClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("RegisterClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void HidServiceProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::HidService::GetDevices");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHidService_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidService_GetDevices_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void HidServiceProxy::RequestDevice(
    WTF::Vector<HidDeviceFilterPtr> in_filters, RequestDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::HidService::RequestDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filters"), in_filters, 
                        "<value of type WTF::Vector<HidDeviceFilterPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHidService_RequestDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_RequestDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filters)::BaseType>
      filters_fragment(params.message());
  const mojo::internal::ContainerValidateParams filters_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::HidDeviceFilterDataView>>(
      in_filters, filters_fragment, &filters_validate_params);
  params->filters.Set(
      filters_fragment.is_null() ? nullptr : filters_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filters.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filters in HidService.RequestDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("RequestDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidService_RequestDevice_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void HidServiceProxy::Connect(
    const WTF::String& in_device_guid, ::mojo::PendingRemote<::device::mojom::blink::HidConnectionClient> in_client, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::HidService::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_guid"), in_device_guid, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::HidConnectionClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHidService_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_guid)::BaseType> device_guid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_guid, device_guid_fragment);
  params->device_guid.Set(
      device_guid_fragment.is_null() ? nullptr : device_guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_guid in HidService.Connect request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::HidConnectionClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in HidService.Connect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidService_Connect_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HidService_GetDevices_ProxyToResponder {
 public:
  static HidService::GetDevicesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HidService_GetDevices_ProxyToResponder> proxy(
        new HidService_GetDevices_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HidService_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidService_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HidService_GetDevices_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HidService::GetDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr> in_devices);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HidService_GetDevices_ProxyToResponder);
};

bool HidService_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::HidService::GetDevicesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HidService_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidService_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr> p_devices{};
  HidService_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_devices));
  return true;
}

void HidService_GetDevices_ProxyToResponder::Run(
    WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::HidService::GetDevicesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices, 
                        "<value of type WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHidService_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidDeviceInfoDataView>>(
      in_devices, devices_fragment, &devices_validate_params);
  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devices in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::HidService::GetDevicesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidService_RequestDevice_ProxyToResponder {
 public:
  static HidService::RequestDeviceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HidService_RequestDevice_ProxyToResponder> proxy(
        new HidService_RequestDevice_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HidService_RequestDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidService_RequestDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HidService_RequestDevice_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HidService::RequestDeviceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr> in_devices);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HidService_RequestDevice_ProxyToResponder);
};

bool HidService_RequestDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::HidService::RequestDeviceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HidService_RequestDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidService_RequestDevice_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr> p_devices{};
  HidService_RequestDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_devices));
  return true;
}

void HidService_RequestDevice_ProxyToResponder::Run(
    WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::HidService::RequestDeviceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices, 
                        "<value of type WTF::Vector<::device::mojom::blink::HidDeviceInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHidService_RequestDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_RequestDevice_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidDeviceInfoDataView>>(
      in_devices, devices_fragment, &devices_validate_params);
  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devices in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::HidService::RequestDeviceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("RequestDevice");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidService_Connect_ProxyToResponder {
 public:
  static HidService::ConnectCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HidService_Connect_ProxyToResponder> proxy(
        new HidService_Connect_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HidService_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidService_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HidService_Connect_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HidService::ConnectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::device::mojom::blink::HidConnection> in_connection);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HidService_Connect_ProxyToResponder);
};

bool HidService_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::HidService::ConnectCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HidService_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidService_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<::device::mojom::blink::HidConnection> p_connection{};
  HidService_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_connection =
        input_data_view.TakeConnection<decltype(p_connection)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_connection));
  return true;
}

void HidService_Connect_ProxyToResponder::Run(
    ::mojo::PendingRemote<::device::mojom::blink::HidConnection> in_connection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::HidService::ConnectCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection"), in_connection, 
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::HidConnection>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHidService_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::HidService_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::HidConnectionInterfaceBase>>(
      in_connection, &params->connection, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::HidService::ConnectCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidService::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HidServiceStubDispatch::Accept(
    HidService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHidService_RegisterClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::HidService::RegisterClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::HidService::RegisterClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::HidService_RegisterClient_Params_Data* params =
          reinterpret_cast<internal::HidService_RegisterClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::blink::HidManagerClient> p_client{};
      HidService_RegisterClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterClient(
std::move(p_client));
      return true;
    }
    case internal::kHidService_GetDevices_Name: {
      break;
    }
    case internal::kHidService_RequestDevice_Name: {
      break;
    }
    case internal::kHidService_Connect_Name: {
      break;
    }
  }
  return false;
}

// static
bool HidServiceStubDispatch::AcceptWithResponder(
    HidService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHidService_RegisterClient_Name: {
      break;
    }
    case internal::kHidService_GetDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::HidService::GetDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::HidService::GetDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HidService_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::HidService_GetDevices_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      HidService_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 1, false);
        return false;
      }
      HidService::GetDevicesCallback callback =
          HidService_GetDevices_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case internal::kHidService_RequestDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::HidService::RequestDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::HidService::RequestDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HidService_RequestDevice_Params_Data* params =
          reinterpret_cast<
              internal::HidService_RequestDevice_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<HidDeviceFilterPtr> p_filters{};
      HidService_RequestDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilters(&p_filters))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 2, false);
        return false;
      }
      HidService::RequestDeviceCallback callback =
          HidService_RequestDevice_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDevice(
std::move(p_filters), std::move(callback));
      return true;
    }
    case internal::kHidService_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::HidService::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::HidService::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HidService_Connect_Params_Data* params =
          reinterpret_cast<
              internal::HidService_Connect_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_device_guid{};
      ::mojo::PendingRemote<::device::mojom::blink::HidConnectionClient> p_client{};
      HidService_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceGuid(&p_device_guid))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidService::Name_, 3, false);
        return false;
      }
      HidService::ConnectCallback callback =
          HidService_Connect_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_device_guid), 
std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kHidServiceValidationInfo[] = {
    {&internal::HidService_RegisterClient_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::HidService_GetDevices_Params_Data::Validate,
     &internal::HidService_GetDevices_ResponseParams_Data::Validate},
    {&internal::HidService_RequestDevice_Params_Data::Validate,
     &internal::HidService_RequestDevice_ResponseParams_Data::Validate},
    {&internal::HidService_Connect_Params_Data::Validate,
     &internal::HidService_Connect_ResponseParams_Data::Validate},
};

bool HidServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::HidService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kHidServiceValidationInfo);
}

bool HidServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::HidService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kHidServiceValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::VendorAndProduct::DataView, ::blink::mojom::blink::VendorAndProductPtr>::Read(
    ::blink::mojom::blink::VendorAndProduct::DataView input,
    ::blink::mojom::blink::VendorAndProductPtr* output) {
  bool success = true;
  ::blink::mojom::blink::VendorAndProductPtr result(::blink::mojom::blink::VendorAndProduct::New());
  
      if (success)
        result->vendor = input.vendor();
      if (success)
        result->product = input.product();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::HidDeviceFilter::DataView, ::blink::mojom::blink::HidDeviceFilterPtr>::Read(
    ::blink::mojom::blink::HidDeviceFilter::DataView input,
    ::blink::mojom::blink::HidDeviceFilterPtr* output) {
  bool success = true;
  ::blink::mojom::blink::HidDeviceFilterPtr result(::blink::mojom::blink::HidDeviceFilter::New());
  
      if (success && !input.ReadDeviceIds(&result->device_ids))
        success = false;
      if (success && !input.ReadUsage(&result->usage))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::DeviceIdFilter::DataView, ::blink::mojom::blink::DeviceIdFilterPtr>::Read(
    ::blink::mojom::blink::DeviceIdFilter::DataView input,
    ::blink::mojom::blink::DeviceIdFilterPtr* output) {
  using UnionType = ::blink::mojom::blink::DeviceIdFilter;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::VENDOR: {
      *output = UnionType::NewVendor(input.vendor());
      break;
    }
    case Tag::VENDOR_AND_PRODUCT: {
      ::blink::mojom::blink::VendorAndProductPtr result_vendor_and_product;
      if (!input.ReadVendorAndProduct(&result_vendor_and_product))
        return false;

      *output = UnionType::NewVendorAndProduct(
          std::move(result_vendor_and_product));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::UsageFilter::DataView, ::blink::mojom::blink::UsageFilterPtr>::Read(
    ::blink::mojom::blink::UsageFilter::DataView input,
    ::blink::mojom::blink::UsageFilterPtr* output) {
  using UnionType = ::blink::mojom::blink::UsageFilter;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::PAGE: {
      *output = UnionType::NewPage(input.page());
      break;
    }
    case Tag::USAGE_AND_PAGE: {
      ::device::mojom::blink::HidUsageAndPagePtr result_usage_and_page;
      if (!input.ReadUsageAndPage(&result_usage_and_page))
        return false;

      *output = UnionType::NewUsageAndPage(
          std::move(result_usage_and_page));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif