// third_party/blink/public/mojom/idle/idle_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/idle/idle_manager.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/idle/idle_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string UserIdleStateToString(UserIdleState value) {
  switch(value) {
    case UserIdleState::kActive:
      return "UserIdleState::kActive";
    case UserIdleState::kIdle:
      return "UserIdleState::kIdle";
    default:
      return base::StringPrintf("Unknown UserIdleState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UserIdleState value) {
  return os << UserIdleStateToString(value);
}

std::string ScreenIdleStateToString(ScreenIdleState value) {
  switch(value) {
    case ScreenIdleState::kLocked:
      return "ScreenIdleState::kLocked";
    case ScreenIdleState::kUnlocked:
      return "ScreenIdleState::kUnlocked";
    default:
      return base::StringPrintf("Unknown ScreenIdleState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ScreenIdleState value) {
  return os << ScreenIdleStateToString(value);
}

std::string IdleManagerErrorToString(IdleManagerError value) {
  switch(value) {
    case IdleManagerError::kSuccess:
      return "IdleManagerError::kSuccess";
    case IdleManagerError::kPermissionDisabled:
      return "IdleManagerError::kPermissionDisabled";
    default:
      return base::StringPrintf("Unknown IdleManagerError value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, IdleManagerError value) {
  return os << IdleManagerErrorToString(value);
}

namespace internal {


// static
bool IdleState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IdleState_Data* object = static_cast<const IdleState_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::UserIdleState_Data
        ::Validate(object->user, validation_context))
    return false;


  if (!::blink::mojom::internal::ScreenIdleState_Data
        ::Validate(object->screen, validation_context))
    return false;

  return true;
}

IdleState_Data::IdleState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdleMonitor_Update_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IdleMonitor_Update_Params_Data* object = static_cast<const IdleMonitor_Update_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

IdleMonitor_Update_Params_Data::IdleMonitor_Update_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdleManager_AddMonitor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IdleManager_AddMonitor_Params_Data* object = static_cast<const IdleManager_AddMonitor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->threshold, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->threshold, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->monitor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->monitor,
                                                 validation_context)) {
    return false;
  }

  return true;
}

IdleManager_AddMonitor_Params_Data::IdleManager_AddMonitor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IdleManager_AddMonitor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IdleManager_AddMonitor_ResponseParams_Data* object = static_cast<const IdleManager_AddMonitor_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::IdleManagerError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

IdleManager_AddMonitor_ResponseParams_Data::IdleManager_AddMonitor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::UserIdleState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::UserIdleState value) {
  return std::move(context).WriteString(::blink::mojom::UserIdleStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ScreenIdleState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ScreenIdleState value) {
  return std::move(context).WriteString(::blink::mojom::ScreenIdleStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::IdleManagerError>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::IdleManagerError value) {
  return std::move(context).WriteString(::blink::mojom::IdleManagerErrorToString(value));
}

} // namespace perfetto
