// third_party/blink/public/mojom/image_downloader/image_downloader.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-params-data.h"
#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_IMAGE_DOWNLOADER_IMAGE_DOWNLOADER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char ImageDownloader::Name_[] = "blink.mojom.ImageDownloader";

class ImageDownloader_DownloadImage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageDownloader_DownloadImage_ForwardToCallback(
      ImageDownloader::DownloadImageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ImageDownloader::DownloadImageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ImageDownloader_DownloadImage_ForwardToCallback);
};

ImageDownloaderProxy::ImageDownloaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageDownloaderProxy::DownloadImage(
    const ::GURL& in_url, bool in_is_favicon, uint32_t in_preferred_size, uint32_t in_max_bitmap_size, bool in_bypass_cache, DownloadImageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ImageDownloader::DownloadImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_favicon"), in_is_favicon, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferred_size"), in_preferred_size, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_bitmap_size"), in_max_bitmap_size, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bypass_cache"), in_bypass_cache, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImageDownloader_DownloadImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImageDownloader_DownloadImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ImageDownloader.DownloadImage request");
  params->is_favicon = in_is_favicon;
  params->preferred_size = in_preferred_size;
  params->max_bitmap_size = in_max_bitmap_size;
  params->bypass_cache = in_bypass_cache;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDownloader::Name_);
  message.set_method_name("DownloadImage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageDownloader_DownloadImage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ImageDownloader_DownloadImage_ProxyToResponder {
 public:
  static ImageDownloader::DownloadImageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ImageDownloader_DownloadImage_ProxyToResponder> proxy(
        new ImageDownloader_DownloadImage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ImageDownloader_DownloadImage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageDownloader_DownloadImage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ImageDownloader_DownloadImage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ImageDownloader::DownloadImageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_http_status_code, const std::vector<::SkBitmap>& in_images, const std::vector<::gfx::Size>& in_original_image_sizes);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ImageDownloader_DownloadImage_ProxyToResponder);
};

bool ImageDownloader_DownloadImage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ImageDownloader::DownloadImageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ImageDownloader_DownloadImage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageDownloader_DownloadImage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_http_status_code{};
  std::vector<::SkBitmap> p_images{};
  std::vector<::gfx::Size> p_original_image_sizes{};
  ImageDownloader_DownloadImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_http_status_code = input_data_view.http_status_code();
  if (success && !input_data_view.ReadImages(&p_images))
    success = false;
  if (success && !input_data_view.ReadOriginalImageSizes(&p_original_image_sizes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageDownloader::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_http_status_code), 
std::move(p_images), 
std::move(p_original_image_sizes));
  return true;
}

void ImageDownloader_DownloadImage_ProxyToResponder::Run(
    int32_t in_http_status_code, const std::vector<::SkBitmap>& in_images, const std::vector<::gfx::Size>& in_original_image_sizes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ImageDownloader::DownloadImageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_status_code"), in_http_status_code, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images"), in_images, 
                        "<value of type const std::vector<::SkBitmap>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_image_sizes"), in_original_image_sizes, 
                        "<value of type const std::vector<::gfx::Size>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kImageDownloader_DownloadImage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImageDownloader_DownloadImage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->http_status_code = in_http_status_code;
  mojo::internal::MessageFragment<
      typename decltype(params->images)::BaseType>
      images_fragment(params.message());
  const mojo::internal::ContainerValidateParams images_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>>(
      in_images, images_fragment, &images_validate_params);
  params->images.Set(
      images_fragment.is_null() ? nullptr : images_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->images.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null images in ");
  mojo::internal::MessageFragment<
      typename decltype(params->original_image_sizes)::BaseType>
      original_image_sizes_fragment(params.message());
  const mojo::internal::ContainerValidateParams original_image_sizes_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
      in_original_image_sizes, original_image_sizes_fragment, &original_image_sizes_validate_params);
  params->original_image_sizes.Set(
      original_image_sizes_fragment.is_null() ? nullptr : original_image_sizes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->original_image_sizes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null original_image_sizes in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ImageDownloader::DownloadImageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDownloader::Name_);
  message.set_method_name("DownloadImage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImageDownloaderStubDispatch::Accept(
    ImageDownloader* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kImageDownloader_DownloadImage_Name: {
      break;
    }
  }
  return false;
}

// static
bool ImageDownloaderStubDispatch::AcceptWithResponder(
    ImageDownloader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kImageDownloader_DownloadImage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ImageDownloader::DownloadImage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ImageDownloader::DownloadImage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ImageDownloader_DownloadImage_Params_Data* params =
          reinterpret_cast<
              internal::ImageDownloader_DownloadImage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      bool p_is_favicon{};
      uint32_t p_preferred_size{};
      uint32_t p_max_bitmap_size{};
      bool p_bypass_cache{};
      ImageDownloader_DownloadImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_is_favicon = input_data_view.is_favicon();
      if (success)
        p_preferred_size = input_data_view.preferred_size();
      if (success)
        p_max_bitmap_size = input_data_view.max_bitmap_size();
      if (success)
        p_bypass_cache = input_data_view.bypass_cache();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageDownloader::Name_, 0, false);
        return false;
      }
      ImageDownloader::DownloadImageCallback callback =
          ImageDownloader_DownloadImage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadImage(
std::move(p_url), 
std::move(p_is_favicon), 
std::move(p_preferred_size), 
std::move(p_max_bitmap_size), 
std::move(p_bypass_cache), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kImageDownloaderValidationInfo[] = {
    {&internal::ImageDownloader_DownloadImage_Params_Data::Validate,
     &internal::ImageDownloader_DownloadImage_ResponseParams_Data::Validate},
};

bool ImageDownloaderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ImageDownloader::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kImageDownloaderValidationInfo);
}

bool ImageDownloaderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ImageDownloader::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kImageDownloaderValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif