// third_party/blink/public/mojom/input/gesture_event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/gesture_event.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/gesture_event.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string GestureDeviceToString(GestureDevice value) {
  switch(value) {
    case GestureDevice::kUninitialized:
      return "GestureDevice::kUninitialized";
    case GestureDevice::kTouchpad:
      return "GestureDevice::kTouchpad";
    case GestureDevice::kTouchscreen:
      return "GestureDevice::kTouchscreen";
    case GestureDevice::kSyntheticAutoscroll:
      return "GestureDevice::kSyntheticAutoscroll";
    case GestureDevice::kScrollbar:
      return "GestureDevice::kScrollbar";
    default:
      return base::StringPrintf("Unknown GestureDevice value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, GestureDevice value) {
  return os << GestureDeviceToString(value);
}

std::string InertialPhaseStateToString(InertialPhaseState value) {
  switch(value) {
    case InertialPhaseState::kUnknownMomentum:
      return "InertialPhaseState::kUnknownMomentum";
    case InertialPhaseState::kNonMomentum:
      return "InertialPhaseState::kNonMomentum";
    case InertialPhaseState::kMomentum:
      return "InertialPhaseState::kMomentum";
    default:
      return base::StringPrintf("Unknown InertialPhaseState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InertialPhaseState value) {
  return os << InertialPhaseStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::GestureDevice>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::GestureDevice value) {
  return std::move(context).WriteString(::blink::mojom::GestureDeviceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InertialPhaseState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::InertialPhaseState value) {
  return std::move(context).WriteString(::blink::mojom::InertialPhaseStateToString(value));
}

} // namespace perfetto
