// third_party/blink/public/mojom/input/input_event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_event.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string ButtonToString(Button value) {
  switch(value) {
    case Button::kNoButton:
      return "Button::kNoButton";
    case Button::kLeft:
      return "Button::kLeft";
    case Button::kMiddle:
      return "Button::kMiddle";
    case Button::kRight:
      return "Button::{kRight, kBarrel}";
    case Button::kBack:
      return "Button::kBack";
    case Button::kForward:
      return "Button::kForward";
    case Button::kEraser:
      return "Button::kEraser";
    default:
      return base::StringPrintf("Unknown Button value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Button value) {
  return os << ButtonToString(value);
}

std::string DispatchTypeToString(DispatchType value) {
  switch(value) {
    case DispatchType::kBlocking:
      return "DispatchType::kBlocking";
    case DispatchType::kEventNonBlocking:
      return "DispatchType::kEventNonBlocking";
    case DispatchType::kListenersNonBlockingPassive:
      return "DispatchType::kListenersNonBlockingPassive";
    case DispatchType::kListenersForcedNonBlockingDueToFling:
      return "DispatchType::kListenersForcedNonBlockingDueToFling";
    default:
      return base::StringPrintf("Unknown DispatchType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DispatchType value) {
  return os << DispatchTypeToString(value);
}

std::string EventTypeToString(EventType value) {
  switch(value) {
    case EventType::kUndefined:
      return "EventType::{kUndefined, kTypeFirst}";
    case EventType::kMouseDown:
      return "EventType::{kMouseDown, kMouseTypeFirst}";
    case EventType::kMouseUp:
      return "EventType::kMouseUp";
    case EventType::kMouseMove:
      return "EventType::kMouseMove";
    case EventType::kMouseEnter:
      return "EventType::kMouseEnter";
    case EventType::kMouseLeave:
      return "EventType::kMouseLeave";
    case EventType::kContextMenu:
      return "EventType::{kContextMenu, kMouseTypeLast}";
    case EventType::kMouseWheel:
      return "EventType::kMouseWheel";
    case EventType::kRawKeyDown:
      return "EventType::{kRawKeyDown, kKeyboardTypeFirst}";
    case EventType::kKeyDown:
      return "EventType::kKeyDown";
    case EventType::kKeyUp:
      return "EventType::kKeyUp";
    case EventType::kChar:
      return "EventType::{kChar, kKeyboardTypeLast}";
    case EventType::kGestureScrollBegin:
      return "EventType::{kGestureScrollBegin, kGestureTypeFirst}";
    case EventType::kGestureScrollEnd:
      return "EventType::kGestureScrollEnd";
    case EventType::kGestureScrollUpdate:
      return "EventType::kGestureScrollUpdate";
    case EventType::kGestureFlingStart:
      return "EventType::kGestureFlingStart";
    case EventType::kGestureFlingCancel:
      return "EventType::kGestureFlingCancel";
    case EventType::kGesturePinchBegin:
      return "EventType::{kGesturePinchBegin, kGesturePinchTypeFirst}";
    case EventType::kGesturePinchEnd:
      return "EventType::kGesturePinchEnd";
    case EventType::kGesturePinchUpdate:
      return "EventType::{kGesturePinchUpdate, kGesturePinchTypeLast}";
    case EventType::kGestureTapDown:
      return "EventType::kGestureTapDown";
    case EventType::kGestureShowPress:
      return "EventType::kGestureShowPress";
    case EventType::kGestureTap:
      return "EventType::kGestureTap";
    case EventType::kGestureTapCancel:
      return "EventType::kGestureTapCancel";
    case EventType::kGestureLongPress:
      return "EventType::kGestureLongPress";
    case EventType::kGestureLongTap:
      return "EventType::kGestureLongTap";
    case EventType::kGestureTwoFingerTap:
      return "EventType::kGestureTwoFingerTap";
    case EventType::kGestureTapUnconfirmed:
      return "EventType::kGestureTapUnconfirmed";
    case EventType::kGestureDoubleTap:
      return "EventType::{kGestureDoubleTap, kGestureTypeLast}";
    case EventType::kTouchStart:
      return "EventType::{kTouchStart, kTouchTypeFirst}";
    case EventType::kTouchMove:
      return "EventType::kTouchMove";
    case EventType::kTouchEnd:
      return "EventType::kTouchEnd";
    case EventType::kTouchCancel:
      return "EventType::kTouchCancel";
    case EventType::kTouchScrollStarted:
      return "EventType::{kTouchScrollStarted, kTouchTypeLast}";
    case EventType::kPointerDown:
      return "EventType::{kPointerDown, kPointerTypeFirst}";
    case EventType::kPointerUp:
      return "EventType::kPointerUp";
    case EventType::kPointerMove:
      return "EventType::kPointerMove";
    case EventType::kPointerRawUpdate:
      return "EventType::kPointerRawUpdate";
    case EventType::kPointerCancel:
      return "EventType::kPointerCancel";
    case EventType::kPointerCausedUaAction:
      return "EventType::{kPointerCausedUaAction, kPointerTypeLast, kTypeLast}";
    default:
      return base::StringPrintf("Unknown EventType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, EventType value) {
  return os << EventTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Button>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::Button value) {
  return std::move(context).WriteString(::blink::mojom::ButtonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DispatchType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::DispatchType value) {
  return std::move(context).WriteString(::blink::mojom::DispatchTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EventType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::EventType value) {
  return std::move(context).WriteString(::blink::mojom::EventTypeToString(value));
}

} // namespace perfetto
