// third_party/blink/public/mojom/input/input_event_result.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_event_result.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string InputEventResultSourceToString(InputEventResultSource value) {
  switch(value) {
    case InputEventResultSource::kUnknown:
      return "InputEventResultSource::kUnknown";
    case InputEventResultSource::kCompositorThread:
      return "InputEventResultSource::kCompositorThread";
    case InputEventResultSource::kMainThread:
      return "InputEventResultSource::kMainThread";
    case InputEventResultSource::kBrowser:
      return "InputEventResultSource::kBrowser";
    default:
      return base::StringPrintf("Unknown InputEventResultSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InputEventResultSource value) {
  return os << InputEventResultSourceToString(value);
}

std::string InputEventResultStateToString(InputEventResultState value) {
  switch(value) {
    case InputEventResultState::kUnknown:
      return "InputEventResultState::kUnknown";
    case InputEventResultState::kConsumed:
      return "InputEventResultState::kConsumed";
    case InputEventResultState::kNotConsumed:
      return "InputEventResultState::kNotConsumed";
    case InputEventResultState::kNoConsumerExists:
      return "InputEventResultState::kNoConsumerExists";
    case InputEventResultState::kIgnored:
      return "InputEventResultState::kIgnored";
    case InputEventResultState::kSetNonBlocking:
      return "InputEventResultState::kSetNonBlocking";
    case InputEventResultState::kSetNonBlockingDueToFling:
      return "InputEventResultState::kSetNonBlockingDueToFling";
    default:
      return base::StringPrintf("Unknown InputEventResultState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InputEventResultState value) {
  return os << InputEventResultStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InputEventResultSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::InputEventResultSource value) {
  return std::move(context).WriteString(::blink::mojom::InputEventResultSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InputEventResultState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::InputEventResultState value) {
  return std::move(context).WriteString(::blink::mojom::InputEventResultStateToString(value));
}

} // namespace perfetto
