// third_party/blink/public/mojom/input/input_handler.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/input/input_handler.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "cc/mojom/overscroll_behavior.mojom-blink.h"
#include "cc/mojom/touch_action.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/input/gesture_event.mojom-blink.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-blink.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-blink.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-blink.h"
#include "third_party/blink/public/mojom/input/pointer_lock_result.mojom-blink.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-blink.h"
#include "third_party/blink/public/mojom/selection_menu/selection_menu_behavior.mojom-blink.h"
#include "ui/base/ime/mojom/ime_types.mojom-blink.h"
#include "ui/events/mojom/event.mojom-blink.h"
#include "ui/events/mojom/event_constants.mojom-blink.h"
#include "ui/events/mojom/scroll_granularity.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/range/mojom/range.mojom-blink.h"
#include "ui/latency/mojom/latency_info.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_BLINK_JUMBO_H_
#endif


namespace blink {
namespace mojom {
namespace blink {


void WidgetInputHandlerHostInterceptorForTesting::SetTouchActionFromMain(::cc::TouchAction touch_action) {
  GetForwardingInterface()->SetTouchActionFromMain(std::move(touch_action));
}
void WidgetInputHandlerHostInterceptorForTesting::DidOverscroll(DidOverscrollParamsPtr params) {
  GetForwardingInterface()->DidOverscroll(std::move(params));
}
void WidgetInputHandlerHostInterceptorForTesting::DidStartScrollingViewport() {
  GetForwardingInterface()->DidStartScrollingViewport();
}
void WidgetInputHandlerHostInterceptorForTesting::ImeCancelComposition() {
  GetForwardingInterface()->ImeCancelComposition();
}
void WidgetInputHandlerHostInterceptorForTesting::ImeCompositionRangeChanged(const ::gfx::Range& range, const WTF::Vector<::gfx::Rect>& bounds) {
  GetForwardingInterface()->ImeCompositionRangeChanged(std::move(range), std::move(bounds));
}
void WidgetInputHandlerHostInterceptorForTesting::SetMouseCapture(bool capture) {
  GetForwardingInterface()->SetMouseCapture(std::move(capture));
}
void WidgetInputHandlerHostInterceptorForTesting::RequestMouseLock(bool from_user_gesture, bool unadjusted_movement, RequestMouseLockCallback callback) {
  GetForwardingInterface()->RequestMouseLock(std::move(from_user_gesture), std::move(unadjusted_movement), std::move(callback));
}
WidgetInputHandlerHostAsyncWaiter::WidgetInputHandlerHostAsyncWaiter(
    WidgetInputHandlerHost* proxy) : proxy_(proxy) {}

WidgetInputHandlerHostAsyncWaiter::~WidgetInputHandlerHostAsyncWaiter() = default;

void WidgetInputHandlerHostAsyncWaiter::RequestMouseLock(
    bool from_user_gesture, bool unadjusted_movement, ::blink::mojom::blink::PointerLockResult* out_result, ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext>* out_context) {
  base::RunLoop loop;
  proxy_->RequestMouseLock(std::move(from_user_gesture),std::move(unadjusted_movement),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::PointerLockResult* out_result
,
             ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext>* out_context
,
             ::blink::mojom::blink::PointerLockResult result,
             ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext> context) {*out_result = std::move(result);*out_context = std::move(context);
            loop->Quit();
          },
          &loop,
          out_result,
          out_context));
  loop.Run();
}



void FrameWidgetInputHandlerInterceptorForTesting::AddImeTextSpansToExistingText(uint32_t start, uint32_t end, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans) {
  GetForwardingInterface()->AddImeTextSpansToExistingText(std::move(start), std::move(end), std::move(ime_text_spans));
}
void FrameWidgetInputHandlerInterceptorForTesting::ClearImeTextSpansByType(uint32_t start, uint32_t end, ::ui::ImeTextSpan::Type type) {
  GetForwardingInterface()->ClearImeTextSpansByType(std::move(start), std::move(end), std::move(type));
}
void FrameWidgetInputHandlerInterceptorForTesting::SetCompositionFromExistingText(int32_t start, int32_t end, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans) {
  GetForwardingInterface()->SetCompositionFromExistingText(std::move(start), std::move(end), std::move(ime_text_spans));
}
void FrameWidgetInputHandlerInterceptorForTesting::ExtendSelectionAndDelete(int32_t before, int32_t after) {
  GetForwardingInterface()->ExtendSelectionAndDelete(std::move(before), std::move(after));
}
void FrameWidgetInputHandlerInterceptorForTesting::DeleteSurroundingText(int32_t before, int32_t after) {
  GetForwardingInterface()->DeleteSurroundingText(std::move(before), std::move(after));
}
void FrameWidgetInputHandlerInterceptorForTesting::DeleteSurroundingTextInCodePoints(int32_t before, int32_t after) {
  GetForwardingInterface()->DeleteSurroundingTextInCodePoints(std::move(before), std::move(after));
}
void FrameWidgetInputHandlerInterceptorForTesting::SetEditableSelectionOffsets(int32_t start, int32_t end) {
  GetForwardingInterface()->SetEditableSelectionOffsets(std::move(start), std::move(end));
}
void FrameWidgetInputHandlerInterceptorForTesting::ExecuteEditCommand(const WTF::String& command, const ::WTF::String& value) {
  GetForwardingInterface()->ExecuteEditCommand(std::move(command), std::move(value));
}
void FrameWidgetInputHandlerInterceptorForTesting::Undo() {
  GetForwardingInterface()->Undo();
}
void FrameWidgetInputHandlerInterceptorForTesting::Redo() {
  GetForwardingInterface()->Redo();
}
void FrameWidgetInputHandlerInterceptorForTesting::Cut() {
  GetForwardingInterface()->Cut();
}
void FrameWidgetInputHandlerInterceptorForTesting::Copy() {
  GetForwardingInterface()->Copy();
}
void FrameWidgetInputHandlerInterceptorForTesting::CopyToFindPboard() {
  GetForwardingInterface()->CopyToFindPboard();
}
void FrameWidgetInputHandlerInterceptorForTesting::Paste() {
  GetForwardingInterface()->Paste();
}
void FrameWidgetInputHandlerInterceptorForTesting::PasteAndMatchStyle() {
  GetForwardingInterface()->PasteAndMatchStyle();
}
void FrameWidgetInputHandlerInterceptorForTesting::Delete() {
  GetForwardingInterface()->Delete();
}
void FrameWidgetInputHandlerInterceptorForTesting::SelectAll() {
  GetForwardingInterface()->SelectAll();
}
void FrameWidgetInputHandlerInterceptorForTesting::CollapseSelection() {
  GetForwardingInterface()->CollapseSelection();
}
void FrameWidgetInputHandlerInterceptorForTesting::Replace(const ::WTF::String& word) {
  GetForwardingInterface()->Replace(std::move(word));
}
void FrameWidgetInputHandlerInterceptorForTesting::ReplaceMisspelling(const ::WTF::String& word) {
  GetForwardingInterface()->ReplaceMisspelling(std::move(word));
}
void FrameWidgetInputHandlerInterceptorForTesting::SelectRange(const ::gfx::Point& base, const ::gfx::Point& extent) {
  GetForwardingInterface()->SelectRange(std::move(base), std::move(extent));
}
void FrameWidgetInputHandlerInterceptorForTesting::AdjustSelectionByCharacterOffset(int32_t start, int32_t end, ::blink::mojom::blink::SelectionMenuBehavior behavior) {
  GetForwardingInterface()->AdjustSelectionByCharacterOffset(std::move(start), std::move(end), std::move(behavior));
}
void FrameWidgetInputHandlerInterceptorForTesting::MoveRangeSelectionExtent(const ::gfx::Point& extent) {
  GetForwardingInterface()->MoveRangeSelectionExtent(std::move(extent));
}
void FrameWidgetInputHandlerInterceptorForTesting::ScrollFocusedEditableNodeIntoRect(const ::gfx::Rect& rect) {
  GetForwardingInterface()->ScrollFocusedEditableNodeIntoRect(std::move(rect));
}
void FrameWidgetInputHandlerInterceptorForTesting::MoveCaret(const ::gfx::Point& point) {
  GetForwardingInterface()->MoveCaret(std::move(point));
}
FrameWidgetInputHandlerAsyncWaiter::FrameWidgetInputHandlerAsyncWaiter(
    FrameWidgetInputHandler* proxy) : proxy_(proxy) {}

FrameWidgetInputHandlerAsyncWaiter::~FrameWidgetInputHandlerAsyncWaiter() = default;




void WidgetInputHandlerInterceptorForTesting::SetFocus(bool focused) {
  GetForwardingInterface()->SetFocus(std::move(focused));
}
void WidgetInputHandlerInterceptorForTesting::MouseCaptureLost() {
  GetForwardingInterface()->MouseCaptureLost();
}
void WidgetInputHandlerInterceptorForTesting::SetEditCommandsForNextKeyEvent(WTF::Vector<EditCommandPtr> commands) {
  GetForwardingInterface()->SetEditCommandsForNextKeyEvent(std::move(commands));
}
void WidgetInputHandlerInterceptorForTesting::CursorVisibilityChanged(bool visible) {
  GetForwardingInterface()->CursorVisibilityChanged(std::move(visible));
}
void WidgetInputHandlerInterceptorForTesting::ImeSetComposition(const ::WTF::String& text, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t start, int32_t end) {
  GetForwardingInterface()->ImeSetComposition(std::move(text), std::move(ime_text_spans), std::move(range), std::move(start), std::move(end));
}
void WidgetInputHandlerInterceptorForTesting::ImeCommitText(const ::WTF::String& text, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position, ImeCommitTextCallback callback) {
  GetForwardingInterface()->ImeCommitText(std::move(text), std::move(ime_text_spans), std::move(range), std::move(relative_cursor_position), std::move(callback));
}
void WidgetInputHandlerInterceptorForTesting::ImeFinishComposingText(bool keep_selection) {
  GetForwardingInterface()->ImeFinishComposingText(std::move(keep_selection));
}
void WidgetInputHandlerInterceptorForTesting::RequestTextInputStateUpdate() {
  GetForwardingInterface()->RequestTextInputStateUpdate();
}
void WidgetInputHandlerInterceptorForTesting::RequestCompositionUpdates(bool immediate_request, bool monitor_request) {
  GetForwardingInterface()->RequestCompositionUpdates(std::move(immediate_request), std::move(monitor_request));
}
void WidgetInputHandlerInterceptorForTesting::DispatchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, DispatchEventCallback callback) {
  GetForwardingInterface()->DispatchEvent(std::move(event), std::move(callback));
}
void WidgetInputHandlerInterceptorForTesting::DispatchNonBlockingEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->DispatchNonBlockingEvent(std::move(event));
}
void WidgetInputHandlerInterceptorForTesting::WaitForInputProcessed(WaitForInputProcessedCallback callback) {
  GetForwardingInterface()->WaitForInputProcessed(std::move(callback));
}
void WidgetInputHandlerInterceptorForTesting::GetFrameWidgetInputHandler(::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> interface_request) {
  GetForwardingInterface()->GetFrameWidgetInputHandler(std::move(interface_request));
}
WidgetInputHandlerAsyncWaiter::WidgetInputHandlerAsyncWaiter(
    WidgetInputHandler* proxy) : proxy_(proxy) {}

WidgetInputHandlerAsyncWaiter::~WidgetInputHandlerAsyncWaiter() = default;

void WidgetInputHandlerAsyncWaiter::ImeCommitText(
    const ::WTF::String& text, const WTF::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position) {
  base::RunLoop loop;
  proxy_->ImeCommitText(std::move(text),std::move(ime_text_spans),std::move(range),std::move(relative_cursor_position),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void WidgetInputHandlerAsyncWaiter::DispatchEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> event, ::blink::mojom::blink::InputEventResultSource* out_source, ::ui::LatencyInfo* out_updated_latency, ::blink::mojom::blink::InputEventResultState* out_state, DidOverscrollParamsPtr* out_overscroll, TouchActionOptionalPtr* out_touch_action) {
  base::RunLoop loop;
  proxy_->DispatchEvent(std::move(event),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::InputEventResultSource* out_source
,
             ::ui::LatencyInfo* out_updated_latency
,
             ::blink::mojom::blink::InputEventResultState* out_state
,
             DidOverscrollParamsPtr* out_overscroll
,
             TouchActionOptionalPtr* out_touch_action
,
             ::blink::mojom::blink::InputEventResultSource source,
             const ::ui::LatencyInfo& updated_latency,
             ::blink::mojom::blink::InputEventResultState state,
             DidOverscrollParamsPtr overscroll,
             TouchActionOptionalPtr touch_action) {*out_source = std::move(source);*out_updated_latency = std::move(updated_latency);*out_state = std::move(state);*out_overscroll = std::move(overscroll);*out_touch_action = std::move(touch_action);
            loop->Quit();
          },
          &loop,
          out_source,
          out_updated_latency,
          out_state,
          out_overscroll,
          out_touch_action));
  loop.Run();
}
void WidgetInputHandlerAsyncWaiter::WaitForInputProcessed(
    ) {
  base::RunLoop loop;
  proxy_->WaitForInputProcessed(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif