// third_party/blink/public/mojom/input/pointer_lock_context.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_POINTER_LOCK_CONTEXT_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_POINTER_LOCK_CONTEXT_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char PointerLockContext::Name_[] = "blink.mojom.PointerLockContext";

class PointerLockContext_RequestMouseLockChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PointerLockContext_RequestMouseLockChange_ForwardToCallback(
      PointerLockContext::RequestMouseLockChangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PointerLockContext::RequestMouseLockChangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PointerLockContext_RequestMouseLockChange_ForwardToCallback);
};

PointerLockContextProxy::PointerLockContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PointerLockContextProxy::RequestMouseLockChange(
    bool in_unadjusted_movement, RequestMouseLockChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PointerLockContext::RequestMouseLockChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unadjusted_movement"), in_unadjusted_movement, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPointerLockContext_RequestMouseLockChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PointerLockContext_RequestMouseLockChange_Params_Data> params(
          message);
  params.Allocate();
  params->unadjusted_movement = in_unadjusted_movement;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PointerLockContext::Name_);
  message.set_method_name("RequestMouseLockChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PointerLockContext_RequestMouseLockChange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PointerLockContext_RequestMouseLockChange_ProxyToResponder {
 public:
  static PointerLockContext::RequestMouseLockChangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PointerLockContext_RequestMouseLockChange_ProxyToResponder> proxy(
        new PointerLockContext_RequestMouseLockChange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PointerLockContext_RequestMouseLockChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PointerLockContext_RequestMouseLockChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PointerLockContext_RequestMouseLockChange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PointerLockContext::RequestMouseLockChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PointerLockResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PointerLockContext_RequestMouseLockChange_ProxyToResponder);
};

bool PointerLockContext_RequestMouseLockChange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PointerLockContext::RequestMouseLockChangeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::blink::PointerLockResult p_result{};
  PointerLockContext_RequestMouseLockChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PointerLockContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void PointerLockContext_RequestMouseLockChange_ProxyToResponder::Run(
    ::blink::mojom::blink::PointerLockResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PointerLockContext::RequestMouseLockChangeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::blink::mojom::blink::PointerLockResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPointerLockContext_RequestMouseLockChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PointerLockResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PointerLockContext::RequestMouseLockChangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PointerLockContext::Name_);
  message.set_method_name("RequestMouseLockChange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PointerLockContextStubDispatch::Accept(
    PointerLockContext* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPointerLockContext_RequestMouseLockChange_Name: {
      break;
    }
  }
  return false;
}

// static
bool PointerLockContextStubDispatch::AcceptWithResponder(
    PointerLockContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPointerLockContext_RequestMouseLockChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PointerLockContext::RequestMouseLockChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PointerLockContext::RequestMouseLockChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PointerLockContext_RequestMouseLockChange_Params_Data* params =
          reinterpret_cast<
              internal::PointerLockContext_RequestMouseLockChange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_unadjusted_movement{};
      PointerLockContext_RequestMouseLockChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_unadjusted_movement = input_data_view.unadjusted_movement();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PointerLockContext::Name_, 0, false);
        return false;
      }
      PointerLockContext::RequestMouseLockChangeCallback callback =
          PointerLockContext_RequestMouseLockChange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMouseLockChange(
std::move(p_unadjusted_movement), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPointerLockContextValidationInfo[] = {
    {&internal::PointerLockContext_RequestMouseLockChange_Params_Data::Validate,
     &internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data::Validate},
};

bool PointerLockContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PointerLockContext::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPointerLockContextValidationInfo);
}

bool PointerLockContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PointerLockContext::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPointerLockContextValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif