// third_party/blink/public/mojom/input/touch_event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/touch_event.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/touch_event.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string TouchStateToString(TouchState value) {
  switch(value) {
    case TouchState::kStateUndefined:
      return "TouchState::kStateUndefined";
    case TouchState::kStateReleased:
      return "TouchState::kStateReleased";
    case TouchState::kStatePressed:
      return "TouchState::kStatePressed";
    case TouchState::kStateMoved:
      return "TouchState::kStateMoved";
    case TouchState::kStateStationary:
      return "TouchState::kStateStationary";
    case TouchState::kStateCancelled:
      return "TouchState::{kStateCancelled, kStateMax}";
    default:
      return base::StringPrintf("Unknown TouchState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TouchState value) {
  return os << TouchStateToString(value);
}

namespace internal {


// static
bool TouchEventConsumers_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TouchEventConsumers_Data* object = static_cast<const TouchEventConsumers_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TouchEventConsumers_Data::TouchEventConsumers_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::TouchState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::TouchState value) {
  return std::move(context).WriteString(::blink::mojom::TouchStateToString(value));
}

} // namespace perfetto
