// third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-params-data.h"
#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LEAK_DETECTOR_LEAK_DETECTOR_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LEAK_DETECTOR_LEAK_DETECTOR_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
LeakDetectionResult::LeakDetectionResult()
    : number_of_live_audio_nodes(),
      number_of_live_documents(),
      number_of_live_nodes(),
      number_of_live_layout_objects(),
      number_of_live_resources(),
      number_of_live_context_lifecycle_state_observers(),
      number_of_live_frames(),
      number_of_live_v8_per_context_data(),
      number_of_worker_global_scopes(),
      number_of_live_ua_css_resources(),
      number_of_live_resource_fetchers() {}

LeakDetectionResult::LeakDetectionResult(
    uint32_t number_of_live_audio_nodes_in,
    uint32_t number_of_live_documents_in,
    uint32_t number_of_live_nodes_in,
    uint32_t number_of_live_layout_objects_in,
    uint32_t number_of_live_resources_in,
    uint32_t number_of_live_context_lifecycle_state_observers_in,
    uint32_t number_of_live_frames_in,
    uint32_t number_of_live_v8_per_context_data_in,
    uint32_t number_of_worker_global_scopes_in,
    uint32_t number_of_live_ua_css_resources_in,
    uint32_t number_of_live_resource_fetchers_in)
    : number_of_live_audio_nodes(std::move(number_of_live_audio_nodes_in)),
      number_of_live_documents(std::move(number_of_live_documents_in)),
      number_of_live_nodes(std::move(number_of_live_nodes_in)),
      number_of_live_layout_objects(std::move(number_of_live_layout_objects_in)),
      number_of_live_resources(std::move(number_of_live_resources_in)),
      number_of_live_context_lifecycle_state_observers(std::move(number_of_live_context_lifecycle_state_observers_in)),
      number_of_live_frames(std::move(number_of_live_frames_in)),
      number_of_live_v8_per_context_data(std::move(number_of_live_v8_per_context_data_in)),
      number_of_worker_global_scopes(std::move(number_of_worker_global_scopes_in)),
      number_of_live_ua_css_resources(std::move(number_of_live_ua_css_resources_in)),
      number_of_live_resource_fetchers(std::move(number_of_live_resource_fetchers_in)) {}

LeakDetectionResult::~LeakDetectionResult() = default;
size_t LeakDetectionResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->number_of_live_audio_nodes);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_documents);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_nodes);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_layout_objects);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_resources);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_context_lifecycle_state_observers);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_frames);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_v8_per_context_data);
  seed = mojo::internal::WTFHash(seed, this->number_of_worker_global_scopes);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_ua_css_resources);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_resource_fetchers);
  return seed;
}

void LeakDetectionResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_audio_nodes"), this->number_of_live_audio_nodes, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_documents"), this->number_of_live_documents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_nodes"), this->number_of_live_nodes, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_layout_objects"), this->number_of_live_layout_objects, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_resources"), this->number_of_live_resources, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_context_lifecycle_state_observers"), this->number_of_live_context_lifecycle_state_observers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_frames"), this->number_of_live_frames, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_v8_per_context_data"), this->number_of_live_v8_per_context_data, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_worker_global_scopes"), this->number_of_worker_global_scopes, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_ua_css_resources"), this->number_of_live_ua_css_resources, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_resource_fetchers"), this->number_of_live_resource_fetchers, 
      "<value of type uint32_t>");
}

bool LeakDetectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char LeakDetector::Name_[] = "blink.mojom.LeakDetector";

class LeakDetector_PerformLeakDetection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LeakDetector_PerformLeakDetection_ForwardToCallback(
      LeakDetector::PerformLeakDetectionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LeakDetector::PerformLeakDetectionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LeakDetector_PerformLeakDetection_ForwardToCallback);
};

LeakDetectorProxy::LeakDetectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LeakDetectorProxy::PerformLeakDetection(
    PerformLeakDetectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LeakDetector::PerformLeakDetection");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLeakDetector_PerformLeakDetection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LeakDetector_PerformLeakDetection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LeakDetector::Name_);
  message.set_method_name("PerformLeakDetection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LeakDetector_PerformLeakDetection_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LeakDetector_PerformLeakDetection_ProxyToResponder {
 public:
  static LeakDetector::PerformLeakDetectionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LeakDetector_PerformLeakDetection_ProxyToResponder> proxy(
        new LeakDetector_PerformLeakDetection_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LeakDetector_PerformLeakDetection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LeakDetector_PerformLeakDetection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LeakDetector_PerformLeakDetection_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LeakDetector::PerformLeakDetectionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      LeakDetectionResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LeakDetector_PerformLeakDetection_ProxyToResponder);
};

bool LeakDetector_PerformLeakDetection_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LeakDetector::PerformLeakDetectionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LeakDetector_PerformLeakDetection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LeakDetector_PerformLeakDetection_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  LeakDetectionResultPtr p_result{};
  LeakDetector_PerformLeakDetection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LeakDetector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void LeakDetector_PerformLeakDetection_ProxyToResponder::Run(
    LeakDetectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LeakDetector::PerformLeakDetectionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type LeakDetectionResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLeakDetector_PerformLeakDetection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LeakDetector_PerformLeakDetection_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LeakDetectionResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LeakDetector::PerformLeakDetectionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LeakDetector::Name_);
  message.set_method_name("PerformLeakDetection");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LeakDetectorStubDispatch::Accept(
    LeakDetector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLeakDetector_PerformLeakDetection_Name: {
      break;
    }
  }
  return false;
}

// static
bool LeakDetectorStubDispatch::AcceptWithResponder(
    LeakDetector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLeakDetector_PerformLeakDetection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LeakDetector::PerformLeakDetection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LeakDetector::PerformLeakDetection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LeakDetector_PerformLeakDetection_Params_Data* params =
          reinterpret_cast<
              internal::LeakDetector_PerformLeakDetection_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LeakDetector_PerformLeakDetection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LeakDetector::Name_, 0, false);
        return false;
      }
      LeakDetector::PerformLeakDetectionCallback callback =
          LeakDetector_PerformLeakDetection_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformLeakDetection(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kLeakDetectorValidationInfo[] = {
    {&internal::LeakDetector_PerformLeakDetection_Params_Data::Validate,
     &internal::LeakDetector_PerformLeakDetection_ResponseParams_Data::Validate},
};

bool LeakDetectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LeakDetector::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kLeakDetectorValidationInfo);
}

bool LeakDetectorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LeakDetector::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kLeakDetectorValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::LeakDetectionResult::DataView, ::blink::mojom::blink::LeakDetectionResultPtr>::Read(
    ::blink::mojom::blink::LeakDetectionResult::DataView input,
    ::blink::mojom::blink::LeakDetectionResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::LeakDetectionResultPtr result(::blink::mojom::blink::LeakDetectionResult::New());
  
      if (success)
        result->number_of_live_audio_nodes = input.number_of_live_audio_nodes();
      if (success)
        result->number_of_live_documents = input.number_of_live_documents();
      if (success)
        result->number_of_live_nodes = input.number_of_live_nodes();
      if (success)
        result->number_of_live_layout_objects = input.number_of_live_layout_objects();
      if (success)
        result->number_of_live_resources = input.number_of_live_resources();
      if (success)
        result->number_of_live_context_lifecycle_state_observers = input.number_of_live_context_lifecycle_state_observers();
      if (success)
        result->number_of_live_frames = input.number_of_live_frames();
      if (success)
        result->number_of_live_v8_per_context_data = input.number_of_live_v8_per_context_data();
      if (success)
        result->number_of_worker_global_scopes = input.number_of_worker_global_scopes();
      if (success)
        result->number_of_live_ua_css_resources = input.number_of_live_ua_css_resources();
      if (success)
        result->number_of_live_resource_fetchers = input.number_of_live_resource_fetchers();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif