// third_party/blink/public/mojom/loader/code_cache.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/code_cache.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/loader/code_cache.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/code_cache.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_CODE_CACHE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_CODE_CACHE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char CodeCacheHost::Name_[] = "blink.mojom.CodeCacheHost";

class CodeCacheHost_FetchCachedCode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CodeCacheHost_FetchCachedCode_ForwardToCallback(
      CodeCacheHost::FetchCachedCodeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CodeCacheHost::FetchCachedCodeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CodeCacheHost_FetchCachedCode_ForwardToCallback);
};

CodeCacheHostProxy::CodeCacheHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CodeCacheHostProxy::DidGenerateCacheableMetadata(
    CodeCacheType in_cache_type, const ::blink::KURL& in_url, ::base::Time in_expected_response_time, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CodeCacheHost::DidGenerateCacheableMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_type"), in_cache_type, 
                        "<value of type CodeCacheType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_response_time"), in_expected_response_time, 
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCodeCacheHost_DidGenerateCacheableMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::CodeCacheType>(
      in_cache_type, &params->cache_type);
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CodeCacheHost.DidGenerateCacheableMetadata request");
  mojo::internal::MessageFragment<
      typename decltype(params->expected_response_time)::BaseType> expected_response_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expected_response_time, expected_response_time_fragment);
  params->expected_response_time.Set(
      expected_response_time_fragment.is_null() ? nullptr : expected_response_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->expected_response_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expected_response_time in CodeCacheHost.DidGenerateCacheableMetadata request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in CodeCacheHost.DidGenerateCacheableMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("DidGenerateCacheableMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CodeCacheHostProxy::FetchCachedCode(
    CodeCacheType in_cache_type, const ::blink::KURL& in_url, FetchCachedCodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CodeCacheHost::FetchCachedCode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_type"), in_cache_type, 
                        "<value of type CodeCacheType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCodeCacheHost_FetchCachedCode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_FetchCachedCode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::CodeCacheType>(
      in_cache_type, &params->cache_type);
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CodeCacheHost.FetchCachedCode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("FetchCachedCode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CodeCacheHost_FetchCachedCode_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CodeCacheHostProxy::ClearCodeCacheEntry(
    CodeCacheType in_cache_type, const ::blink::KURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CodeCacheHost::ClearCodeCacheEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_type"), in_cache_type, 
                        "<value of type CodeCacheType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCodeCacheHost_ClearCodeCacheEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::CodeCacheType>(
      in_cache_type, &params->cache_type);
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CodeCacheHost.ClearCodeCacheEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("ClearCodeCacheEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CodeCacheHostProxy::DidGenerateCacheableMetadataInCacheStorage(
    const ::blink::KURL& in_url, ::base::Time in_expected_response_time, ::mojo_base::BigBuffer in_data, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_cache_storage_origin, const WTF::String& in_cache_storage_cache_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_response_time"), in_expected_response_time, 
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_storage_origin"), in_cache_storage_origin, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_storage_cache_name"), in_cache_storage_cache_name, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->expected_response_time)::BaseType> expected_response_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expected_response_time, expected_response_time_fragment);
  params->expected_response_time.Set(
      expected_response_time_fragment.is_null() ? nullptr : expected_response_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->expected_response_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expected_response_time in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->cache_storage_origin)::BaseType> cache_storage_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_cache_storage_origin, cache_storage_origin_fragment);
  params->cache_storage_origin.Set(
      cache_storage_origin_fragment.is_null() ? nullptr : cache_storage_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_storage_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_storage_origin in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->cache_storage_cache_name)::BaseType> cache_storage_cache_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_cache_storage_cache_name, cache_storage_cache_name_fragment);
  params->cache_storage_cache_name.Set(
      cache_storage_cache_name_fragment.is_null() ? nullptr : cache_storage_cache_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_storage_cache_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_storage_cache_name in CodeCacheHost.DidGenerateCacheableMetadataInCacheStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("DidGenerateCacheableMetadataInCacheStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class CodeCacheHost_FetchCachedCode_ProxyToResponder {
 public:
  static CodeCacheHost::FetchCachedCodeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CodeCacheHost_FetchCachedCode_ProxyToResponder> proxy(
        new CodeCacheHost_FetchCachedCode_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CodeCacheHost_FetchCachedCode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CodeCacheHost_FetchCachedCode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CodeCacheHost_FetchCachedCode_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CodeCacheHost::FetchCachedCodeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Time in_response_time, ::mojo_base::BigBuffer in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CodeCacheHost_FetchCachedCode_ProxyToResponder);
};

bool CodeCacheHost_FetchCachedCode_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CodeCacheHost::FetchCachedCodeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::Time p_response_time{};
  ::mojo_base::BigBuffer p_data{};
  CodeCacheHost_FetchCachedCode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponseTime(&p_response_time))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CodeCacheHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_response_time), 
std::move(p_data));
  return true;
}

void CodeCacheHost_FetchCachedCode_ProxyToResponder::Run(
    ::base::Time in_response_time, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CodeCacheHost::FetchCachedCodeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_time"), in_response_time, 
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCodeCacheHost_FetchCachedCode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response_time)::BaseType> response_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_response_time, response_time_fragment);
  params->response_time.Set(
      response_time_fragment.is_null() ? nullptr : response_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_time in ");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CodeCacheHost::FetchCachedCodeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CodeCacheHost::Name_);
  message.set_method_name("FetchCachedCode");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CodeCacheHostStubDispatch::Accept(
    CodeCacheHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCodeCacheHost_DidGenerateCacheableMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CodeCacheHost::DidGenerateCacheableMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CodeCacheHost::DidGenerateCacheableMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data* params =
          reinterpret_cast<internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CodeCacheType p_cache_type{};
      ::blink::KURL p_url{};
      ::base::Time p_expected_response_time{};
      ::mojo_base::BigBuffer p_data{};
      CodeCacheHost_DidGenerateCacheableMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheType(&p_cache_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadExpectedResponseTime(&p_expected_response_time))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGenerateCacheableMetadata(
std::move(p_cache_type), 
std::move(p_url), 
std::move(p_expected_response_time), 
std::move(p_data));
      return true;
    }
    case internal::kCodeCacheHost_FetchCachedCode_Name: {
      break;
    }
    case internal::kCodeCacheHost_ClearCodeCacheEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CodeCacheHost::ClearCodeCacheEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CodeCacheHost::ClearCodeCacheEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data* params =
          reinterpret_cast<internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CodeCacheType p_cache_type{};
      ::blink::KURL p_url{};
      CodeCacheHost_ClearCodeCacheEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheType(&p_cache_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearCodeCacheEntry(
std::move(p_cache_type), 
std::move(p_url));
      return true;
    }
    case internal::kCodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CodeCacheHost::DidGenerateCacheableMetadataInCacheStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data* params =
          reinterpret_cast<internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      ::base::Time p_expected_response_time{};
      ::mojo_base::BigBuffer p_data{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_cache_storage_origin{};
      WTF::String p_cache_storage_cache_name{};
      CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadExpectedResponseTime(&p_expected_response_time))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadCacheStorageOrigin(&p_cache_storage_origin))
        success = false;
      if (success && !input_data_view.ReadCacheStorageCacheName(&p_cache_storage_cache_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGenerateCacheableMetadataInCacheStorage(
std::move(p_url), 
std::move(p_expected_response_time), 
std::move(p_data), 
std::move(p_cache_storage_origin), 
std::move(p_cache_storage_cache_name));
      return true;
    }
  }
  return false;
}

// static
bool CodeCacheHostStubDispatch::AcceptWithResponder(
    CodeCacheHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCodeCacheHost_DidGenerateCacheableMetadata_Name: {
      break;
    }
    case internal::kCodeCacheHost_FetchCachedCode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CodeCacheHost::FetchCachedCode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CodeCacheHost::FetchCachedCode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CodeCacheHost_FetchCachedCode_Params_Data* params =
          reinterpret_cast<
              internal::CodeCacheHost_FetchCachedCode_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CodeCacheType p_cache_type{};
      ::blink::KURL p_url{};
      CodeCacheHost_FetchCachedCode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheType(&p_cache_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CodeCacheHost::Name_, 1, false);
        return false;
      }
      CodeCacheHost::FetchCachedCodeCallback callback =
          CodeCacheHost_FetchCachedCode_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchCachedCode(
std::move(p_cache_type), 
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kCodeCacheHost_ClearCodeCacheEntry_Name: {
      break;
    }
    case internal::kCodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kCodeCacheHostValidationInfo[] = {
    {&internal::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::CodeCacheHost_FetchCachedCode_Params_Data::Validate,
     &internal::CodeCacheHost_FetchCachedCode_ResponseParams_Data::Validate},
    {&internal::CodeCacheHost_ClearCodeCacheEntry_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data::Validate,
     nullptr /* no response */},
};

bool CodeCacheHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CodeCacheHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kCodeCacheHostValidationInfo);
}

bool CodeCacheHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CodeCacheHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kCodeCacheHostValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif