// third_party/blink/public/mojom/loader/code_cache.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/code_cache.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string CodeCacheTypeToString(CodeCacheType value) {
  switch(value) {
    case CodeCacheType::kJavascript:
      return "CodeCacheType::kJavascript";
    case CodeCacheType::kWebAssembly:
      return "CodeCacheType::kWebAssembly";
    default:
      return base::StringPrintf("Unknown CodeCacheType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CodeCacheType value) {
  return os << CodeCacheTypeToString(value);
}

namespace internal {


// static
bool CodeCacheHost_DidGenerateCacheableMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CodeCacheHost_DidGenerateCacheableMetadata_Params_Data* object = static_cast<const CodeCacheHost_DidGenerateCacheableMetadata_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CodeCacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_response_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expected_response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

CodeCacheHost_DidGenerateCacheableMetadata_Params_Data::CodeCacheHost_DidGenerateCacheableMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_FetchCachedCode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CodeCacheHost_FetchCachedCode_Params_Data* object = static_cast<const CodeCacheHost_FetchCachedCode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CodeCacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

CodeCacheHost_FetchCachedCode_Params_Data::CodeCacheHost_FetchCachedCode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_FetchCachedCode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CodeCacheHost_FetchCachedCode_ResponseParams_Data* object = static_cast<const CodeCacheHost_FetchCachedCode_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

CodeCacheHost_FetchCachedCode_ResponseParams_Data::CodeCacheHost_FetchCachedCode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_ClearCodeCacheEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CodeCacheHost_ClearCodeCacheEntry_Params_Data* object = static_cast<const CodeCacheHost_ClearCodeCacheEntry_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CodeCacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

CodeCacheHost_ClearCodeCacheEntry_Params_Data::CodeCacheHost_ClearCodeCacheEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data* object = static_cast<const CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_response_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expected_response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_storage_origin, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_storage_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_storage_cache_name, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cache_storage_cache_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cache_storage_cache_name, validation_context,
                                         &cache_storage_cache_name_validate_params)) {
    return false;
  }

  return true;
}

CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data::CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CodeCacheType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::CodeCacheType value) {
  return std::move(context).WriteString(::blink::mojom::CodeCacheTypeToString(value));
}

} // namespace perfetto
