// third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string InsecureRequestsPolicyToString(InsecureRequestsPolicy value) {
  switch(value) {
    case InsecureRequestsPolicy::kDoNotUpgrade:
      return "InsecureRequestsPolicy::kDoNotUpgrade";
    case InsecureRequestsPolicy::kUpgrade:
      return "InsecureRequestsPolicy::kUpgrade";
    default:
      return base::StringPrintf("Unknown InsecureRequestsPolicy value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InsecureRequestsPolicy value) {
  return os << InsecureRequestsPolicyToString(value);
}

namespace internal {


// static
bool FetchClientSettingsObject_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FetchClientSettingsObject_Data* object = static_cast<const FetchClientSettingsObject_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outgoing_referrer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outgoing_referrer, validation_context))
    return false;


  if (!::blink::mojom::internal::InsecureRequestsPolicy_Data
        ::Validate(object->insecure_requests_policy, validation_context))
    return false;

  return true;
}

FetchClientSettingsObject_Data::FetchClientSettingsObject_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InsecureRequestsPolicy>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::InsecureRequestsPolicy value) {
  return std::move(context).WriteString(::blink::mojom::InsecureRequestsPolicyToString(value));
}

} // namespace perfetto
