// third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
AnchorElementMetrics::AnchorElementMetrics()
    : ratio_area(),
      ratio_visible_area(),
      ratio_distance_top_to_visible_top(),
      ratio_distance_center_to_visible_top(),
      ratio_distance_root_top(),
      ratio_distance_root_bottom(),
      is_in_iframe(),
      contains_image(),
      is_same_host(),
      is_url_incremented_by_one(),
      source_url(),
      target_url() {}

AnchorElementMetrics::AnchorElementMetrics(
    float ratio_area_in,
    float ratio_visible_area_in,
    float ratio_distance_top_to_visible_top_in,
    float ratio_distance_center_to_visible_top_in,
    float ratio_distance_root_top_in,
    float ratio_distance_root_bottom_in,
    bool is_in_iframe_in,
    bool contains_image_in,
    bool is_same_host_in,
    bool is_url_incremented_by_one_in,
    const ::blink::KURL& source_url_in,
    const ::blink::KURL& target_url_in)
    : ratio_area(std::move(ratio_area_in)),
      ratio_visible_area(std::move(ratio_visible_area_in)),
      ratio_distance_top_to_visible_top(std::move(ratio_distance_top_to_visible_top_in)),
      ratio_distance_center_to_visible_top(std::move(ratio_distance_center_to_visible_top_in)),
      ratio_distance_root_top(std::move(ratio_distance_root_top_in)),
      ratio_distance_root_bottom(std::move(ratio_distance_root_bottom_in)),
      is_in_iframe(std::move(is_in_iframe_in)),
      contains_image(std::move(contains_image_in)),
      is_same_host(std::move(is_same_host_in)),
      is_url_incremented_by_one(std::move(is_url_incremented_by_one_in)),
      source_url(std::move(source_url_in)),
      target_url(std::move(target_url_in)) {}

AnchorElementMetrics::~AnchorElementMetrics() = default;

void AnchorElementMetrics::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_area"), this->ratio_area, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_visible_area"), this->ratio_visible_area, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_top_to_visible_top"), this->ratio_distance_top_to_visible_top, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_center_to_visible_top"), this->ratio_distance_center_to_visible_top, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_root_top"), this->ratio_distance_root_top, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_root_bottom"), this->ratio_distance_root_bottom, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_in_iframe"), this->is_in_iframe, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_image"), this->contains_image, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_same_host"), this->is_same_host, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_url_incremented_by_one"), this->is_url_incremented_by_one, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_url"), this->source_url, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url, 
      "<value of type const ::blink::KURL&>");
}

bool AnchorElementMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AnchorElementMetricsHost::Name_[] = "blink.mojom.AnchorElementMetricsHost";

AnchorElementMetricsHostProxy::AnchorElementMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnchorElementMetricsHostProxy::ReportAnchorElementMetricsOnClick(
    AnchorElementMetricsPtr in_metrics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AnchorElementMetricsHost::ReportAnchorElementMetricsOnClick", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metrics"), in_metrics, 
                        "<value of type AnchorElementMetricsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metrics)::BaseType> metrics_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::AnchorElementMetricsDataView>(
      in_metrics, metrics_fragment);
  params->metrics.Set(
      metrics_fragment.is_null() ? nullptr : metrics_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metrics.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metrics in AnchorElementMetricsHost.ReportAnchorElementMetricsOnClick request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementMetricsOnClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AnchorElementMetricsHostProxy::ReportAnchorElementMetricsOnLoad(
    WTF::Vector<AnchorElementMetricsPtr> in_metrics, const ::gfx::Size& in_viewport_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AnchorElementMetricsHost::ReportAnchorElementMetricsOnLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metrics"), in_metrics, 
                        "<value of type WTF::Vector<AnchorElementMetricsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("viewport_size"), in_viewport_size, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metrics)::BaseType>
      metrics_fragment(params.message());
  const mojo::internal::ContainerValidateParams metrics_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AnchorElementMetricsDataView>>(
      in_metrics, metrics_fragment, &metrics_validate_params);
  params->metrics.Set(
      metrics_fragment.is_null() ? nullptr : metrics_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metrics.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metrics in AnchorElementMetricsHost.ReportAnchorElementMetricsOnLoad request");
  mojo::internal::MessageFragment<
      typename decltype(params->viewport_size)::BaseType> viewport_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_viewport_size, viewport_size_fragment);
  params->viewport_size.Set(
      viewport_size_fragment.is_null() ? nullptr : viewport_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->viewport_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null viewport_size in AnchorElementMetricsHost.ReportAnchorElementMetricsOnLoad request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementMetricsOnLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AnchorElementMetricsHostStubDispatch::Accept(
    AnchorElementMetricsHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementMetricsOnClick",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementMetricsOnClick");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AnchorElementMetricsPtr p_metrics{};
      AnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetrics(&p_metrics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementMetricsOnClick(
std::move(p_metrics));
      return true;
    }
    case internal::kAnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementMetricsOnLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementMetricsOnLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<AnchorElementMetricsPtr> p_metrics{};
      ::gfx::Size p_viewport_size{};
      AnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetrics(&p_metrics))
        success = false;
      if (success && !input_data_view.ReadViewportSize(&p_viewport_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementMetricsOnLoad(
std::move(p_metrics), 
std::move(p_viewport_size));
      return true;
    }
  }
  return false;
}

// static
bool AnchorElementMetricsHostStubDispatch::AcceptWithResponder(
    AnchorElementMetricsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_Name: {
      break;
    }
    case internal::kAnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAnchorElementMetricsHostValidationInfo[] = {
    {&internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnClick_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AnchorElementMetricsHost_ReportAnchorElementMetricsOnLoad_Params_Data::Validate,
     nullptr /* no response */},
};

bool AnchorElementMetricsHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::AnchorElementMetricsHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAnchorElementMetricsHostValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AnchorElementMetrics::DataView, ::blink::mojom::blink::AnchorElementMetricsPtr>::Read(
    ::blink::mojom::blink::AnchorElementMetrics::DataView input,
    ::blink::mojom::blink::AnchorElementMetricsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementMetricsPtr result(::blink::mojom::blink::AnchorElementMetrics::New());
  
      if (success)
        result->ratio_area = input.ratio_area();
      if (success)
        result->ratio_visible_area = input.ratio_visible_area();
      if (success)
        result->ratio_distance_top_to_visible_top = input.ratio_distance_top_to_visible_top();
      if (success)
        result->ratio_distance_center_to_visible_top = input.ratio_distance_center_to_visible_top();
      if (success)
        result->ratio_distance_root_top = input.ratio_distance_root_top();
      if (success)
        result->ratio_distance_root_bottom = input.ratio_distance_root_bottom();
      if (success)
        result->is_in_iframe = input.is_in_iframe();
      if (success)
        result->contains_image = input.contains_image();
      if (success)
        result->is_same_host = input.is_same_host();
      if (success)
        result->is_url_incremented_by_one = input.is_url_incremented_by_one();
      if (success && !input.ReadSourceUrl(&result->source_url))
        success = false;
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif