// third_party/blink/public/mojom/locks/lock_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/locks/lock_manager.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/locks/lock_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string LockModeToString(LockMode value) {
  switch(value) {
    case LockMode::SHARED:
      return "LockMode::SHARED";
    case LockMode::EXCLUSIVE:
      return "LockMode::EXCLUSIVE";
    default:
      return base::StringPrintf("Unknown LockMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, LockMode value) {
  return os << LockModeToString(value);
}

std::string LockManager_WaitModeToString(LockManager_WaitMode value) {
  switch(value) {
    case LockManager_WaitMode::WAIT:
      return "LockManager_WaitMode::WAIT";
    case LockManager_WaitMode::NO_WAIT:
      return "LockManager_WaitMode::NO_WAIT";
    case LockManager_WaitMode::PREEMPT:
      return "LockManager_WaitMode::PREEMPT";
    default:
      return base::StringPrintf("Unknown LockManager_WaitMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, LockManager_WaitMode value) {
  return os << LockManager_WaitModeToString(value);
}

namespace internal {


// static
bool LockInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LockInfo_Data* object = static_cast<const LockInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::LockMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams client_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->client_id, validation_context,
                                         &client_id_validate_params)) {
    return false;
  }

  return true;
}

LockInfo_Data::LockInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LockRequest_Granted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LockRequest_Granted_Params_Data* object = static_cast<const LockRequest_Granted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->lock_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->lock_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LockRequest_Granted_Params_Data::LockRequest_Granted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LockRequest_Failed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LockRequest_Failed_Params_Data* object = static_cast<const LockRequest_Failed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LockRequest_Failed_Params_Data::LockRequest_Failed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LockRequest_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LockRequest_Abort_Params_Data* object = static_cast<const LockRequest_Abort_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reason, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams reason_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reason, validation_context,
                                         &reason_validate_params)) {
    return false;
  }

  return true;
}

LockRequest_Abort_Params_Data::LockRequest_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LockManager_RequestLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LockManager_RequestLock_Params_Data* object = static_cast<const LockManager_RequestLock_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::LockMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::blink::mojom::internal::LockManager_WaitMode_Data
        ::Validate(object->wait, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->request, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->request,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LockManager_RequestLock_Params_Data::LockManager_RequestLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LockManager_QueryState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LockManager_QueryState_Params_Data* object = static_cast<const LockManager_QueryState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LockManager_QueryState_Params_Data::LockManager_QueryState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LockManager_QueryState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LockManager_QueryState_ResponseParams_Data* object = static_cast<const LockManager_QueryState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams requested_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->requested, validation_context,
                                         &requested_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->held, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams held_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->held, validation_context,
                                         &held_validate_params)) {
    return false;
  }

  return true;
}

LockManager_QueryState_ResponseParams_Data::LockManager_QueryState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::LockMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::LockMode value) {
  return std::move(context).WriteString(::blink::mojom::LockModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::LockManager_WaitMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::LockManager_WaitMode value) {
  return std::move(context).WriteString(::blink::mojom::LockManager_WaitModeToString(value));
}

} // namespace perfetto
