// third_party/blink/public/mojom/manifest/manifest.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-params-data.h"
namespace blink {
namespace mojom {

std::string ManifestImageResource_PurposeToString(ManifestImageResource_Purpose value) {
  switch(value) {
    case ManifestImageResource_Purpose::ANY:
      return "ManifestImageResource_Purpose::ANY";
    case ManifestImageResource_Purpose::MONOCHROME:
      return "ManifestImageResource_Purpose::MONOCHROME";
    case ManifestImageResource_Purpose::MASKABLE:
      return "ManifestImageResource_Purpose::MASKABLE";
    default:
      return base::StringPrintf("Unknown ManifestImageResource_Purpose value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ManifestImageResource_Purpose value) {
  return os << ManifestImageResource_PurposeToString(value);
}

std::string ManifestShareTarget_MethodToString(ManifestShareTarget_Method value) {
  switch(value) {
    case ManifestShareTarget_Method::kGet:
      return "ManifestShareTarget_Method::kGet";
    case ManifestShareTarget_Method::kPost:
      return "ManifestShareTarget_Method::kPost";
    default:
      return base::StringPrintf("Unknown ManifestShareTarget_Method value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Method value) {
  return os << ManifestShareTarget_MethodToString(value);
}

std::string ManifestShareTarget_EnctypeToString(ManifestShareTarget_Enctype value) {
  switch(value) {
    case ManifestShareTarget_Enctype::kFormUrlEncoded:
      return "ManifestShareTarget_Enctype::kFormUrlEncoded";
    case ManifestShareTarget_Enctype::kMultipartFormData:
      return "ManifestShareTarget_Enctype::kMultipartFormData";
    default:
      return base::StringPrintf("Unknown ManifestShareTarget_Enctype value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ManifestShareTarget_Enctype value) {
  return os << ManifestShareTarget_EnctypeToString(value);
}

namespace internal {


// static
bool Manifest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 152, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Manifest_Data* object = static_cast<const Manifest_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->short_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_url, validation_context))
    return false;


  if (!::blink::mojom::internal::DisplayMode_Data
        ::Validate(object->display, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_override, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams display_override_validate_params(
      0, ::blink::mojom::internal::DisplayMode_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->display_override, validation_context,
                                         &display_override_validate_params)) {
    return false;
  }


  if (!::device::mojom::internal::ScreenOrientationLockType_Data
        ::Validate(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams icons_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screenshots, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams screenshots_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->screenshots, validation_context,
                                         &screenshots_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shortcuts, 10, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams shortcuts_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shortcuts, validation_context,
                                         &shortcuts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->share_target, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_handlers, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams file_handlers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_handlers, validation_context,
                                         &file_handlers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol_handlers, 13, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams protocol_handlers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->protocol_handlers, validation_context,
                                         &protocol_handlers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_handlers, 14, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams url_handlers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url_handlers, validation_context,
                                         &url_handlers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->related_applications, 15, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams related_applications_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->related_applications, validation_context,
                                         &related_applications_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->gcm_sender_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scope, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scope, validation_context))
    return false;


  if (!::blink::mojom::internal::CaptureLinks_Data
        ::Validate(object->capture_links, validation_context))
    return false;

  return true;
}

Manifest_Data::Manifest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestShortcutItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestShortcutItem_Data* object = static_cast<const ManifestShortcutItem_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->short_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams icons_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  return true;
}

ManifestShortcutItem_Data::ManifestShortcutItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestImageResource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestImageResource_Data* object = static_cast<const ManifestImageResource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sizes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sizes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sizes, validation_context,
                                         &sizes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purpose, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams purpose_validate_params(
      0, ::blink::mojom::internal::ManifestImageResource_Purpose_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->purpose, validation_context,
                                         &purpose_validate_params)) {
    return false;
  }

  return true;
}

ManifestImageResource_Data::ManifestImageResource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestFileFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestFileFilter_Data* object = static_cast<const ManifestFileFilter_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accept, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams accept_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->accept, validation_context,
                                         &accept_validate_params)) {
    return false;
  }

  return true;
}

ManifestFileFilter_Data::ManifestFileFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestProtocolHandler_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestProtocolHandler_Data* object = static_cast<const ManifestProtocolHandler_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->protocol, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ManifestProtocolHandler_Data::ManifestProtocolHandler_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestUrlHandler_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestUrlHandler_Data* object = static_cast<const ManifestUrlHandler_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

ManifestUrlHandler_Data::ManifestUrlHandler_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestRelatedApplication_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestRelatedApplication_Data* object = static_cast<const ManifestRelatedApplication_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->platform, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

ManifestRelatedApplication_Data::ManifestRelatedApplication_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestShareTargetParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestShareTargetParams_Data* object = static_cast<const ManifestShareTargetParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams files_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->files, validation_context,
                                         &files_validate_params)) {
    return false;
  }

  return true;
}

ManifestShareTargetParams_Data::ManifestShareTargetParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestShareTarget_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestShareTarget_Data* object = static_cast<const ManifestShareTarget_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;


  if (!::blink::mojom::internal::ManifestShareTarget_Method_Data
        ::Validate(object->method, validation_context))
    return false;


  if (!::blink::mojom::internal::ManifestShareTarget_Enctype_Data
        ::Validate(object->enctype, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

ManifestShareTarget_Data::ManifestShareTarget_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestFileHandler_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestFileHandler_Data* object = static_cast<const ManifestFileHandler_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accept, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams accept_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->accept, validation_context,
                                         &accept_validate_params)) {
    return false;
  }

  return true;
}

ManifestFileHandler_Data::ManifestFileHandler_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestDebugInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestDebugInfo_Data* object = static_cast<const ManifestDebugInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_manifest, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams raw_manifest_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->raw_manifest, validation_context,
                                         &raw_manifest_validate_params)) {
    return false;
  }

  return true;
}

ManifestDebugInfo_Data::ManifestDebugInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestError_Data* object = static_cast<const ManifestError_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

ManifestError_Data::ManifestError_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestImageResource_Purpose>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ManifestImageResource_Purpose value) {
  return std::move(context).WriteString(::blink::mojom::ManifestImageResource_PurposeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestShareTarget_Method>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Method value) {
  return std::move(context).WriteString(::blink::mojom::ManifestShareTarget_MethodToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ManifestShareTarget_Enctype>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::blink::mojom::ManifestShareTarget_Enctype value) {
  return std::move(context).WriteString(::blink::mojom::ManifestShareTarget_EnctypeToString(value));
}

} // namespace perfetto
