// third_party/blink/public/mojom/manifest/manifest_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_JUMBO_H_
#include "third_party/blink/public/common/manifest/manifest_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
const char ManifestManager::Name_[] = "blink.mojom.ManifestManager";

class ManifestManager_RequestManifest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManifestManager_RequestManifest_ForwardToCallback(
      ManifestManager::RequestManifestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ManifestManager::RequestManifestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ManifestManager_RequestManifest_ForwardToCallback);
};

class ManifestManager_RequestManifestDebugInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManifestManager_RequestManifestDebugInfo_ForwardToCallback(
      ManifestManager::RequestManifestDebugInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ManifestManager::RequestManifestDebugInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ManifestManager_RequestManifestDebugInfo_ForwardToCallback);
};

ManifestManagerProxy::ManifestManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ManifestManagerProxy::RequestManifest(
    RequestManifestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ManifestManager::RequestManifest");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kManifestManager_RequestManifest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManifestManager_RequestManifest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ManifestManagerProxy::RequestManifestDebugInfo(
    RequestManifestDebugInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ManifestManager::RequestManifestDebugInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kManifestManager_RequestManifestDebugInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifestDebugInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifestDebugInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManifestManager_RequestManifestDebugInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ManifestManager_RequestManifest_ProxyToResponder {
 public:
  static ManifestManager::RequestManifestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ManifestManager_RequestManifest_ProxyToResponder> proxy(
        new ManifestManager_RequestManifest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ManifestManager_RequestManifest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ManifestManager_RequestManifest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ManifestManager_RequestManifest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ManifestManager::RequestManifestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url, const ::blink::Manifest& in_manifest);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ManifestManager_RequestManifest_ProxyToResponder);
};

bool ManifestManager_RequestManifest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ManifestManager::RequestManifestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ManifestManager_RequestManifest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManifestManager_RequestManifest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::GURL p_url{};
  ::blink::Manifest p_manifest{};
  ManifestManager_RequestManifest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadManifest(&p_manifest))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManifestManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_url), 
std::move(p_manifest));
  return true;
}

void ManifestManager_RequestManifest_ProxyToResponder::Run(
    const ::GURL& in_url, const ::blink::Manifest& in_manifest) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ManifestManager::RequestManifestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manifest"), in_manifest, 
                        "<value of type const ::blink::Manifest&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kManifestManager_RequestManifest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ");
  mojo::internal::MessageFragment<
      typename decltype(params->manifest)::BaseType> manifest_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ManifestDataView>(
      in_manifest, manifest_fragment);
  params->manifest.Set(
      manifest_fragment.is_null() ? nullptr : manifest_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ManifestManager::RequestManifestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ManifestManager_RequestManifestDebugInfo_ProxyToResponder {
 public:
  static ManifestManager::RequestManifestDebugInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ManifestManager_RequestManifestDebugInfo_ProxyToResponder> proxy(
        new ManifestManager_RequestManifestDebugInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ManifestManager_RequestManifestDebugInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ManifestManager_RequestManifestDebugInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ManifestManager_RequestManifestDebugInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ManifestManager::RequestManifestDebugInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url, const ::blink::Manifest& in_parsed_manifest, ::blink::mojom::ManifestDebugInfoPtr in_debug_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ManifestManager_RequestManifestDebugInfo_ProxyToResponder);
};

bool ManifestManager_RequestManifestDebugInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ManifestManager::RequestManifestDebugInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::GURL p_url{};
  ::blink::Manifest p_parsed_manifest{};
  ::blink::mojom::ManifestDebugInfoPtr p_debug_info{};
  ManifestManager_RequestManifestDebugInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadParsedManifest(&p_parsed_manifest))
    success = false;
  if (success && !input_data_view.ReadDebugInfo(&p_debug_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManifestManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_url), 
std::move(p_parsed_manifest), 
std::move(p_debug_info));
  return true;
}

void ManifestManager_RequestManifestDebugInfo_ProxyToResponder::Run(
    const ::GURL& in_url, const ::blink::Manifest& in_parsed_manifest, ::blink::mojom::ManifestDebugInfoPtr in_debug_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ManifestManager::RequestManifestDebugInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsed_manifest"), in_parsed_manifest, 
                        "<value of type const ::blink::Manifest&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_info"), in_debug_info, 
                        "<value of type ::blink::mojom::ManifestDebugInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kManifestManager_RequestManifestDebugInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ");
  mojo::internal::MessageFragment<
      typename decltype(params->parsed_manifest)::BaseType> parsed_manifest_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ManifestDataView>(
      in_parsed_manifest, parsed_manifest_fragment);
  params->parsed_manifest.Set(
      parsed_manifest_fragment.is_null() ? nullptr : parsed_manifest_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->debug_info)::BaseType> debug_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ManifestDebugInfoDataView>(
      in_debug_info, debug_info_fragment);
  params->debug_info.Set(
      debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ManifestManager::RequestManifestDebugInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifestDebugInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ManifestManagerStubDispatch::Accept(
    ManifestManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kManifestManager_RequestManifest_Name: {
      break;
    }
    case internal::kManifestManager_RequestManifestDebugInfo_Name: {
      break;
    }
  }
  return false;
}

// static
bool ManifestManagerStubDispatch::AcceptWithResponder(
    ManifestManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kManifestManager_RequestManifest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ManifestManager::RequestManifest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ManifestManager::RequestManifest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ManifestManager_RequestManifest_Params_Data* params =
          reinterpret_cast<
              internal::ManifestManager_RequestManifest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ManifestManager_RequestManifest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManifestManager::Name_, 0, false);
        return false;
      }
      ManifestManager::RequestManifestCallback callback =
          ManifestManager_RequestManifest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestManifest(std::move(callback));
      return true;
    }
    case internal::kManifestManager_RequestManifestDebugInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ManifestManager::RequestManifestDebugInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ManifestManager::RequestManifestDebugInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ManifestManager_RequestManifestDebugInfo_Params_Data* params =
          reinterpret_cast<
              internal::ManifestManager_RequestManifestDebugInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ManifestManager_RequestManifestDebugInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManifestManager::Name_, 1, false);
        return false;
      }
      ManifestManager::RequestManifestDebugInfoCallback callback =
          ManifestManager_RequestManifestDebugInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestManifestDebugInfo(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kManifestManagerValidationInfo[] = {
    {&internal::ManifestManager_RequestManifest_Params_Data::Validate,
     &internal::ManifestManager_RequestManifest_ResponseParams_Data::Validate},
    {&internal::ManifestManager_RequestManifestDebugInfo_Params_Data::Validate,
     &internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data::Validate},
};

bool ManifestManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ManifestManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kManifestManagerValidationInfo);
}

bool ManifestManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ManifestManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kManifestManagerValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif