// third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char RendererAudioInputStreamFactory::Name_[] = "blink.mojom.RendererAudioInputStreamFactory";

RendererAudioInputStreamFactoryProxy::RendererAudioInputStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererAudioInputStreamFactoryProxy::CreateStream(
    ::mojo::PendingRemote<RendererAudioInputStreamFactoryClient> in_client, const ::base::UnguessableToken& in_session_id, const ::media::AudioParameters& in_params, bool in_automatic_gain_control, uint32_t in_shared_memory_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RendererAudioInputStreamFactory::CreateStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<RendererAudioInputStreamFactoryClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("automatic_gain_control"), in_automatic_gain_control, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory_count"), in_shared_memory_count, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererAudioInputStreamFactory_CreateStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererAudioInputStreamFactory_CreateStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::RendererAudioInputStreamFactoryClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in RendererAudioInputStreamFactory.CreateStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in RendererAudioInputStreamFactory.CreateStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in RendererAudioInputStreamFactory.CreateStream request");
  params->automatic_gain_control = in_automatic_gain_control;
  params->shared_memory_count = in_shared_memory_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAudioInputStreamFactory::Name_);
  message.set_method_name("CreateStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererAudioInputStreamFactoryProxy::AssociateInputAndOutputForAec(
    const ::base::UnguessableToken& in_input_stream_id, const std::string& in_output_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RendererAudioInputStreamFactory::AssociateInputAndOutputForAec", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_stream_id"), in_input_stream_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_device_id"), in_output_device_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_stream_id)::BaseType> input_stream_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_input_stream_id, input_stream_id_fragment);
  params->input_stream_id.Set(
      input_stream_id_fragment.is_null() ? nullptr : input_stream_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input_stream_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_stream_id in RendererAudioInputStreamFactory.AssociateInputAndOutputForAec request");
  mojo::internal::MessageFragment<
      typename decltype(params->output_device_id)::BaseType> output_device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_output_device_id, output_device_id_fragment);
  params->output_device_id.Set(
      output_device_id_fragment.is_null() ? nullptr : output_device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->output_device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_device_id in RendererAudioInputStreamFactory.AssociateInputAndOutputForAec request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAudioInputStreamFactory::Name_);
  message.set_method_name("AssociateInputAndOutputForAec");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RendererAudioInputStreamFactoryStubDispatch::Accept(
    RendererAudioInputStreamFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRendererAudioInputStreamFactory_CreateStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RendererAudioInputStreamFactory::CreateStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RendererAudioInputStreamFactory::CreateStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererAudioInputStreamFactory_CreateStream_Params_Data* params =
          reinterpret_cast<internal::RendererAudioInputStreamFactory_CreateStream_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<RendererAudioInputStreamFactoryClient> p_client{};
      ::base::UnguessableToken p_session_id{};
      ::media::AudioParameters p_params{};
      bool p_automatic_gain_control{};
      uint32_t p_shared_memory_count{};
      RendererAudioInputStreamFactory_CreateStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_automatic_gain_control = input_data_view.automatic_gain_control();
      if (success)
        p_shared_memory_count = input_data_view.shared_memory_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererAudioInputStreamFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateStream(
std::move(p_client), 
std::move(p_session_id), 
std::move(p_params), 
std::move(p_automatic_gain_control), 
std::move(p_shared_memory_count));
      return true;
    }
    case internal::kRendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RendererAudioInputStreamFactory::AssociateInputAndOutputForAec",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RendererAudioInputStreamFactory::AssociateInputAndOutputForAec");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params_Data* params =
          reinterpret_cast<internal::RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_input_stream_id{};
      std::string p_output_device_id{};
      RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputStreamId(&p_input_stream_id))
        success = false;
      if (success && !input_data_view.ReadOutputDeviceId(&p_output_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererAudioInputStreamFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AssociateInputAndOutputForAec(
std::move(p_input_stream_id), 
std::move(p_output_device_id));
      return true;
    }
  }
  return false;
}

// static
bool RendererAudioInputStreamFactoryStubDispatch::AcceptWithResponder(
    RendererAudioInputStreamFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRendererAudioInputStreamFactory_CreateStream_Name: {
      break;
    }
    case internal::kRendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kRendererAudioInputStreamFactoryValidationInfo[] = {
    {&internal::RendererAudioInputStreamFactory_CreateStream_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::RendererAudioInputStreamFactory_AssociateInputAndOutputForAec_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererAudioInputStreamFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RendererAudioInputStreamFactory::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kRendererAudioInputStreamFactoryValidationInfo);
}

const char RendererAudioInputStreamFactoryClient::Name_[] = "blink.mojom.RendererAudioInputStreamFactoryClient";

RendererAudioInputStreamFactoryClientProxy::RendererAudioInputStreamFactoryClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererAudioInputStreamFactoryClientProxy::StreamCreated(
    ::mojo::PendingRemote<::media::mojom::AudioInputStream> in_stream, ::mojo::PendingReceiver<::media::mojom::AudioInputStreamClient> in_client_request, ::media::mojom::ReadOnlyAudioDataPipePtr in_data_pipe, bool in_initially_muted, const base::Optional<::base::UnguessableToken>& in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RendererAudioInputStreamFactoryClient::StreamCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream, 
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_request"), in_client_request, 
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioInputStreamClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe, 
                        "<value of type ::media::mojom::ReadOnlyAudioDataPipePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initially_muted"), in_initially_muted, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type const base::Optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererAudioInputStreamFactoryClient_StreamCreated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererAudioInputStreamFactoryClient_StreamCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
      in_stream, &params->stream, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in RendererAudioInputStreamFactoryClient.StreamCreated request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
      in_client_request, &params->client_request, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client_request),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client_request in RendererAudioInputStreamFactoryClient.StreamCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::ReadOnlyAudioDataPipeDataView>(
      in_data_pipe, data_pipe_fragment);
  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_pipe.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_pipe in RendererAudioInputStreamFactoryClient.StreamCreated request");
  params->initially_muted = in_initially_muted;
  mojo::internal::MessageFragment<
      typename decltype(params->stream_id)::BaseType> stream_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_stream_id, stream_id_fragment);
  params->stream_id.Set(
      stream_id_fragment.is_null() ? nullptr : stream_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAudioInputStreamFactoryClient::Name_);
  message.set_method_name("StreamCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RendererAudioInputStreamFactoryClientStubDispatch::Accept(
    RendererAudioInputStreamFactoryClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRendererAudioInputStreamFactoryClient_StreamCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RendererAudioInputStreamFactoryClient::StreamCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RendererAudioInputStreamFactoryClient::StreamCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererAudioInputStreamFactoryClient_StreamCreated_Params_Data* params =
          reinterpret_cast<internal::RendererAudioInputStreamFactoryClient_StreamCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::media::mojom::AudioInputStream> p_stream{};
      ::mojo::PendingReceiver<::media::mojom::AudioInputStreamClient> p_client_request{};
      ::media::mojom::ReadOnlyAudioDataPipePtr p_data_pipe{};
      bool p_initially_muted{};
      base::Optional<::base::UnguessableToken> p_stream_id{};
      RendererAudioInputStreamFactoryClient_StreamCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success) {
        p_client_request =
            input_data_view.TakeClientRequest<decltype(p_client_request)>();
      }
      if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
        success = false;
      if (success)
        p_initially_muted = input_data_view.initially_muted();
      if (success && !input_data_view.ReadStreamId(&p_stream_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererAudioInputStreamFactoryClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StreamCreated(
std::move(p_stream), 
std::move(p_client_request), 
std::move(p_data_pipe), 
std::move(p_initially_muted), 
std::move(p_stream_id));
      return true;
    }
  }
  return false;
}

// static
bool RendererAudioInputStreamFactoryClientStubDispatch::AcceptWithResponder(
    RendererAudioInputStreamFactoryClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRendererAudioInputStreamFactoryClient_StreamCreated_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kRendererAudioInputStreamFactoryClientValidationInfo[] = {
    {&internal::RendererAudioInputStreamFactoryClient_StreamCreated_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererAudioInputStreamFactoryClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RendererAudioInputStreamFactoryClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kRendererAudioInputStreamFactoryClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif